﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;
using ePractice.MiddleTier;
using InfoWorld.HL7.ITS;

namespace BMS.Translators
{
    public static class TranslatorBedCleanInfo
    {
        public static void CopyTo(this BedcleaninfoBO bedCleanInfoBO, DataContracts.BedCleanInfo bedCleanInfo)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedCleanInfo.Id = BuildIdentifierInt(bedCleanInfoBO.DOMAIN_ID, bedCleanInfoBO.ID);
                bedCleanInfo.BedId = BuildIdentifier(bedCleanInfoBO.DOMAIN_ID, bedCleanInfoBO.BED_UID);
                bedCleanInfo.WardId = BuildIdentifier(bedCleanInfoBO.DOMAIN_ID, bedCleanInfoBO.WARD_UID);
                bedCleanInfo.ManualRequest = TranslatorUtils.BuildConcept(bedCleanInfoBO.MANUAL_REQUEST_CODE, bedCleanInfoBO.MANUAL_REQUEST_CODE_SYSTEM, bedCleanInfoBO.MANUAL_REQUEST_CODE_SYSTEM_NAME, bedCleanInfoBO.MANUAL_REQUEST_DISPLAY_NAME);
                bedCleanInfo.VacatedDate = bedCleanInfoBO.VACATED_DATE.Value;
                bedCleanInfo.RequestedDate = bedCleanInfoBO.REQUESTED_DATE.Value;
                bedCleanInfo.AcceptedBy = bedCleanInfoBO.ACCEPTED_BY.Value;
                bedCleanInfo.AcceptedDate = bedCleanInfoBO.ACCEPTED_DATE.Value;
                bedCleanInfo.CompletedBy = bedCleanInfoBO.COMPLETED_BY.Value;
                bedCleanInfo.CompletedDate = bedCleanInfoBO.COMPLETED_DATE.Value;
                bedCleanInfo.LastEditedBy = bedCleanInfoBO.LAST_EDITED_BY.Value;
                bedCleanInfo.LastEditDate = bedCleanInfoBO.LAST_EDIT_DATE.Value;
                bedCleanInfo.UnavailableType = TranslatorUtils.BuildConcept(bedCleanInfoBO.UNAVAILABLE_TYPE_CODE, bedCleanInfoBO.UNAVAILABLE_TYPE_CODE_SYSTEM, bedCleanInfoBO.UNAVAILABLE_TYPE_CODE_SYSTEM_NAME, bedCleanInfoBO.UNAVAILABLE_TYPE_DISPLAY_NAME);
                bedCleanInfo.EMSNotify = bedCleanInfoBO.EMS_NOTIFY.Value;
                bedCleanInfo.Comment = bedCleanInfoBO.COMMENT.Value;
                bedCleanInfo.CommentedBy = bedCleanInfoBO.COMMENTED_BY.Value;
                bedCleanInfo.CommentedDate = bedCleanInfoBO.COMMENTED_DATE.Value;
                bedCleanInfo.EventIen = bedCleanInfoBO.EVENT_IEN.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private static II BuildIdentifierInt(IField<string> root, IField<int> extension)
        {
            if (string.IsNullOrEmpty(extension.Value.ToString()))
                return null;
            return new II(root.Value, extension.Value.ToString());
        }

        private static II BuildIdentifier(IField<string> root, IField<Guid> extension)
        {
            if (extension.Value == null || extension.Value.Equals(Guid.Empty))
                return null;
            return new II(root.Value, extension.Value.ToString());
        }
    }
}
