﻿using BMS.MT;
using System;
using BMS.Utils;
using System.Collections.Generic;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorAdmissionInfo
    {
        public static void CopyTo(this AdmissionInfoBO admissionInfoBO, DataContracts.AdmissionInfo admissionInfo)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                admissionInfo.CanceledDate = admissionInfoBO.CANCELED_DATE.Value;
                admissionInfo.CreationDate = admissionInfoBO.CREATION_DATE.Value;
                admissionInfo.Id = TranslatorUtils.BuildIdentifier(admissionInfoBO.DOMAIN_ID, admissionInfoBO.ACT_ID);
                admissionInfo.Parent = TranslatorUtils.BuildParentAct(TranslatorUtils.BuildIdentifier(admissionInfoBO.DOMAIN_ID, admissionInfoBO.PARENT_ACT_ID));
                admissionInfo.PatientId = TranslatorUtils.BuildIdentifier(admissionInfoBO.DOMAIN_ID, admissionInfoBO.PATIENT_UID);
                admissionInfo.FlowId = admissionInfoBO.FLOW_ID.Value;
                admissionInfo.Authorization = TranslatorUtils.BuildConcept(admissionInfoBO.AUTHORIZED_FEE_CODE, admissionInfoBO.AUTHORIZED_FEE_CODE_SYSTEM, admissionInfoBO.AUTHORIZED_FEE_CODE_SYSTEM_NAME, admissionInfoBO.AUTHORIZED_FEE_DISPLAY_NAME);
                admissionInfo.CommentFee = admissionInfoBO.FEE_COMMENTS.Value;
                admissionInfo.Contract = TranslatorUtils.BuildConcept(admissionInfoBO.CONTRACT_FEE_CODE, admissionInfoBO.CONTRACT_FEE_CODE_SYSTEM, admissionInfoBO.CONTRACT_FEE_CODE_SYSTEM_NAME, admissionInfoBO.CONTRACT_FEE_DISPLAY_NAME);
                admissionInfo.Problem = admissionInfoBO.PROBLEM.Value;
                admissionInfo.ReasonFee = TranslatorUtils.BuildConcept(admissionInfoBO.REASON_USING_FEE_CODE, admissionInfoBO.REASON_USING_FEE_CODE_SYSTEM, admissionInfoBO.REASON_USING_FEE_CODE_SYSTEM_NAME, admissionInfoBO.REASON_USING_FEE_DISPLAY_NAME);
                admissionInfo.RemovedDate = admissionInfoBO.REMOVED_DATE.Value;
                admissionInfo.ServiceReceive = TranslatorUtils.BuildConcept(admissionInfoBO.SERVICE_RECEIVING_FEE_CODE, admissionInfoBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM, admissionInfoBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME, admissionInfoBO.SERVICE_RECEIVING_FEE_DISPLAY_NAME);
                admissionInfo.TypeOfBedWard = admissionInfoBO.TYPE_OF_BED_WARD.Value;
                admissionInfo.WaitingArea = TranslatorUtils.BuildConcept(admissionInfoBO.WAITING_AREA_CODE, admissionInfoBO.WAITING_AREA_CODE_SYSTEM, admissionInfoBO.WAITING_AREA_CODE_SYSTEM_NAME, admissionInfoBO.WAITING_AREA_DISPLAY_NAME);
                admissionInfo.AssignedBedId = TranslatorUtils.BuildIdentifier(admissionInfoBO.DOMAIN_ID, admissionInfoBO.REQUESTED_BED_UID);
                admissionInfo.BedAssignedDate = admissionInfoBO.REQUESTED_BED_DATE.Value;
                //Re-Adding Wait Time change from C73035                
                if (!admissionInfo.RemovedDate.HasValue)
                    admissionInfo.WaitTime = DateTime.UtcNow - admissionInfo.CreationDate;
                else
                    admissionInfo.WaitTime = admissionInfo.RemovedDate - admissionInfo.CreationDate;
                admissionInfo.RequestedDate = admissionInfoBO.REQUESTED_DATE.Value;
                admissionInfo.FeeDisposition = TranslatorUtils.BuildConcept(admissionInfoBO.FEE_DISPOSITION_CODE, admissionInfoBO.FEE_DISPOSITION_CODE_SYSTEM, admissionInfoBO.FEE_DISPOSITION_CODE_SYSTEM_NAME, admissionInfoBO.FEE_DISPOSITION_DISPLAY_NAME);
                admissionInfo.IsInHouse = admissionInfoBO.IS_IN_HOUSE.Value;
                admissionInfo.IsBedInIsolation = admissionInfoBO.IS_BED_IN_ISOLATION.Value;
                admissionInfo.LastEditBy = admissionInfoBO.LAST_EDIT_BY.Value;
                admissionInfo.Comment = admissionInfoBO.COMMENTS.Value;
                admissionInfo.WaitTimeAlertDate = admissionInfoBO.WAIT_TIME_ALERT_DATE.Value;
                admissionInfo.IsCommunityLivingCenter = admissionInfoBO.IS_COMMUNITY_LIVING_CENTER.Value;
                admissionInfo.DateOfScreening = admissionInfoBO.DATE_OF_SCREENING.Value;
                admissionInfo.VeteranPreference = admissionInfoBO.VETERAN_PREFERENCE.Value;
                admissionInfo.MentalHealthComment = admissionInfoBO.MENTAL_HEALTH_COMMENTS.Value;
                admissionInfo.TransportationComment = admissionInfoBO.EVACUATION_TRANSPORTATION_COMMENTS.Value;
                admissionInfo.PatientFlowComment = admissionInfoBO.PATIENT_FLOW_COMMENTS.Value;
                admissionInfo.FeeAccepted = admissionInfoBO.FEE_ACCEPTED.Value;
                admissionInfo.EvacExpectedPickUp = admissionInfoBO.EVACUATION_EXPECTED_DATE.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
