﻿using BMS.MT;
using System;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class BedStaffHistoryTranslator
    {
        public static void CopyTo(this BedStaffHistoryBO bedStaffHistoryBO, DataContracts.BedStaffHistory bedStaffHistory, string domainId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedStaffHistory.Id = (bedStaffHistoryBO.PK.Value.HasValue) ? bedStaffHistoryBO.PK.Value.Value : -1;
                bedStaffHistory.BedId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffHistoryBO.BED_UID.Value.HasValue) ? bedStaffHistoryBO.BED_UID.Value.Value.ToString() : null);
                bedStaffHistory.DivisionId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffHistoryBO.DIVISION_UID.Value.HasValue) ? bedStaffHistoryBO.DIVISION_UID.Value.Value.ToString() : null);
                bedStaffHistory.Staff = bedStaffHistoryBO.STAFF.Value;
                bedStaffHistory.PatientId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffHistoryBO.PATIENT_UID.Value.HasValue) ? bedStaffHistoryBO.PATIENT_UID.Value.Value.ToString() : null);
                bedStaffHistory.FacilityId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffHistoryBO.FACILITY_UID.Value.HasValue) ? bedStaffHistoryBO.FACILITY_UID.Value.Value.ToString() : null);
                bedStaffHistory.CreatedBy = bedStaffHistoryBO.CREATED_BY.Value;
                bedStaffHistory.CreationDate = bedStaffHistoryBO.CREATED_DATE.Value;
                bedStaffHistory.TransactionTypeCode = bedStaffHistoryBO.TRANSACTION_TYPE_CODE.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
