﻿using InfoWorld.HL7.ITS;
using BMS.ServiceContracts;
using System.ServiceModel;
using BMS.MT;
using System;
using ePractice.MiddleTier;
using BMS.Translators;
using BMS.Utils;
using System.Transactions;
using System.Collections.Generic;
using BMS.DataContracts;
using BMS.ServiceImplementation.Properties;
using BMS.ServiceImplementation.Utils;
using System.Linq;
using DC = BMS.DataContracts;
using System.Text;

namespace BMS.ServiceImplementation
{
    [ErrorHandlerAttribute]
    [ServiceBehavior(IgnoreExtensionDataObject = true, InstanceContextMode = InstanceContextMode.PerSession, ConcurrencyMode = ConcurrencyMode.Multiple, IncludeExceptionDetailInFaults = true, UseSynchronizationContext = false)]
    public class BedManagerQueryCore : IBedManagerQuery
    {
        public IList<DataContracts.AdmissionInfo> FilterAdmissions(Guid facilityUid, DateTime admissionCreationTime, bool isOnlyCurrentWaitingAdmission, bool isOnlyInHouseWaitingAdmission, bool isMentalHealth, bool isEmergencyManagement)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.AdmissionInfo> admissionInfoList = new List<DataContracts.AdmissionInfo>();
                try
                {
                    AdmissionInfoParPO parameters = (AdmissionInfoParPO)MTServices.Instance[Resources.MT_AdmissionInfo].Parameters;
                    parameters.FACILITY_UID.Value = facilityUid;
                    parameters.CREATION_DATE.Value = admissionCreationTime;
                    parameters.IS_ONLY_CURRENT_WAITING_ADMISSION.Value = isOnlyCurrentWaitingAdmission;
                    parameters.IS_ONLY_IN_HOUSE_WAITING_LIST.Value = isOnlyInHouseWaitingAdmission;
                    parameters.IS_MENTAL_HEALTH.Value = isMentalHealth;
                    parameters.IS_EMERGENCY_MANAGEMENT.Value = isEmergencyManagement;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_AdmissionInfo].GetEntities(parameters);

                    DataContracts.AdmissionInfo admissionInfo = null;
                    foreach (AdmissionInfoBO bo in listWrapper.ChildList)
                    {
                        admissionInfo = new DataContracts.AdmissionInfo();
                        bo.CopyTo(admissionInfo);
                        admissionInfoList.Add(admissionInfo);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return admissionInfoList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.BedDNDAndOOS> FilterBedsDNDAndOOS(string wardList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.BedDNDAndOOS> bedDNDAndOOSList = new List<BedDNDAndOOS>();
                try
                {
                    BedDNDAndOOSFromVistaParPO parameters = (BedDNDAndOOSFromVistaParPO)MTServices.Instance[Resources.MT_BedDNDAndOOS].Parameters;
                    parameters.WARD_LIST.Value = wardList;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_BedDNDAndOOS].GetEntities(parameters);
                    DataContracts.BedDNDAndOOS bed = null;
                    foreach (BedDndAndOOSFromVistaBO bo in listWrapper.ChildList)
                    {
                        bed = new BedDNDAndOOS()
                        {
                            BedId = new II(string.Empty, bo.BED_UID.Value.ToString()),
                            IsUnavailableFromVista = bo.IS_UNAVAILABLE_FROM_VISTA.Value,
                            UnavailableTypeCode = bo.UNAVAILABLE_TYPE_CODE.Value
                        };
                        bedDNDAndOOSList.Add(bed);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return bedDNDAndOOSList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }

        }

        public IList<DataContracts.BedOccupancyInfo> FilterBedOccupancy(string wardList, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.BedOccupancyInfo> bedOccupancyInfoList = new List<DataContracts.BedOccupancyInfo>();
                try
                {
                    BedoccupancyInfoParPO parameters = (BedoccupancyInfoParPO)MTServices.Instance[Resources.MT_BedOccupancyInfo].Parameters;
                    parameters.WARD_LIST.Value = wardList;
                    parameters.FACILITY_UID.Value = Guid.Parse(facilityId.extension);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_BedOccupancyInfo].GetEntities(parameters);
                    listWrapper.ChildList.CopyTo(bedOccupancyInfoList);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return bedOccupancyInfoList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        IList<DataContracts.TransferInfo> IBedManagerQuery.FilterTransfers(Guid? facilityUid, string facilityVISN)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.TransferInfo> transferInfoList = new List<DataContracts.TransferInfo>();
                try
                {
                    TransferInfoParPO parameters = (TransferInfoParPO)MTServices.Instance[Resources.MT_TransferInfo].Parameters;
                    parameters.FACILITY_UID.Value = facilityUid;
                    parameters.FACILITY_VISN.Value = facilityVISN;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_TransferInfo].GetEntities(parameters);
                    DataContracts.TransferInfo transferInfo = null;
                    foreach (TransferInfoBO bo in listWrapper.ChildList)
                    {
                        transferInfo = new DataContracts.TransferInfo();
                        bo.CopyTo(transferInfo);
                        transferInfoList.Add(transferInfo);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return transferInfoList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public IList<DataContracts.PatientWaitingStandardView> FilterNationalPatientWaitingStandardView(bool isDisplayOnlyNationalPatients, string facilityRegion, string facilityVISN, string specialtyCode, string specialtyCodeSystem, DateTime transferEventDate, bool isCurrentWaitingList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.PatientWaitingStandardView> patientsWaitingList = new List<DataContracts.PatientWaitingStandardView>();
                try
                {
                    PatientWaitingStandardViewParPO parameters = (PatientWaitingStandardViewParPO)MTServices.Instance[Resources.MT_PatientWaitingStandardView].Parameters;
                    parameters.FACILITY_REGION.Value = facilityRegion;
                    parameters.FACILITY_VISN.Value = facilityVISN;
                    parameters.SPECIALTY_CODE.Value = specialtyCode;
                    parameters.SPECIALTY_CODE_SYSTEM.Value = specialtyCodeSystem;
                    parameters.CREATION_DATE.Value = transferEventDate;
                    parameters.IS_CURRENT_WAITING_LIST.Value = isCurrentWaitingList;
                    parameters.IS_DISPLAY_ONLY_NATIONAL_PATIENTS.Value = isDisplayOnlyNationalPatients;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_PatientWaitingStandardView].GetEntities(parameters);
                    DataContracts.PatientWaitingStandardView patientWaiting = null;
                    foreach (PatientWaitingStandardViewBO bo in listWrapper.ChildList)
                    {
                        patientWaiting = new DataContracts.PatientWaitingStandardView();
                        bo.CopyTo(patientWaiting);
                        patientsWaitingList.Add(patientWaiting);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return patientsWaitingList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public IList<DataContracts.PatientWaitingDateView> FilterNationalPatientWaitingDateView(bool isDisplayOnlyNationalPatients, string facilityRegion, string facilityVISN, string specialtyCode, string specialtyCodeSystem, DateTime transferEventDate, bool isCurrentWaitingList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.PatientWaitingDateView> patientsWaitingList = new List<DataContracts.PatientWaitingDateView>();
                try
                {
                    PatientWaitingDateViewParPO parameters = (PatientWaitingDateViewParPO)MTServices.Instance[Resources.MT_PatientWaitingDateView].Parameters;
                    parameters.FACILITY_REGION.Value = facilityRegion;
                    parameters.FACILITY_VISN.Value = facilityVISN;
                    parameters.SPECIALTY_CODE.Value = specialtyCode;
                    parameters.SPECIALTY_CODE_SYSTEM.Value = specialtyCodeSystem;
                    parameters.CREATION_DATE.Value = transferEventDate;
                    parameters.IS_CURRENT_WAITING_LIST.Value = isCurrentWaitingList;
                    parameters.IS_DISPLAY_ONLY_NATIONAL_PATIENTS.Value = isDisplayOnlyNationalPatients;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_PatientWaitingDateView].GetEntities(parameters);
                    DataContracts.PatientWaitingDateView patientWaiting = null;
                    foreach (PatientWaitingDateViewBO bo in listWrapper.ChildList)
                    {
                        patientWaiting = new DataContracts.PatientWaitingDateView();
                        bo.CopyTo(patientWaiting);
                        patientsWaitingList.Add(patientWaiting);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return patientsWaitingList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<DataContracts.NewEvent> GetNewEvents(string wardUidList, Guid facilityUid, int timeZoneMinutesOffset)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.NewEvent> newEvents = new List<DataContracts.NewEvent>();

                NewEventParPO parameters = (NewEventParPO)MTServices.Instance[Resources.MT_NewEvents].Parameters;
                parameters.WARD_LIST.Value = wardUidList;
                parameters.FACILITY_UID.Value = facilityUid;
                parameters.TIMEZONEMINUTESOFFSET.Value = timeZoneMinutesOffset;

                IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_NewEvents].GetEntities(parameters);
                DataContracts.NewEvent newEvent = null;
                foreach (NewEventBO bo in listWrapper.ChildList)
                {
                    newEvent = new DataContracts.NewEvent();
                    bo.CopyTo(newEvent);
                    newEvents.Add(newEvent);
                }

                return newEvents;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Filters the bed clean.
        /// </summary>
        /// <param name="divisionUid">Division uid.</param>
        /// <param name="startDate">Start date.</param>
        /// <param name="endDate">End date.</param>
        /// <returns>List of bed clean info.</returns>
        public IList<DataContracts.BedCleanInfo> FilterBedClean(string wardList, DateTime startDate, DateTime endDate)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.BedCleanInfo> bedCleanInfoList = new List<DataContracts.BedCleanInfo>();

                try
                {
                    BedcleaninfoparPO parameters = (BedcleaninfoparPO)MTServices.Instance[Resources.MT_BedCleanInfo].Parameters;
                    parameters.WARD_LIST.Value = wardList;
                    parameters.START_DATE.Value = startDate;
                    parameters.END_DATE.Value = endDate;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_BedCleanInfo].GetEntities(parameters);
                    DataContracts.BedCleanInfo bedCleanInfo = null;
                    foreach (BedcleaninfoBO bo in listWrapper.ChildList)
                    {
                        bedCleanInfo = new DataContracts.BedCleanInfo();
                        bo.CopyTo(bedCleanInfo);
                        bedCleanInfoList.Add(bedCleanInfo);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return bedCleanInfoList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<JobLogInfo> FilterLogData(IList<string> vistaIds, IList<DataRetrievalMethod> retrievalMethods, IList<VistaDataType> dataTypes, DateTime startDate, DateTime? endDate, IList<JobStatus> status, PagingContext pagingContext, bool is_view_only_last_information)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<JobLogInfo> logInfoList = new List<JobLogInfo>();
                try
                {
                    PagingSortSection pagingSortSection = System.Configuration.ConfigurationManager.GetSection("pagingSortGroup") as PagingSortSection;

                    JobAuditInfoParPO parameters = (JobAuditInfoParPO)MTServices.Instance[Resources.MT_JobAuditInfo].Parameters;
                    parameters.VISTA_ID.Value = vistaIds.Aggregate((ids, next) => ids + "," + next);
                    parameters.RETRIEVAL_METHOD.Value = (byte)retrievalMethods.Aggregate((methods, next) => methods | next);
                    parameters.RETRIEVED_DATA_TYPE.Value = (int)dataTypes.Aggregate((dataType, next) => dataType | next);
                    parameters.START_DATE.Value = startDate;
                    parameters.END_DATE.Value = endDate;
                    parameters.STATUS.Value = (byte)status.Aggregate((s, next) => s | next);
                    parameters.PAGE_NUMBER.Value = pagingContext.PageNumber;
                    parameters.PAGE_SIZE.Value = pagingContext.PageSize;
                    parameters.IS_VIEW_ONLY_LAST_INFORMATION.Value = is_view_only_last_information;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_JobAuditInfo].GetEntities(parameters);

                    JobLogInfo jobLogInfo = null;

                    foreach (JobAuditInfoBO bo in listWrapper.ChildList)
                    {
                        jobLogInfo = new JobLogInfo();
                        bo.CopyTo(jobLogInfo);
                        logInfoList.Add(jobLogInfo);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return logInfoList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public Act GetLastAct(II patientId, ActType actType, II vistaSiteId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    LastActInfoParPO parameters = (LastActInfoParPO)MTServices.Instance[Resources.MT_LastActInfo].Parameters;
                    parameters.PATIENT_UID.Value = new Guid(patientId.extension);
                    parameters.VISTA_SITE_UID.Value = new Guid(vistaSiteId.extension);
                    switch (actType)
                    {
                        case ActType.AdmissionOrder:
                            parameters.ACT_TYPE.Value = Resources.AdmissionOrderActType; break;
                        case ActType.MovementOrder:
                            parameters.ACT_TYPE.Value = Resources.MovementOrderActType; break;
                        case ActType.PatientAppointment:
                            parameters.ACT_TYPE.Value = Resources.PatientAppointmentActType; break;
                        case ActType.DischargeOrder:
                            parameters.ACT_TYPE.Value = Resources.DischargeOrderActType; break;
                        case ActType.All:
                            parameters.ACT_TYPE.Value = null; break;
                    }
                    IEntityBase entity = MTServices.Instance[Resources.MT_LastActInfo].GetEntity(parameters);

                    LastActInfoBO ai = (entity as LastActInfoBO);
                    if (ai != null)
                        return new Act()
                        {
                            CreationDate = ai.CREATION_DATE.Value,
                            IEN = ai.IEN.Value,
                            PatientId = patientId,
                            Id = TranslatorUtils.BuildIdentifier(ai.DOMAIN_ID, ai.ACT_ID),
                            Parent = TranslatorUtils.BuildParentAct(TranslatorUtils.BuildIdentifier(ai.DOMAIN_ID, ai.PARENT_ACT_ID)),
                            FlowId = ai.FLOW_ID.Value
                        };
                    else
                        return null;
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<DataContracts.BedOccupancyCount> GetPercentageOfOccupancy(string vistaSitesList, string wardsList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.BedOccupancyCount> occupancyList = new List<DataContracts.BedOccupancyCount>();
                try
                {

                    BedoccupancycountparPO parameters = (BedoccupancycountparPO)MTServices.Instance[Resources.MT_BedOccupancyCount].Parameters;
                    parameters.VISTA_SITE_LIST.Value = vistaSitesList;
                    parameters.WARD_LIST.Value = wardsList;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_BedOccupancyCount].GetEntities(parameters);
                    DataContracts.BedOccupancyCount bedOccupancy = null;
                    foreach (BedOccupancyCountBO bo in listWrapper.ChildList)
                    {
                        bedOccupancy = new DataContracts.BedOccupancyCount();
                        bo.CopyTo(bedOccupancy);
                        occupancyList.Add(bedOccupancy);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return occupancyList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public PatientWaitingCount GetPatientsWaitingCount(Guid facilityUid, Guid vistaSiteUid, string vistaDivisionCode, int timeZoneOffset)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                PatientWaitingCount count = null;
                try
                {
                    PatientsWaitingCountParPO parameters = (PatientsWaitingCountParPO)MTServices.Instance[Resources.MT_PatientsWaitingCount].Parameters;
                    parameters.FACILITY_UID.Value = facilityUid;
                    parameters.VISTA_SITE_UID.Value = vistaSiteUid;
                    parameters.VISTA_DIVISION_CODE.Value = vistaDivisionCode;
                    parameters.TIMEZONE_OFFSET.Value = timeZoneOffset;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_PatientsWaitingCount].GetEntities(parameters);

                    foreach (PatientsWaitingCountBO bo in listWrapper.ChildList)
                    {
                        count = new PatientWaitingCount();
                        bo.CopyTo(count);
                        break;
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return count;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.IconInfo> FilterIconInfo(string listType, string iconFlagIds, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.IconInfo> result = new List<DataContracts.IconInfo>();
                try
                {
                    IconInfoParPO parameters = (IconInfoParPO)MTServices.Instance[Resources.MT_IconInfo].Parameters;
                    parameters.LIST_TYPE.Value = listType;
                    parameters.ICON_FLAG_IDS.Value = iconFlagIds;
                    if (facilityId != null)
                        parameters.FACILITY_UID.Value = Guid.Parse(facilityId.extension);
                    else
                        parameters.FACILITY_UID.Value = null;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_IconInfo].GetEntities(parameters);

                    DataContracts.IconInfo icon = null;
                    foreach (IconInfoBO bo in listWrapper.ChildList)
                    {
                        icon = new DataContracts.IconInfo();
                        bo.CopyTo(icon);
                        result.Add(icon);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.IconAssociationInfo> FilterBedPatientIconAssociation(Guid bedUid, Guid? patientUid, Guid facilityUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.IconAssociationInfo> result = new List<DataContracts.IconAssociationInfo>();
                try
                {
                    IconAssociationInfoParPO parameters = (IconAssociationInfoParPO)MTServices.Instance[Resources.MT_IconAssociationInfo].Parameters;
                    parameters.BED_UID.Value = bedUid;
                    parameters.PATIENT_UID.Value = patientUid;
                    parameters.FACILITY_UID.Value = facilityUid;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_IconAssociationInfo].GetEntities(parameters);

                    DataContracts.IconAssociationInfo icon = null;
                    foreach (IconAssociationInfoBO bo in listWrapper.ChildList)
                    {
                        icon = new DataContracts.IconAssociationInfo();
                        bo.CopyTo(icon);
                        result.Add(icon);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<BMS.DataContracts.OccupiedBedInfo> GetOccupiedBeds(II vistaSiteId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                OccupiedBedInfoParPO parameters = (OccupiedBedInfoParPO)MTServices.Instance[Resources.MT_OccupiedBedInfo].Parameters;
                parameters.VISTA_SITE_UID.Value = new Guid(vistaSiteId.extension);
                IEntityListWrapper entities = MTServices.Instance[Resources.MT_OccupiedBedInfo].GetEntities(parameters);

                List<BMS.DataContracts.OccupiedBedInfo> result = new List<DataContracts.OccupiedBedInfo>();
                foreach (OccupiedBedInfoBO entity in entities.ChildList)
                    result.Add(new BMS.DataContracts.OccupiedBedInfo()
                    {
                        ActIEN = entity.IEN.Value,
                        PatientUID = entity.PATIENT_UID.Value,
                        BedUID = entity.BED_UID.Value,
                        WardUID = entity.WARD_UID.Value,
                        EnteredDate = entity.ENTERED_DATE.Value,
                        EventDate = entity.EVENT_DATE.Value,
                        Id = TranslatorUtils.BuildIdentifier(entity.DOMAIN_ID, entity.ID),
                        IsAdmission = entity.IS_ADMISSION.Value
                    });
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.IconAssociation> FilterBedIconAssociation(string bedUids, Guid facilityUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.IconAssociation> result = new List<DataContracts.IconAssociation>();
                try
                {
                    IconAssociationParPO parameters = (IconAssociationParPO)MTServices.Instance[Resources.MT_IconAssociation].Parameters;
                    parameters.BED_LIST.Value = bedUids;
                    parameters.FACILITY_UID.Value = facilityUid;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_IconAssociation].GetEntities(parameters);

                    DataContracts.IconAssociation icon = null;
                    foreach (IconAssociationBO bo in listWrapper.ChildList)
                    {
                        icon = new DataContracts.IconAssociation();
                        bo.CopyTo(icon);
                        result.Add(icon);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public Dictionary<Guid, DataContracts.PatientIcon> GetPatientIcons(string group, string subGroup, string patientUidList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Dictionary<Guid, DataContracts.PatientIcon> result = new Dictionary<Guid, DataContracts.PatientIcon>();
                try
                {
                    PatientIconParPO parameters = (PatientIconParPO)MTServices.Instance[Resources.MT_PatientIcon].Parameters;
                    parameters.GROUP.Value = group;
                    parameters.SUBGROUP.Value = subGroup;
                    parameters.PATIENT_UID_LIST.Value = patientUidList;
                    parameters.INCLUDE_NULL_RESULTS.Value = false;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_PatientIcon].GetEntities(parameters);

                    DataContracts.PatientIcon icon = null;
                    foreach (PatientIconBO bo in listWrapper.ChildList)
                    {
                        icon = new DataContracts.PatientIcon();
                        bo.CopyTo(icon);
                        result.Add(bo.PATIENT_UID.Value, icon);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.WaitingListReport> FilterWaitingListReport(Guid facilityUid, string filterBy)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.WaitingListReport> result = new List<DataContracts.WaitingListReport>();
                try
                {
                    WaitingListReportParPO parameters = (WaitingListReportParPO)MTServices.Instance[Resources.MT_WaitingListReport].Parameters;
                    parameters.FACILITY_UID.Value = facilityUid;
                    parameters.FILTER_BY.Value = filterBy;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_WaitingListReport].GetEntities(parameters);

                    DataContracts.WaitingListReport item = null;
                    foreach (WaitingListReportBO bo in listWrapper.ChildList)
                    {
                        item = new DataContracts.WaitingListReport();
                        bo.CopyTo(item);
                        result.Add(item);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<DataContracts.EvacuationPatient> GetEvacuationPatients(string wardList, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<DataContracts.EvacuationPatient> evacuationPatientsList = new List<DataContracts.EvacuationPatient>();
                try
                {
                    EvacuationPatientsParPO parameters = (EvacuationPatientsParPO)MTServices.Instance[Resources.MT_EvacuationPatients].Parameters;
                    parameters.WARD_LIST.Value = wardList;
                    parameters.FACILITY_UID.Value = Guid.Parse(facilityId.extension);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_EvacuationPatients].GetEntities(parameters);
                    DataContracts.EvacuationPatient evacuationPatient = null;
                    foreach (EvacuationPatientsBO bo in listWrapper.ChildList)
                    {
                        evacuationPatient = new DataContracts.EvacuationPatient();
                        bo.CopyTo(evacuationPatient);
                        evacuationPatientsList.Add(evacuationPatient);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return evacuationPatientsList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.BedCleanInfo> FilterBedCleanAssignedAndPending(string wardList, string acceptedBy)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.BedCleanInfo> bedCleanInfoList = new List<DataContracts.BedCleanInfo>();
                try
                {
                    BedCleanMobileInfoParPO parameters = (BedCleanMobileInfoParPO)MTServices.Instance[Resources.MT_BedCleanMobileInfo].Parameters;
                    parameters.WARD_LIST.Value = wardList;
                    parameters.ACCEPTED_BY.Value = acceptedBy;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_BedCleanMobileInfo].GetEntities(parameters);
                    DataContracts.BedCleanInfo bedCleanInfo = null;
                    foreach (BedCleanMobileInfoBO bo in listWrapper.ChildList)
                    {
                        bedCleanInfo = new DataContracts.BedCleanInfo();
                        bo.CopyTo(bedCleanInfo);
                        bedCleanInfoList.Add(bedCleanInfo);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return bedCleanInfoList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.EmsStaff> FilterEmsStaff(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.EmsStaff> emsStaffList = new List<DataContracts.EmsStaff>();
                try
                {
                    EmsStaffParPO parameters = (EmsStaffParPO)MTServices.Instance[Resources.MT_EmsStaff].Parameters;
                    parameters.ID.Value = null;
                    parameters.FACILITY_UID.Value = Guid.Parse(facilityId.extension);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_EmsStaff].GetEntities(parameters);
                    DataContracts.EmsStaff emsStaff = null;
                    foreach (EmsStaffBO bo in listWrapper.ChildList)
                    {
                        emsStaff = new DataContracts.EmsStaff();
                        bo.CopyTo(emsStaff, facilityId.root);
                        emsStaffList.Add(emsStaff);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return emsStaffList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        public IList<Order> GetCancelableOrders(II vistaSiteId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.Order> orders = new List<DataContracts.Order>();
                try
                {
                    CancelableOrderInfoParPO parameters = (CancelableOrderInfoParPO)MTServices.Instance[Resources.MT_CancelableOrderInfo].Parameters;
                    parameters.VISTA_SITE_UID.Value = new Guid(vistaSiteId.extension);
                    parameters.ADMISSION_VALUE.Value = (int)MovementTransactionType.ADMISSION;
                    parameters.MOVEMENT_VALUE.Value = (int)MovementTransactionType.TRANSFER;
                    parameters.DISCHARGE_VALUE.Value = (int)MovementTransactionType.DISCHARGE;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_CancelableOrderInfo].GetEntities(parameters);

                    DataContracts.Order order = null;
                    foreach (CancelableOrderInfoBO co in listWrapper.ChildList)
                    {
                        order = null;
                        switch (co.ACT_TYPE.Value)
                        {
                            case (int)MovementTransactionType.ADMISSION:
                                order = new DC.AdmissionOrder();
                                break;
                            case (int)MovementTransactionType.TRANSFER:
                                order = new DC.MovementOrder();
                                break;
                            case (int)MovementTransactionType.DISCHARGE:
                                order = new DC.DischargeOrder();
                                break;
                            default:
                                order = null;
                                break;
                        }
                        if (order != null)
                        {
                            order.Id = TranslatorUtils.BuildIdentifier(co.DOMAIN_ID, co.ID);
                            order.Ien = co.IEN.Value;
                            order.OrderedDate = (co.ORDERED_DATE.Value.HasValue) ? co.ORDERED_DATE.Value.Value : DateTime.UtcNow;
                            orders.Add(order);
                        }
                    }
                    return orders;
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.BedStaffHistory> GetBedStaffHistory(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.BedStaffHistory> result = new List<DataContracts.BedStaffHistory>();
                try
                {
                    BedStaffHistoryParPO parameters = (BedStaffHistoryParPO)MTServices.Instance[Resources.MT_BedStaffHistory].Parameters;
                    parameters.BED_UID.Value = Guid.Parse(bedId.extension);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_BedStaffHistory].GetEntities(parameters);
                    DataContracts.BedStaffHistory bedStaff = null;
                    foreach (BedStaffHistoryBO bo in listWrapper.ChildList)
                    {
                        bedStaff = new DataContracts.BedStaffHistory();
                        bo.CopyTo(bedStaff, bedId.root);
                        result.Add(bedStaff);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void GetHomePageBMSData(Guid facilityUid, string vistaId, DateTime admissionCreationTime, bool isOnlyCurrentWaitingAdmission, bool isOnlyInHouseWaitingAdmission, bool isMentalHealth, bool isEmergencyManagement,
            out List<DC.BedOccupancyCount> bedOccupancylist, out List<DC.AdmissionInfo> facilityWaitingList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedOccupancylist = GetPercentageOfOccupancy(vistaId, string.Empty).ToList();
                facilityWaitingList = FilterAdmissions(facilityUid, admissionCreationTime, isOnlyCurrentWaitingAdmission, isOnlyInHouseWaitingAdmission, isMentalHealth, isEmergencyManagement).ToList();                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private const string MT_VistaIntegrationLog = "VistaIntegrationLog";

        public IList<DC.VistaIntegrationLog> GetAlreadyExistsVistaIntegrationLogs(IEnumerable<DC.VistaIntegrationLog> data, string vista)
        {
            List<DC.VistaIntegrationLog> result = new List<DC.VistaIntegrationLog>();
            try
            {
                if (data == null || data.Count() == 0)
                    return result;
                VistaintegrationlogparPO par = MTServices.Instance[MT_VistaIntegrationLog].Parameters as VistaintegrationlogparPO;
                if (par != null)
                {
                    par.VISTA.Value = vista;
                    par.IENS.Value = ConcatString(data.Select(s => s.Ien));
                    par.VISTA_FILES.Value = data.First().File;
                    IEntityListWrapper listWrapper = MTServices.Instance[MT_VistaIntegrationLog].GetEntities(par);
                    foreach (VistaIntegrationLogBO bo in listWrapper.ChildList)
                    {
                        DC.VistaIntegrationLog value = new DC.VistaIntegrationLog();
                        value.File = bo.VISTA_FILE.Value;
                        value.Ien = bo.IEN.Value;
                        result.Add(value);
                    }
                }
                return result;
            }
            catch (Exception e)
            {
                Tracer.TraceException(e);
                throw;
            }
        }

        private String ConcatString(IEnumerable<string> strings)
        {
            StringBuilder sb = new StringBuilder();
            strings.ForEach(s =>
                {
                    sb.Append(s);
                    sb.Append(',');
                });
            return sb.ToString();
        }

        private const string MT_BedUnavailableInfo = "BedUnavailableInfo";

        public IList<DC.BedUnavailableInfo> FilterBedUnavailableInfo(II vistaId)
        {
            try
            {
                List<DC.BedUnavailableInfo> result = null;
                BedUnavailableInfoParPO par = MTServices.Instance[MT_BedUnavailableInfo].Parameters as BedUnavailableInfoParPO;
                if (par != null)
                {
                    par.DOMAIN_ID.Value = vistaId.root;
                    par.VISTA_SITE_UID.Value = vistaId.extension;
                    IEntityListWrapper listWrapper = MTServices.Instance[MT_BedUnavailableInfo].GetEntities(par);
                    result = new List<DC.BedUnavailableInfo>(listWrapper.ChildList.Count);
                    foreach (BedUnavailableInfoBO bo in listWrapper.ChildList)
                    {
                        DC.BedUnavailableInfo value = new DC.BedUnavailableInfo();
                        value.BedId = new II(vistaId.root, bo.BED_UID.Value.ToString());
                        value.CreationDate = bo.CREATION_DATE.Value.Value;
                        value.IsUnavailableFromVistA = bo.IS_UNAVAILABLE_FROM_VISTA.Value.Value;
                        result.Add(value);
                    }
                }
                return result;
            }
            catch (Exception e)
            {
                Tracer.TraceException(e);
                throw;
            }
        }

        private const string MT_UpdatingPatient = "UpdatingPatient";

        public IList<II> FilterUpdatingPatients(II vistaId)
        {
            try
            {
                List<II> result = null;
                UpdatingPatientParPO par = MTServices.Instance[MT_UpdatingPatient].Parameters as UpdatingPatientParPO;
                if (par != null)
                {
                    par.DOMAIN_ID.Value = vistaId.root;
                    par.VISTA_SITE_UID.Value = vistaId.extension;
                    IEntityListWrapper listWrapper = MTServices.Instance[MT_UpdatingPatient].GetEntities(par);
                    result = listWrapper.ChildList.Cast<UpdatingPatientBO>()
                        .Select(s => new II(vistaId.root, s.UID.Value.ToString()))
                        .ToList();
                }
                return result;
            }
            catch (Exception e)
            {
                Tracer.TraceException(e);
                throw;
            }
        }

        public List<DataContracts.MovementIen> GetMovementIens(DateTime startDate, DateTime endDate, II vistaId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.MovementIen> result = new List<DataContracts.MovementIen>();
                try
                {
                    MovementIenParPO parameters = (MovementIenParPO)MTServices.Instance[Resources.MT_MovementIen].Parameters;
                    parameters.START_DATE.Value = startDate;
                    parameters.END_DATE.Value = endDate;
                    parameters.VISTA_SITE_UID.Value = Guid.Parse(vistaId.extension);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_MovementIen].GetEntities(parameters);

                    foreach (MovementIenBO bo in listWrapper.ChildList)
                        result.Add(new DataContracts.MovementIen()
                        {
                            Id = bo.ID.Value.Value,
                            Ien = bo.IEN.Value,
                            MovementDate = bo.DATE_TIME.Value.HasValue ? bo.DATE_TIME.Value.Value : DateTime.UtcNow,
                            EnteredDate = bo.ENTERED_DATE.Value.HasValue ? bo.ENTERED_DATE.Value.Value : DateTime.UtcNow,
                            CurrentAdmissionIen = bo.CURRENT_ADMISSION_IEN.Value,
                            PatientUid = bo.PATIENT_UID.Value,
                            TransactionTypeId = bo.TRANSACTION_ID.Value,
                            TypeOfMovementCode = bo.TYPE_OF_MOVEMENT_CODE.Value,
                        });
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.MovementWithoutBed> FilterMovementsWithoutBed(DateTime startDate, DateTime endDate, II vistaId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.MovementWithoutBed> result = new List<DataContracts.MovementWithoutBed>();
                try
                {
                    MovementWithoutBedParPO parameters = (MovementWithoutBedParPO)MTServices.Instance[Resources.MT_MovementWithoutBed].Parameters;
                    parameters.START_DATE.Value = startDate;
                    parameters.END_DATE.Value = endDate;
                    parameters.VISTA_SITE_UID.Value = Guid.Parse(vistaId.extension);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_MovementWithoutBed].GetEntities(parameters);
                    string domain = vistaId.root;
                    foreach (MovementWithoutBedBO bo in listWrapper.ChildList)
                        result.Add(new DataContracts.MovementWithoutBed()
                                {
                                    MovementId = new II(domain, bo.ID.Value.Value.ToString()),
                                    MovementIen = bo.IEN.Value,
                                    WardId = new II(domain, bo.WARD_UID.Value.HasValue ? bo.WARD_UID.Value.Value.ToString() : null),
                                    BedId = new II(domain, bo.BED_UID.Value.HasValue ? bo.BED_UID.Value.Value.ToString() : null)
                                });
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<string> GetMissingAdmissions(string admissionIenList, II vistaId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> result = new List<string>();
                try
                {
                    MissingAdmissionParPO parameters = (MissingAdmissionParPO)MTServices.Instance[Resources.MT_MissingAdmission].Parameters;
                    parameters.ADMISSION_IEN_LIST.Value = admissionIenList;
                    parameters.VISTA_SITE_UID.Value = Guid.Parse(vistaId.extension);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_MissingAdmission].GetEntities(parameters);
                    foreach (MissingAdmissionBO bo in listWrapper.ChildList)
                        result.Add(bo.ADMISSION_IEN.Value);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DateTime? FilterBPLastRun(string vistaId, IList<DataRetrievalMethod> retrievalMethods, IList<VistaDataType> dataTypes, IList<JobStatus> status)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DateTime? result = null;
                try
                {

                    BPLastRunParPO parameters = (BPLastRunParPO)MTServices.Instance[Resources.MT_BPLastRun].Parameters;
                    parameters.VISTA_ID.Value = vistaId;
                    parameters.RETRIEVAL_METHOD.Value = (byte)retrievalMethods.Aggregate((methods, next) => methods | next);
                    parameters.RETRIEVED_DATA_TYPE.Value = (int)dataTypes.Aggregate((dataType, next) => dataType | next);
                    parameters.STATUS.Value = (byte)status.Aggregate((s, next) => s | next);

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_BPLastRun].GetEntities(parameters);
                    if (listWrapper.ChildList != null)
                    {
                        BPLastRunBO bo = listWrapper.ChildList.FirstOrDefault() as BPLastRunBO;
                        if (bo != null)
                            result = bo.BPDate.Value;
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
