﻿using System;
using System.IdentityModel.Selectors;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.ServiceModel.Security.Tokens;
using BMS.Security.Configuration;

namespace BMS.Security.DurableIssuedToken
{
    public class DurableIssuedTokenClientCredentials : ClientCredentials
    {
        public DurableIssuedTokenConfigHandler DurableIssuedTokenConfiguration { get; set; }
        public IssuedTokenCache IssuedTokenCache { get; set; }

        public DurableIssuedTokenClientCredentials(DurableIssuedTokenConfigHandler configuration)
            : base()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DurableIssuedTokenConfiguration = configuration;
                this.IssuedTokenCache = PersistenceIssuedTokenCacheFactory.GetIssuedTokenCache(DurableIssuedTokenConfiguration);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        DurableIssuedTokenClientCredentials(DurableIssuedTokenClientCredentials other)
            : base(other)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.IssuedTokenCache = other.IssuedTokenCache;
                this.DurableIssuedTokenConfiguration = other.DurableIssuedTokenConfiguration;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected override ClientCredentials CloneCore()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return new DurableIssuedTokenClientCredentials(this);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public override void ApplyClientBehavior(ServiceEndpoint serviceEndpoint, System.ServiceModel.Dispatcher.ClientRuntime clientRuntime)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                clientRuntime.MessageInspectors.Add(new HttpSessionMessageInspector());
                base.ApplyClientBehavior(serviceEndpoint, clientRuntime);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public override SecurityTokenManager CreateSecurityTokenManager()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return new DurableIssuedTokenClientCredentialsTokenManager((DurableIssuedTokenClientCredentials)this.Clone());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        class DurableIssuedTokenClientCredentialsTokenManager : ClientCredentialsSecurityTokenManager
        {
            IssuedTokenCache _cache;

            public DurableIssuedTokenClientCredentialsTokenManager(DurableIssuedTokenClientCredentials creds)
                : base(creds)
            {
                this._cache = creds.IssuedTokenCache;
            }

            public override SecurityTokenProvider CreateSecurityTokenProvider(SecurityTokenRequirement tokenRequirement)
            {
                if (IsIssuedSecurityTokenRequirement(tokenRequirement))
                {
                    return new DurableIssuedSecurityTokenProvider((IssuedSecurityTokenProvider)base.CreateSecurityTokenProvider(tokenRequirement), this._cache);
                }
                else
                {
                    return base.CreateSecurityTokenProvider(tokenRequirement);
                }
            }
        }
    }
}
