using System.Collections.Generic;
using System;

namespace InfoWorld.Security.Authorization.PolicyAdministrationPoint
{
    /// <summary>
    /// Class which represents a role definition.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Runtime.Serialization", "3.0.0.0")]
    [System.Runtime.Serialization.DataContractAttribute(Name = "Role", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.Security.Authorization.PolicyAdministrationPoint")]
    [System.SerializableAttribute()]
    public partial class Role : InfoWorld.Security.Authorization.PolicyAdministrationPoint.DefinitionBase, ICloneable
    {
        [System.Runtime.Serialization.OptionalFieldAttribute()]
        private List<string> PermissionsField;

        [System.Runtime.Serialization.DataMemberAttribute()]
        public List<string> Permissions
        {
            get
            {
                return this.PermissionsField;
            }
            set
            {
                this.PermissionsField = value;
            }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="Role"/> class.
        /// </summary>
        public Role()
        {
            if(Permissions == null)
                Permissions = new List<string>();
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="Role"/> class with an id, name and description.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <param name="name">The name.</param>
        /// <param name="description">The description.</param>
        public Role(string id, string name, string description)
            :this()
        {
            Id = id;
            Name = name;
            Description = description;
        }
        
        #region ICloneable Members

        /// <summary>
        /// Creates a new object that is a copy of the current instance.
        /// </summary>
        /// <returns>
        /// A new object that is a copy of this instance.
        /// </returns>
        public object Clone()
        {
            Role clone = new Role();
            clone.Description = Description;
            clone.ExtensionData = ExtensionData;
            clone.Id = Id;
            clone.Name = Name;
            clone.Permissions.AddRange(Permissions);

            return clone;
        }

        #endregion

        /// <summary>
        /// Determines whether the specified <see cref="System.Object"/> is equal to this instance.
        /// </summary>
        /// <param name="obj">The <see cref="System.Object"/> to compare with this instance.</param>
        /// <returns>
        ///   <c>true</c> if the specified <see cref="System.Object"/> is equal to this instance; otherwise, <c>false</c>.
        /// </returns>
        /// <exception cref="T:System.NullReferenceException">
        /// The <paramref name="obj"/> parameter is null.
        ///   </exception>
        public override bool Equals(object obj)
        {
            Role r = obj as Role;
            return r.Id == this.Id;
        }
    }
}