﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration;
using BMS.VistaIntegration.VistA;
using BMS.Utils;
using BMS.VistaIntegration.Mdws;
using BMS.VistaIntegration.Cache;

namespace BMS.Host
{
    public class SessionFactory : ISessionFactory
    {
        public IVistASessionFactory MakeSession(DataRetrievalMethod dataRetrivalMethod)
        {
            switch (dataRetrivalMethod)
            {
                case DataRetrievalMethod.MDWS:
                    return new MdwsVistASessionFactory();
                case DataRetrievalMethod.ODBC:
                    return new CacheVistASessionFactory();
                default:
                    throw new ArgumentException();
            }
        }
    }
}
