﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.Facade.Data;

namespace BMS.Facade.Implementation
{
    /// <summary>
    /// ReportInfo class
    /// </summary>
    public class ReportInfo : IReportInfo
    {
        public ReportInfo() { }

        /// <summary>
        /// The name of the report.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// The relative path of the report in Report Server.
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// The Url used to access this report.
        /// </summary>
        public string Url
        {
            get
            {
                ReportUtil reportUtil = ReportUtil.CreateDefaultInstance();
                reportUtil.ReportName = this.Name;
                reportUtil.ReportPath = this.Path;
                reportUtil.Parameters.Clear();
                if (this.Parameters != null)
                    foreach (KeyValuePair<String, String> kvp in this.Parameters)
                        reportUtil.Parameters.Add(kvp.Key, kvp.Value);
                
                string param = ReportUtil.Encrypt(reportUtil);
                param = System.Web.HttpUtility.UrlEncode(param);
                param = "?" + param;
                
                if (this.Name.Contains(Constants.EMERGENCY_MANAGEMENT_REPORT))
                    return "/Reporting/EvacuationPatientReportViewer.aspx" + param;
                else
                    return "/Reporting/ReportViewer.aspx" + param;
            }
        }

        public Dictionary<string, string> Parameters { get; set; }

        public IReportInfo Clone()
        {
            return new ReportInfo()
            {
                Name = this.Name,
                Path = this.Path,
                Parameters = this.Parameters == null ?
                null : new Dictionary<string, string>(this.Parameters)
            };
        }

    }
}
