﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade
{
    /// <summary>
    /// Class used to convert values of DateTime properties of an instance class from UTC to Facility TimeZone or to UTC.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public static class DateTimeConverter
    {
        /// <summary>
        /// Converts date from UTC.
        /// </summary>
        /// <param name="obj">The source object.</param>
        /// <returns></returns>
        public static T ConvertDateFromUTC<T>(T obj, II facilityId) where T : class
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                TimeZoneUtil.ConvertObjectDates(obj, true, TimeZoneUtil.GetTimeZoneInfo(facilityId));
                return obj;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Converts the date to UTC.
        /// </summary>
        /// <param name="obj">The source object.</param>
        /// <returns></returns>
        public static T ConvertDateToUTC<T>(T obj, II facilityId) where T : class
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                TimeZoneUtil.ConvertObjectDates(obj, false, TimeZoneUtil.GetTimeZoneInfo(facilityId));
                return obj;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


    }
}
