﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Utils;

namespace BMS.Facade.Service
{
    /// <summary>
    /// Interface used to manipulate bed's operations.
    /// </summary>
    public interface IBedOperations
    {
        /// <summary>
        /// Gets the bed occupancy report.
        /// </summary>
        /// <param name="divisionId">The division id.</param>
        /// <param name="bedStatus">The bed status.</param>
        /// <param name="pagingContext">Object containing the paging parameters(page number, number of records per page, order by column)</param>
        /// <returns></returns>
        IList<BedInfo> GetBedOccupancy(IEnumerable<Ward> wardList, II divisionId, Facility facility, CD bedStatus, bool isDoNotDisplay, string sortBy);

        /// <summary>
        /// Gets the bed information.
        /// </summary>
        /// <param name="bedId">The bed id.</param>
        /// <returns></returns>
        Bed GetBed(II bedId, II vistaSiteId);

        /// <summary>
        /// Gets the beds DND and OOS.
        /// </summary>
        /// <param name="wardList">The ward list.</param>
        /// <param name="facilityId">The facility id.</param>
        /// <returns></returns>
        IList<Bed> GetBedsDNDAndOOS(string wardList, II facilityId);

        /// <summary>
        /// Gets the beds clean.
        /// </summary>
        /// <param name="divisionId">The division id.</param>
        /// <param name="facilityId">The facility id.</param>
        /// <param name="startDate">The start date.</param>
        /// <param name="endDate">The end date.</param>
        /// <returns></returns>
        IList<BedCleanInfo> GetBedsClean(string wardList, II divisionId, II facilityId, DateTime startDate, DateTime endDate, TimeZoneInfo facilityTimeZone);

        /// <summary>
        /// Gets the bed clean by id.
        /// </summary>
        /// <param name="bedCleanId">The bed clean id.</param>
        /// <returns></returns>
        BedClean GetBedCleanById(II bedCleanId, II facilityId);

        /// <summary>
        /// Updates the bed cleaning.
        /// </summary>
        /// <param name="bedclean">The bedclean.</param>
        void UpdateBedCleaning(BedClean bedclean, II facilityId);

        /// <summary>
        /// Gets the bed unavailable.
        /// </summary>
        /// <param name="bedId">The bed id.</param>
        /// <returns></returns>
        BedUnavailable GetBedUnavailable(II bedId,II facilityId);

        /// <summary>
        /// Updates the bed.
        /// </summary>
        /// <param name="bed">The bed.</param>
        void UpdateBed(Bed bed);

        /// <summary>
        /// Inserts the bed unvailable history.
        /// </summary>
        /// <param name="bed">The bed.</param>
        void InsertBedUnavailableHistory(BedUnavailableHistory bedUnavailableHistory, II facilityId);

        /// <summary>
        /// Gets the percentage of occupancy.
        /// </summary>
        /// <param name="vistaSitesList">The vista sites list.</param>
        /// <param name="wardsList">The wards list.</param>
        /// <param name="facilityIdList">The facility ids list.</param>
        /// <returns></returns>
        IList<BedOccupancyCount> GetPercentageOfOccupancy(string vistaSitesList, string wardsList, IList<II> facilityIdList);

        /// <summary>
        /// Gets the occupied beds.
        /// </summary>
        /// <param name="vistaSiteId">The vista site id.</param>
        /// <returns></returns>
        IList<OccupiedBedInfo> GetOccupiedBeds(II vistaSiteId);

        /// <summary>
        /// Deletes the icon association.
        /// </summary>
        /// <param name="patientUID">The patient UID.</param>
        void DeleteIconAssociation(Guid patientUID);

        /// <summary>
        /// Exports the whiteboard report data.
        /// </summary>
        /// <param name="facilities">The facilities.</param>
        void ExportWhiteboardReportData(List<Facility> facilities);

        /// <summary>
        /// Filters the bed clean assigned and pending.
        /// </summary>
        /// <param name="wardList">The ward list.</param>
        /// <param name="acceptedBy">The accepted by.</param>
        /// <param name="facilityId">The facility id.</param>
        /// <returns></returns>
        List<BedCleanInfo> FilterBedCleanAssignedAndPending(List<Ward> wardList, string acceptedBy, II facilityId);

        /// <summary>
        /// Manages the bed staff.
        /// </summary>
        /// <param name="bed">The bed.</param>
        /// <param name="division">The division.</param>
        /// <param name="staff">The staff.</param>
        /// <param name="patient">The patient.</param>
        /// <param name="facility">The facility.</param>
        void ManageBedStaff(Bed bed, Division division, string staff, Patient patient, Facility facility);

        /// <summary>
        /// Gets the bed clean by bed id.
        /// </summary>
        /// <param name="bedId">The bed id.</param>
        /// <param name="facilityId">The facility id.</param>
        /// <returns></returns>
        BedClean GetBedCleanByBedId(II bedId, II facilityId);

        /// <summary>
        /// Gets the bed staff history.
        /// </summary>
        /// <param name="bedId">The bed id.</param>
        /// <param name="facilityId">The facility id.</param>
        /// <returns></returns>
        List<BedStaffHistory> GetBedStaffHistory(II bedId, II facilityId);

        /// <summary>
        /// Sends the clean dirty bed notifications.
        /// </summary>
        /// <param name="bedClean">The bed clean.</param>
        void SendCleanDirtyBedNotifications(BedClean bedClean);

        /// <summary>
        /// Gets the beds DND or OOS.
        /// </summary>
        /// <param name="wardList">The ward list.</param>
        /// <param name="typeCode">The type code.</param>
        /// <returns></returns>
        List<II> GetBedsDNDOrOOS(string wardList, string typeCode);
    }
}
