﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using BMS.FaultContracts;
using BMS.Utils;

namespace BMS.Facade.Fault
{
    [KnownType(typeof(ConfigValueException))]
    [KnownType(typeof(CustomSQLException))]
    [KnownType(typeof(DefaultConfigException))]
    [KnownType(typeof(EntityNotFoundException))]
    [KnownType(typeof(NullParameterException))]
    [KnownType(typeof(OtherException))]
    [KnownType(typeof(WFInvalidOperation))]
    [KnownType(typeof(WfOtherException))]
    [DataContract]
    public class GenericWFServiceFault
    {
        [DataMember]
        public object ServiceFault { get; set; }

        public override string ToString()
        {
            return "GenericWFServiceFault: ServiceFault:\n" + Utilities.ObjectToStringUsingPropertyReflection(ServiceFault, false);
        }
    }
}
