﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// TransferInfo class.
    /// </summary>
    public class TransferInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        public II Id { get; set; }

        public string IdExtension { get { return Id.extension; } }

        /// <summary>
        /// Gets or sets the name of the visn.
        /// </summary>
        /// <value>
        /// The name of the visn.
        /// </value>
        public string VisnName { get; set; }

        /// <summary>
        /// Gets or sets the visn number.
        /// </summary>
        /// <value>
        /// The visn number.
        /// </value>
        public string VisnNumber { get; set; }

        public string VisnDisplay { get { return "VISN " + VisnNumber; } }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public II PatientId { get; set; }

        public string ExtensionPatientId { get { return PatientId.extension; } }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the SSN.
        /// </summary>
        /// <value>
        /// The SSN.
        /// </value>
        public string PatientLastFourDigitsOfSSN { get; set; }

        /// <summary>
        /// Gets or sets the era.
        /// </summary>
        /// <value>
        /// The era.
        /// </value>
        public string Era { get; set; }

        /// <summary>
        /// Gets or sets the facility to.
        /// </summary>
        /// <value>
        /// The facility to.
        /// </value>
        public string FacilityCodeTo { get; set; }

        /// <summary>
        /// Gets or sets the facility from.
        /// </summary>
        /// <value>
        /// The facility  from.
        /// </value>
        public string FacilityCodeFrom { get; set; }

        /// <summary>
        /// Gets or sets the SC rating.
        /// </summary>
        /// <value>
        /// The SC rating.
        /// </value>
        public string SCRating { get; set; }

        /// <summary>
        /// Gets or sets the contract.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        public string Contract { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        /// <value>
        /// The diagnosis.
        /// </value>
        public string Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the current location.
        /// </summary>
        /// <value>
        /// The current location.
        /// </value>
        public string CurrentLocation { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        public DateTime? AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the Specialty.
        /// </summary>
        /// <value>
        /// The Specialty.
        /// </value>
        public string Specialty { get; set; }

        /// <summary>
        /// Gets or sets the index of the record(used for paging).
        /// </summary>
        /// <value>
        /// The index.
        /// </value>
        public int Index { get; set; }

        /// <summary>
        /// Gets or sets the total records count(used ofr paging).
        /// </summary>
        /// <value>
        /// The total count.
        /// </value>
        public int TotalCount { get; set; }

        /// <summary>
        /// Gets or sets the waiting time. Only for dummy data.
        /// </summary>
        /// <value>
        /// The waiting time.
        /// </value>
        public TimeSpan WaitingTime { get; set; }

        public string WaitingTimeDisplay { get { return String.Format("{0:00}:{1:00}", (int)WaitingTime.TotalHours, WaitingTime.Minutes); } }

        /// <summary>
        /// Gets or sets the region number.
        /// </summary>
        /// <value>
        /// The region number.
        /// </value>
        public string RegionNumber { get; set; }

        public string RegionDisplay { get { return "Region " + RegionNumber; } }

        /// <summary>
        /// Gets or sets the event date.
        /// </summary>
        /// <value>
        /// The event date.
        /// </value>
        public DateTime? EventDate { get; set; }

        /// <summary>
        /// Gets or sets the facility from.
        /// </summary>
        /// <value>
        /// The facility from.
        /// </value>
        public Place FacilityFrom { get; set; }

        /// <summary>
        /// Gets or sets the facility time zone code.
        /// </summary>
        /// <value>
        /// The facility time zone code.
        /// </value>
        public string FacilityTimeZoneCode { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is national wait list.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national wait list; otherwise, <c>false</c>.
        /// </value>
        public bool IsNationalWaitList { get; set; }

        public string IsNationalWaitListDisplay { get { return IsNationalWaitList ? "YES" : "NO"; } }

        public bool HasSimilarNameOrSSN { get; set; }

        #endregion
    }
}
