﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.DataAnnotations;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Sister Sites Group Class. Stores information about a group of sister sites.
    /// </summary>
    public class SisterSitesGroup
    {
        /// <summary>
        /// Gets or sets the record number.
        /// </summary>
        /// <value>
        /// The number.
        /// </value>
        [Required(ErrorMessage = "The Record No is required")]
        [Range(1, 100000000000, ErrorMessage = "Please enter a value greater than 0")]
        public int RecordNumber { get; set; }

        /// <summary>
        /// Gets or sets the site list.
        /// </summary>
        /// <value>
        /// A comma-separated list of site codes.
        /// </value>
        public string SiteCodeList { get; set; }
    }
}
