﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Class which stores place instances in accordance with the HL7 standard.
    /// </summary>
    [DataContract]
    public class Place
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [DataMember]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        [DataMember]
        public string Name { get; set; }
          
        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        [DataMember]
        public string Ien { get; set; }
         
        /// <summary>
        /// Gets or sets the Place's first address.
        /// </summary>
        /// <value>
        /// First address.
        /// </value>
        [DataMember]
        public AD Address1 { get; set; }

        /// <summary>
        /// Gets or sets the Place's second address.
        /// </summary>
        /// <value>
        /// Second address.
        /// </value>
        [DataMember]
        public AD Address2 { get; set; }

        /// <summary>
        /// Gets or sets the name of the person contact.
        /// </summary>
        /// <value>
        /// The name of the person contact.
        /// </value>
        [DataMember]
        public ST PersonContactName { get; set; }

        /// <summary>
        /// Gets or sets the person contact email.
        /// </summary>
        /// <value>
        /// The person contact email.
        /// </value>
        [DataMember]
        public TEL PersonContactEmail { get; set; }

        /// <summary>
        /// Gets or sets the person contact phone.
        /// </summary>
        /// <value>
        /// The person contact phone.
        /// </value>
        [DataMember]
        public TEL PersonContactPhone { get; set; }

        #endregion
    }
}
