﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Human individuals storage class.
    /// </summary>
    [DataContract]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class Person
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [DataMember]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the SSN.
        /// </summary>
        /// <value>
        /// The SSN.
        /// </value>
        [DataMember]
        public II SSN { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        public II VistaSite { get; set; }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        [DataMember]
        public string Ien { get; set; }

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        /// <value>
        /// The first name.
        /// </value>
        [DataMember]
        public string FirstName { get; set; }

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        /// <value>
        /// The last name.
        /// </value>
        [DataMember]
        public string LastName { get; set; }

        /// <summary>
        /// Gets or sets the middle name.
        /// </summary>
        /// <value>
        /// The middle name.
        /// </value>
        [DataMember]
        public string MiddleName { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        [DataMember]
        public CD Gender { get; set; }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        [DataMember]
        [NotConvertDateTimeAttribute]
        public DateTime? DateOfBirth { get; set; }

        [DataMember]
        public string Weight { get; set; }

        #endregion
    }
}
