﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Patient class.
    /// </summary>
    [DataContract]
    [KnownType(typeof(Person))]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class Patient : Person
    {
        /// <summary>
        /// Gets or sets the treating specialty.
        /// </summary>
        /// <value>
        /// The treating specialty.
        /// </value>
        [DataMember]
        public CD TreatingSpecialty { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is vista validated.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is vista validated; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsVistaValidated { get; set; }

        /// <summary>
        /// Gets or sets the admitting diagnosis.
        /// </summary>
        /// <value>
        /// The admitting diagnosis.
        /// </value>
        [DataMember]
        public string AdmittingDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the attending physician id.
        /// </summary>
        /// <value>
        /// The attending physician id.
        /// </value>
        [DataMember]
        public II AttendingPhysicianId { get; set; }

        /// <summary>
        /// Gets or sets the attending physician.
        /// </summary>
        /// <value>
        /// The attending physician.
        /// </value>
        [DataMember]
        public Person AttendingPhysician { get; set; }

        /// <summary>
        /// Gets or sets the service connected percentage.
        /// </summary>
        /// <value>
        /// The service connected percentage.
        /// </value>
        [DataMember]
        public string ServiceConnectedPercentage { get; set; }

        /// <summary>
        /// Gets or sets the IEN list (root=VistACode and extension=IEN_value).
        /// </summary>
        /// <value>
        /// The IEN list.
        /// </value>
        [DataMember]
        public List<II> IENList { get; set; }
    }
}