﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    public class OccupiedBedInfo
    {
        /// <summary>
        /// Gets or sets the UID of the patient occupying the bed.
        /// </summary>
        /// <value>
        /// The patient's UID.
        /// </value>
        public string PatientUID { get; set; }

        /// <summary>
        /// Gets or sets the bed IEN.
        /// </summary>
        /// <value>
        /// The bed IEN.
        /// </value>
        public string BedIEN { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed.
        /// </summary>
        /// <value>
        /// The name of the bed.
        /// </value>
        public string BedName { get; set; }

        /// <summary>
        /// Gets or sets the ward ien.
        /// </summary>
        /// <value>
        /// The ward ien.
        /// </value>
        public string WardIEN { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the act IEN.
        /// </summary>
        /// <value>
        /// The act IEN.
        /// </value>
        public string ActIEN { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        public DateTime EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the event date.
        /// </summary>
        /// <value>
        /// The event date.
        /// </value>
        public DateTime EventDate { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }
    }
}
