﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Contains data about diversions entries within BMS. 
    /// </summary>
    public class Diversion
    {
        #region Public Members
        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the facility to which this diversion applies.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
         [ConvertDateTime]
        public Place Facility { get; set; }

        /// <summary>
        /// Gets or sets the status of diversion.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the start date the diversion is valid.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date till the diversion is valid.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the entered by.
        /// </summary>
        /// <value>
        /// The entered by.
        /// </value>
        public string EnteredBy { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        public DateTime EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public CD Location { get; set; }

        public string WardGroup { get; set; }

        public string TreatingSpecialty { get; set; }

        #endregion
    }
}
