﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Application Parameters class - stores the configuration data about the marquee and marquee history.
    /// </summary>
    public class ApplicationParameters
    {
        public ApplicationParameters()
        {
            Items = new Dictionary<string, ApplicationParameter>();
        }

        public Dictionary<string, ApplicationParameter> Items { get; set; }

        public string GetValue(string key)
        {
            if (Items.ContainsKey(key))
                return Items[key].Value;

            else
                return null;
        }
    }

    public class ApplicationParameter
    {
        public string Key { get; set; }
        public string Value { get; set; }
    }
}
