﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace VistATool.Utils
{
    /// <summary>
    /// Utilities class for displaying hours and minutes using two digit format.
    /// </summary>
    public class TimeLists
    {
        static IList<String> _minuteList = Enumerable.Range(0, 60).Select(x => x.ToString("00")).ToList();
        static IList<String> _hourList = Enumerable.Range(0, 24).Select(x => x.ToString("00")).ToList();

        /// <summary>
        /// Gets the minute list using the two digit format.
        /// </summary>
        public static IList<string> MinuteList
        {
            get
            {
                return _minuteList;
            }
        }
        /// <summary>
        /// Gets the hour list using the two digit format.
        /// </summary>
        public static IList<string> HourList
        {
            get
            {
                return _hourList;
            }
        }
    }
}