﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.Concurrent;

namespace PerformanceTesting
{
    public static class Logger
    {
        public static ConcurrentDictionary<string, List<Log>> LogData;
        public static ConcurrentBag<Exception> Exceptions;
        public static ConcurrentDictionary<string, string> Errors;

        static Logger() 
        {
            LogData = new ConcurrentDictionary<string, List<Log>>();
            Exceptions = new ConcurrentBag<Exception>();
            Errors = new ConcurrentDictionary<string, string>();
        }

        public static void Log(string action, long duration, string details) 
        {
            LogData.AddOrUpdate(action, new List<Log>() { new Log(duration, details) }, (key, list) => { list.Add(new Log(duration, details)); return list; });
        }

        public static void LogError(string action, string message) 
        {
            Errors.GetOrAdd(action + " " + DateTime.Now, message);
        }

        public static void LogException(Exception e) 
        {
            Exceptions.Add(e);
        }
    }

    public class Log 
    {
        public string Details { get; set; }
        public long Duration { get; set; }

        public Log(long duration, string details) 
        {
            Details = details;
            Duration = duration;
        }
    }
}
