USE V03BYNBMSDB
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER, @START_DATE DATETIME
SET @FACILITY_CODE = 'BYN'
--@START_DATE = initial start date
SET @START_DATE = '20110210' 
SELECT @FACILITY_UID = E.IDENTIFIER
FROM BMS_EIS.dbo.ENTITY AS E
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

DECLARE @COUNT_FROM_LOCAL_DATABASE INT, @COUNT_FROM_BMS_DATABASE INT, @COUNT_ACTIVE_DIV_FROM_LOCAL_DATABASE INT, @COUNT_ACTIVE_DIV_FROM_BMS_DATABASE INT


SELECT @COUNT_FROM_LOCAL_DATABASE = COUNT(*)
FROM [Bed_Control_Site_Diversion] AS Site_Diversion 
LEFT JOIN BMS_EVS.dbo.conceptProperty AS CP ON CP.propertyValue LIKE '%'+ Site_Diversion.DivLocation + '%'
					AND CP.property = 'textualPresentation' AND CP.codingSchemeName = 'Location'
WHERE Site_Diversion.DivStartDT >= @START_DATE

SELECT @COUNT_FROM_BMS_DATABASE = COUNT(*)
FROM BMS.dbo.DIVERSION
WHERE FACILITY_UID = @FACILITY_UID

SELECT @COUNT_ACTIVE_DIV_FROM_LOCAL_DATABASE = COUNT(*)
FROM [Bed_Control_Site_Diversion] AS Site_Diversion 
LEFT JOIN BMS_EVS.dbo.conceptProperty AS CP ON CP.propertyValue LIKE '%'+ Site_Diversion.DivLocation + '%'
					AND CP.property = 'textualPresentation' AND CP.codingSchemeName = 'Location'
WHERE Site_Diversion.DivStartDT >= @START_DATE AND DivStatus = 'YES'

SELECT @COUNT_ACTIVE_DIV_FROM_BMS_DATABASE = COUNT(*)
FROM BMS.dbo.DIVERSION
WHERE FACILITY_UID = @FACILITY_UID AND ACTIVE = 1

IF @COUNT_ACTIVE_DIV_FROM_BMS_DATABASE = @COUNT_ACTIVE_DIV_FROM_LOCAL_DATABASE AND @COUNT_FROM_BMS_DATABASE = @COUNT_FROM_LOCAL_DATABASE
	BEGIN
		SELECT 'FACILITY DIVERSION SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'IN LOCAL DATABASE (CLASS 3) ARE: ' + CAST(@COUNT_FROM_LOCAL_DATABASE AS NVARCHAR(MAX)) + ' DIVERSIONS.'
		SELECT 'IN BMS DATABASE (CLASS 1) ARE: ' + CAST(@COUNT_FROM_BMS_DATABASE AS NVARCHAR(MAX)) + ' DIVERSIONS.'
		SELECT 'IN LOCAL DATABASE (CLASS 3) ARE: ' + CAST(@COUNT_ACTIVE_DIV_FROM_LOCAL_DATABASE AS NVARCHAR(MAX)) + ' ACTIVE DIVERSIONS.'
		SELECT 'IN BMS DATABASE (CLASS 1) ARE: ' + CAST(@COUNT_ACTIVE_DIV_FROM_BMS_DATABASE AS NVARCHAR(MAX)) + ' ACTIVE DIVERSIONS.'
	END

