--VERIFY BED_UNAVAILABLE
USE V03BYNBMSDB

DECLARE @VISTA_CODE NVARCHAR(50), @VISTA_UID UNIQUEIDENTIFIER
SET @VISTA_CODE = 'V03NYN'

SELECT @VISTA_UID = E.IDENTIFIER
FROM BMS_EIS.dbo.ENTITY AS E
INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
WHERE O.NAME = @VISTA_CODE AND CODE_CODE ='VST'

DECLARE @COUNT_BU_FROM_LOCAL_FACILITY_DB INT, @COUNT_BU_FROM_BMS INT

SELECT @COUNT_BU_FROM_LOCAL_FACILITY_DB = COUNT(*) 
FROM (
SELECT BED, MAX(UREASONTEXT) as UREASONTEXT
FROM Bed_Control_Availability
WHERE UREASONTEXT <> '' AND UREASONTEXT IS NOT NULL 
GROUP BY BED) BU

SELECT @COUNT_BU_FROM_BMS = COUNT(*) 
FROM BMS.dbo.BED_UNAVAILABLE WHERE VISTA_SITE_UID = @VISTA_UID AND IS_UNAVAILABLE_FROM_VISTA <> 1  AND COMPLETED_DATE IS NULL

IF @COUNT_BU_FROM_LOCAL_FACILITY_DB = @COUNT_BU_FROM_BMS
	BEGIN
		SELECT 'SUCCESS: Bed Unavailable - Data imported!'
	END
	
IF @COUNT_BU_FROM_LOCAL_FACILITY_DB <> @COUNT_BU_FROM_BMS
	BEGIN
			SELECT 'In local database (cls. 3) are ' + CAST(@COUNT_BU_FROM_LOCAL_FACILITY_DB AS NVARCHAR(1000)) + ' bed unavailable.'
			SELECT CAST(@COUNT_BU_FROM_BMS AS NVARCHAR(1000)) + '  bed unavailable has been imported successfully.'
			
			DECLARE @BU_FROM_VISTA INT
			CREATE TABLE #BED(PK INT, BED_NAME NVARCHAR(250), BED_UID UNIQUEIDENTIFIER)
			
			INSERT INTO #BED(PK, BED_NAME, BED_UID)
			SELECT DISTINCT P.PFK_PLACE, P.NAME, E.IDENTIFIER 
			FROM BMS_EIS.dbo.EHL7_PLACE AS P
			INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
			INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MNT'
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT ='SITE'
			WHERE U.IDENTIFIER_EXTENSION = @VISTA_UID
			
			;WITH DUPLICATE_BEDS (PK, BED_NAME)
			AS
			(
			SELECT MAX(PK), BED_NAME
			FROM #BED
			GROUP BY BED_NAME
			)

			DELETE BED FROM #BED AS BED
			LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.PK
			WHERE DEL.PK IS NULL		
			
			SELECT @BU_FROM_VISTA = COUNT(*)
			FROM BMS.dbo.BED_UNAVAILABLE AS BU
			INNER JOIN #BED AS B ON B.BED_UID = BU.BED_UID
			WHERE BU.COMPLETED_DATE IS NULL AND BU.IS_UNAVAILABLE_FROM_VISTA = 1 AND B.BED_NAME IN (SELECT BED 
			FROM Bed_Control_Availability
			WHERE UREASONTEXT <> '' AND UREASONTEXT IS NOT NULL 
			GROUP BY BED)
			
			SELECT CAST(@BU_FROM_VISTA AS NVARCHAR(1000)) + ' bed unavailable has not been imported successfully because these beds are OOS thru VistA.'
			
			IF @COUNT_BU_FROM_LOCAL_FACILITY_DB = @BU_FROM_VISTA + @COUNT_BU_FROM_BMS
				BEGIN
					SELECT 'SUCCESS: Bed Unavailable - Data imported!'
				END	
			ELSE
				BEGIN
					DECLARE @COUNT_BED_WITHOUT_DIVISION INT
					
					SELECT @COUNT_BED_WITHOUT_DIVISION = COUNT(*)
					FROM(
					SELECT BED 
					FROM Bed_Control_Availability
					WHERE UREASONTEXT <> '' AND UREASONTEXT IS NOT NULL 
					GROUP BY BED )B
					WHERE B.BED NOT IN (SELECT DISTINCT BED_NAME FROM #BED)
					
					SELECT 'In local database (cls. 3) are ' + CAST(@COUNT_BED_WITHOUT_DIVISION AS NVARCHAR(1000)) + ' and in BMS database (cls. 1) these beds do not have a division.'
					
					IF @COUNT_BU_FROM_LOCAL_FACILITY_DB = @BU_FROM_VISTA + @COUNT_BU_FROM_BMS + @COUNT_BED_WITHOUT_DIVISION
						BEGIN
							SELECT 'SUCCESS: Bed Unavailable - Data imported!'
						END	
					ELSE
						BEGIN
							SELECT 'If this VistA is not integrated: UNSUCCESS: Bed Unavailable - Data imported.' 
							       + 'Else run the script for each facility per current VistA and sum all results.'
						END						
				END
				
			DROP TABLE #BED
	END

DECLARE @COUNT_INVALID_BED_COMMENT INT
SELECT @COUNT_INVALID_BED_COMMENT = COUNT(*) 
FROM BMS.dbo.BED_UNAVAILABLE WHERE VISTA_SITE_UID = @VISTA_UID AND IS_UNAVAILABLE_FROM_VISTA <> 1  AND COMPLETED_DATE IS NULL AND COMPLETEDBY IS NOT NULL
IF @COUNT_INVALID_BED_COMMENT <> 0 
	BEGIN
		SELECT 'In BMS database (cls.1 ) are ' + CAST(@COUNT_INVALID_BED_COMMENT AS NVARCHAR(250)) + ' where completedby is not null and completed date is null.'
	END







