USE V03BYNBMSDB
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_ID INT
SET @FACILITY_CODE = 'BYN'
SELECT @FACILITY_ID = E.PK_ENTITY
FROM BMS_EIS.dbo.ENTITY AS E
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

CREATE TABLE #WARDGROUP (NAME NVARCHAR(50), ID UNIQUEIDENTIFIER, PK INT)
CREATE TABLE #BEDS (BED_PK INT, BED_NAME NVARCHAR(50), BED_UID UNIQUEIDENTIFIER, WARD_GROUP_NAME NVARCHAR(50), WARD_GROUP_UID UNIQUEIDENTIFIER, COMMENT NVARCHAR(800))


INSERT INTO #WARDGROUP(NAME, ID, PK)
SELECT DISTINCT O.NAME, E.IDENTIFIER, O.PFK_ORGANIZATION
FROM BMS_EIS.[dbo].[EHL7_ORGANIZATION] AS O
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @FACILITY_ID


INSERT INTO #BEDS(BED_PK, BED_NAME, BED_UID, WARD_GROUP_NAME, WARD_GROUP_UID, COMMENT)
SELECT DISTINCT BED.PFK_PLACE, BED.NAME, E.IDENTIFIER, WARD_GROUP.NAME, WARD_GROUP.ID, R_BED.NAME_FAMILY
FROM BMS_EIS.[dbo].[EHL7_PLACE] AS BED
INNER JOIN BMS_EIS.[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
INNER JOIN #WARDGROUP AS WARD_GROUP ON WARD_GROUP.PK = R_BED.FK_SCOPER_ENTITY
WHERE BED.CODE_DISPLAY_NAME ='BED'

;WITH DUPLICATE_BEDS (PK, BED_NAME)
AS
(
SELECT MAX(BED_PK), BED_NAME
FROM #BEDS
GROUP BY BED_NAME
)

DELETE BED FROM #BEDS AS BED
LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.BED_PK
WHERE DEL.PK IS NULL	

DECLARE @COUNT_STAFF_FROM_LOCAL_DATABASE INT, @COUNT_STAFF_FROM_BMS_DATABASE INT, @COUNT_STAFF_FROM_BMS_EIS_DATABASE INT

SELECT @COUNT_STAFF_FROM_LOCAL_DATABASE = COUNT(*)
FROM [Bed_Control_Whiteboard_Log] AS STAFF
	INNER JOIN #BEDS AS BED ON BED.BED_NAME = STAFF.VistaBed AND BED.WARD_GROUP_NAME = STAFF.Ward
	WHERE STAFF.AssignedNur <> '' AND STAFF.AssignedNur IS NOT NULL AND STAFF.RecNum IN (SELECT MAX(RecNum) FROM [Bed_Control_Whiteboard_Log] GROUP BY VistaBed)

SELECT @COUNT_STAFF_FROM_BMS_DATABASE = COUNT(*)
FROM BMS.dbo.BED_STAFF AS S
INNER JOIN #BEDS AS BED ON BED.BED_UID= S.BED_UID


SELECT @COUNT_STAFF_FROM_BMS_EIS_DATABASE = COUNT(*) 
FROM BMS_EIS.dbo.TRAIT_VALUE AS TV
INNER JOIN #BEDS AS BED ON BED.BED_PK = TV.FK_ENTITY
WHERE TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = 406 AND TV.TRAIT_VALUE_STRING IS NOT NULL AND TV.TRAIT_VALUE_STRING <> ''

IF @COUNT_STAFF_FROM_BMS_DATABASE = @COUNT_STAFF_FROM_LOCAL_DATABASE AND @COUNT_STAFF_FROM_LOCAL_DATABASE =  @COUNT_STAFF_FROM_BMS_EIS_DATABASE
	SELECT 'BED STAFF SUCCESSFULLY IMPORTED'
ELSE
	BEGIN
		SELECT 'IN LOCAL DATABASE (CLASS 3) ARE: ' + CAST(@COUNT_STAFF_FROM_LOCAL_DATABASE AS NVARCHAR(MAX)) + ' BED STAFF'
		SELECT 'IN BMS DATABASE (CLASS 1) ARE: ' + CAST(@COUNT_STAFF_FROM_BMS_DATABASE AS NVARCHAR(MAX)) + ' BED STAFF'
		SELECT 'IN BMS_EIS DATABASE (CLASS 1) ARE: ' + CAST(@COUNT_STAFF_FROM_BMS_EIS_DATABASE AS NVARCHAR(MAX)) + ' BED STAFF'
	END

DROP TABLE #BEDS
DROP TABLE #WARDGROUP 
