USE V03BYNBMSDB
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_ID INT, @START_DATE DATETIME
--@START_DATE - INITIAL START DATE
SET @START_DATE = '20110210' 
SET @FACILITY_CODE = 'BYN'
SELECT @FACILITY_ID = E.PK_ENTITY
FROM BMS_EIS.dbo.ENTITY AS E
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

CREATE TABLE #WARDGROUP (NAME NVARCHAR(50), ID UNIQUEIDENTIFIER, PK INT)
CREATE TABLE #BEDS (PK INT, BED_NAME NVARCHAR(50), BED_UID UNIQUEIDENTIFIER, WARD_GROUP_NAME NVARCHAR(50), WARD_GROUP_UID UNIQUEIDENTIFIER, COMMENT NVARCHAR(800))

INSERT INTO #WARDGROUP(NAME, ID, PK)
SELECT DISTINCT O.NAME, E.IDENTIFIER, O.PFK_ORGANIZATION
FROM BMS_EIS.[dbo].[EHL7_ORGANIZATION] AS O
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @FACILITY_ID

INSERT INTO #BEDS(PK, BED_NAME, BED_UID, WARD_GROUP_NAME, WARD_GROUP_UID, COMMENT)
SELECT DISTINCT BED.PFK_PLACE, BED.NAME, E.IDENTIFIER, WARD_GROUP.NAME, WARD_GROUP.ID, R_BED.NAME_FAMILY
FROM BMS_EIS.[dbo].[EHL7_PLACE] AS BED
INNER JOIN BMS_EIS.[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
INNER JOIN #WARDGROUP AS WARD_GROUP ON WARD_GROUP.PK = R_BED.FK_SCOPER_ENTITY
WHERE BED.CODE_DISPLAY_NAME ='BED'

;WITH DUPLICATE_BEDS (PK, BED_NAME)
AS
(
SELECT MAX(PK), BED_NAME
FROM #BEDS
GROUP BY BED_NAME
)

DELETE BED FROM #BEDS AS BED
LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.PK
WHERE DEL.PK IS NULL		

DECLARE @COUNT_COMMENT_FROM_LOCAL_DATABASE INT, @COUNT_COMMENT_FROM_BMS_DATABASE INT

SELECT @COUNT_COMMENT_FROM_LOCAL_DATABASE = COUNT(*)
FROM Bed_Control_Comment_Log AS COMMENT
	INNER JOIN #BEDS AS BED ON BED.BED_NAME = COMMENT.BED AND BED.WARD_GROUP_NAME = COMMENT.WARD 
	WHERE COMMENT.DataOS <> '' AND COMMENT.DataOS IS NOT NULL AND COMMENT.RECNUM IN (SELECT MAX(RECNUM) 
															FROM Bed_Control_Comment_Log
															WHERE DateTimeOS >= @START_DATE
															GROUP BY BED, WARD)
															
SELECT @COUNT_COMMENT_FROM_BMS_DATABASE = COUNT(*)
FROM #BEDS WHERE COMMENT IS NOT NULL AND COMMENT <> ''

IF @COUNT_COMMENT_FROM_BMS_DATABASE = @COUNT_COMMENT_FROM_LOCAL_DATABASE
	SELECT 'COMMENT SUCCESFULLY IMPORTED'
ELSE
	BEGIN
		SELECT 'IN LOCAL DATABASE (CLASS 3) ARE ' + CAST(@COUNT_COMMENT_FROM_LOCAL_DATABASE AS NVARCHAR(MAX)) + 'COMMENTS'
		SELECT 'IN BMS DATABASE (CLASS 1) ARE ' + CAST(@COUNT_COMMENT_FROM_BMS_DATABASE AS NVARCHAR(MAX)) + 'COMMENTS'
	END

DROP TABLE #BEDS
DROP TABLE #WARDGROUP