/*
	Before running the script - replace the name of the databases where:
		1. CURRENT_BMS_EIS - the name of the BMS_EIS database (SOURCE);
		2. CURRENT_BMS - the name of the BMS database (SOURCE);
		3. BMS_EIS - the name of the BMS_EIS database (DESTINATION);
		4. BMS - the name of the BMS database (DESTINATION);
*/

DECLARE @FACILITY_CODE NVARCHAR(20), @SOURCE_FACILITY_UID UNIQUEIDENTIFIER, @DESTINATION_FACILITY_UID UNIQUEIDENTIFIER, @SOURCE_VISTA_UID UNIQUEIDENTIFIER,
		@DESTINATION_VISTA_UID UNIQUEIDENTIFIER, @SOURCE_FOUND_ENTRIES INT, @DESTINATION_FOUND_ENTRIES INT, @VISTA_CODE NVARCHAR(50)
SET @FACILITY_CODE = 'BRK'

SELECT @SOURCE_FACILITY_UID = E.IDENTIFIER, @SOURCE_VISTA_UID = VSE.IDENTIFIER
FROM CURRENT_BMS_EIS.dbo.ENTITY AS E 
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS VSE ON V.FK_ENTITY = VSE.PK_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

SELECT @DESTINATION_FACILITY_UID = E.IDENTIFIER, @DESTINATION_VISTA_UID = VSE.IDENTIFIER, @VISTA_CODE = V.IDENTIFIER_EXTENSION
FROM BMS_EIS.dbo.ENTITY AS E 
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN BMS_EIS.dbo.ENTITY AS VSE ON V.FK_ENTITY = VSE.PK_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

IF @SOURCE_FACILITY_UID IS NULL OR @DESTINATION_FACILITY_UID IS NULL
	BEGIN
		SELECT 'FACILITY NOT FOUND'
		RETURN
	END
IF @SOURCE_VISTA_UID IS NULL OR @DESTINATION_VISTA_UID IS NULL
	BEGIN
		SELECT 'VISTA NOT FOUND'
	END

IF @VISTA_CODE IS NULL
	BEGIN
		SELECT 'VISTA CODE NOT FOUND'
	END

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.ADMISSION_EVN
WHERE VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.ADMISSION_EVN
WHERE VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'ADMISSION_EVN TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'ADMISSION_EVN TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.ADMISSION_LEVEL_OF_CARE AS ADM_LEVEL
INNER JOIN CURRENT_BMS.dbo.ADMISSION_EVN AS EVN ON EVN.ID = ADM_LEVEL.ADMISSION_ID
WHERE EVN.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.ADMISSION_LEVEL_OF_CARE AS ADM_LEVEL
INNER JOIN BMS.dbo.ADMISSION_EVN AS EVN ON EVN.ID = ADM_LEVEL.ADMISSION_ID
WHERE EVN.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'ADMISSION_LEVEL_OF_CARE TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'ADMISSION_LEVEL_OF_CARE TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.ADMISSION_REQ
WHERE VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.ADMISSION_REQ
WHERE VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'ADMISSION_REQ TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'ADMISSION_REQ TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.BED_CLEAN
WHERE VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.BED_CLEAN
WHERE VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'BED_CLEAN TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BED_CLEAN TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.BED_REASON_COMMENT_HISTORY
WHERE VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.BED_REASON_COMMENT_HISTORY
WHERE VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'BED_REASON_COMMENT_HISTORY TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BED_REASON_COMMENT_HISTORY TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL
 
SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.BED_STAFF
WHERE FACILITY_UID = @SOURCE_FACILITY_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.BED_STAFF
WHERE FACILITY_UID = @DESTINATION_FACILITY_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'BED_STAFF TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BED_STAFF TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.BED_SWITCH
WHERE VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.BED_SWITCH
WHERE VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'BED_SWITCH TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BED_SWITCH TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.BED_UNAVAILABLE AS BU
INNER JOIN CURRENT_BMS.dbo.ACT AS A ON A.ID = BU.ACT_ID
WHERE BU.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.BED_UNAVAILABLE AS BU
INNER JOIN BMS.dbo.ACT AS A ON A.ID = BU.ACT_ID
WHERE BU.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'BED_UNAVAILABLE TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BED_UNAVAILABLE TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.BED_UNAVAILABLE AS BU
INNER JOIN CURRENT_BMS.dbo.BED_UNAVAILABLE_WARD AS BUW ON BUW.BED_UNAVAILABLE_ID = BU.ACT_ID
INNER JOIN CURRENT_BMS.dbo.ACT AS A ON A.ID = BU.ACT_ID
WHERE BU.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.BED_UNAVAILABLE AS BU
INNER JOIN BMS.dbo.BED_UNAVAILABLE_WARD AS BUW ON BUW.BED_UNAVAILABLE_ID = BU.ACT_ID
INNER JOIN BMS.dbo.ACT AS A ON A.ID = BU.ACT_ID
WHERE BU.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'BED_UNAVAILABLE_WARD TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BED_UNAVAILABLE_WARD TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

DECLARE @EVS_VISTA_FACILITY_CODE NVARCHAR(50), @EVS_VISTA_CODE NVARCHAR(50)
SET @EVS_VISTA_FACILITY_CODE = @VISTA_CODE + '_' + @FACILITY_CODE + '_'
SET @EVS_VISTA_CODE = @VISTA_CODE + '_'

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.CONCEPT
WHERE CODE_SYSTEM_NAME IN ('VistaSpecialty', 'Era')

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.CONCEPT
WHERE CODE_SYSTEM_NAME IN ('VistaSpecialty', 'Era')

SELECT @SOURCE_FOUND_ENTRIES = @SOURCE_FOUND_ENTRIES + COUNT(*)
FROM CURRENT_BMS.dbo.CONCEPT
WHERE CODE_SYSTEM_NAME IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND CODE LIKE ''+ @EVS_VISTA_CODE +'%'

SELECT @DESTINATION_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES + COUNT(*)
FROM BMS.dbo.CONCEPT
WHERE CODE_SYSTEM_NAME IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND CODE LIKE ''+ @EVS_VISTA_CODE +'%'
	  
SELECT @SOURCE_FOUND_ENTRIES = @SOURCE_FOUND_ENTRIES + COUNT(*)
FROM CURRENT_BMS.dbo.CONCEPT
WHERE CODE_SYSTEM_NAME IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND CODE LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'

SELECT @DESTINATION_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES + COUNT(*)
FROM BMS.dbo.CONCEPT
WHERE CODE_SYSTEM_NAME IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND CODE LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'CONCEPT TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'CONCEPT TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.CONFIG 
WHERE SECTION LIKE '%' + CAST(@SOURCE_VISTA_UID AS NVARCHAR(50))+ '%'

SELECT @SOURCE_FOUND_ENTRIES = @SOURCE_FOUND_ENTRIES + COUNT(*)
FROM CURRENT_BMS.dbo.CONFIG 
WHERE SECTION LIKE '%' + CAST(@SOURCE_FACILITY_UID AS NVARCHAR(50)) + '%'

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.CONFIG 
WHERE SECTION LIKE '%' + CAST(@DESTINATION_VISTA_UID AS NVARCHAR(50)) + '%'

SELECT @DESTINATION_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES + COUNT(*)
FROM BMS.dbo.CONFIG 
WHERE SECTION LIKE '%' + CAST(@DESTINATION_FACILITY_UID AS NVARCHAR(50))+ '%'

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'CONFIG TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'CONFIG TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.CONFIG_EIS 
WHERE ENTITY_ID = @SOURCE_FACILITY_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.CONFIG_EIS 
WHERE ENTITY_ID = @DESTINATION_FACILITY_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'CONFIG_EIS TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'CONFIG_EIS TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.CONFIG_EVS AS D
LEFT OUTER JOIN CURRENT_BMS.dbo.CONFIG_EVS AS S ON S.CODE = D.CODE AND S.CODE_SYSTEM = D.CODE_SYSTEM
WHERE S.CODE IS NULL

IF @DESTINATION_FOUND_ENTRIES IS NULL OR @DESTINATION_FOUND_ENTRIES = 0
	BEGIN
		SELECT 'CONFIG_EVS TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'CONFIG_EVS TABLE UNSUCCESSFULLY IMPORTED'
	END

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.DISCHARGE_EVN AS EVN
WHERE EVN.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.DISCHARGE_EVN AS EVN
WHERE EVN.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'DISCHARGE_EVN TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'DISCHARGE_EVN TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.DISCHARGE_INT AS D_INT
WHERE D_INT.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.DISCHARGE_INT AS D_INT
WHERE D_INT.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'DISCHARGE_INT TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'DISCHARGE_INT TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.DISCHARGE_REQ AS DIS
WHERE DIS.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.DISCHARGE_REQ AS DIS
WHERE DIS.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'DISCHARGE_REQ TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'DISCHARGE_REQ TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.DIVERSION AS DIS
WHERE DIS.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.DIVERSION AS DIS
WHERE DIS.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'DIVERSION TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'DIVERSION TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.HOSPITAL_LOCATION_APPOINTMENT AS TBL
WHERE TBL.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.HOSPITAL_LOCATION_APPOINTMENT AS TBL
WHERE TBL.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'HOSPITAL_LOCATION_APPOINTMENT TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'HOSPITAL_LOCATION_APPOINTMENT TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.JOB_AUDIT AS TBL
WHERE TBL.VISTA_ID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.JOB_AUDIT AS TBL
WHERE TBL.VISTA_ID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'JOB_AUDIT TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'JOB_AUDIT TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(PAR.JOB_AUDIT_ID)
FROM CURRENT_BMS.dbo.JOB_AUDIT_PARAM AS PAR
INNER JOIN CURRENT_BMS.dbo.JOB_AUDIT AS TBL ON TBL.ID = PAR.JOB_AUDIT_ID
WHERE TBL.VISTA_ID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(PAR.JOB_AUDIT_ID)
FROM CURRENT_BMS.dbo.JOB_AUDIT_PARAM AS PAR
INNER JOIN BMS.dbo.JOB_AUDIT AS TBL ON TBL.ID = PAR.JOB_AUDIT_ID
WHERE TBL.VISTA_ID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'JOB_AUDIT_PARAM TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'JOB_AUDIT_PARAM TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.MOVEMENT_EVN AS TBL
WHERE TBL.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.MOVEMENT_EVN AS TBL
WHERE TBL.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'MOVEMENT_EVN TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'MOVEMENT_EVN TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.MOVEMENT_REQ AS TBL
WHERE TBL.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.MOVEMENT_REQ AS TBL
WHERE TBL.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'MOVEMENT_REQ TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'MOVEMENT_REQ TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.ORDER_FACILITY AS TBL
WHERE TBL.FACILITY_UID = @SOURCE_FACILITY_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.ORDER_FACILITY AS TBL
WHERE TBL.FACILITY_UID = @DESTINATION_FACILITY_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'ORDER_FACILITY TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'ORDER_FACILITY TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.SCHEDULED_ADMISSION AS TBL
WHERE TBL.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.SCHEDULED_ADMISSION AS TBL
WHERE TBL.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'SCHEDULED_ADMISSION TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'SCHEDULED_ADMISSION TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(TBL.ID)
FROM CURRENT_BMS.dbo.SPECIALTY_TRANSFER AS TBL
INNER JOIN CURRENT_BMS.dbo.ADMISSION_EVN AS EVN ON EVN.ID = TBL.ADMISSION_ID
WHERE TBL.VISTA_SITE_UID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(TBL.ID)
FROM BMS.dbo.SPECIALTY_TRANSFER AS TBL
INNER JOIN BMS.dbo.ADMISSION_EVN AS EVN ON EVN.ID = TBL.ADMISSION_ID
WHERE TBL.VISTA_SITE_UID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'SPECIALTY_TRANSFER TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'SPECIALTY_TRANSFER TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.TRANSFER_REQ AS TBL
WHERE TBL.FACILITY_UID = @SOURCE_FACILITY_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.TRANSFER_REQ AS TBL
WHERE TBL.FACILITY_UID = @DESTINATION_FACILITY_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'TRANSFER_REQ TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'TRANSFER_REQ TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(TBL.ACT_ID)
FROM CURRENT_BMS.dbo.TRANSFER_EVN AS TBL
INNER JOIN CURRENT_BMS.dbo.ACT AS A ON A.ID = TBL.ACT_ID
INNER JOIN CURRENT_BMS.dbo.TRANSFER_REQ AS REQ ON REQ.ACT_ID = A.PARENT_ACT_ID
WHERE REQ.FACILITY_UID = @SOURCE_FACILITY_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(TBL.ACT_ID)
FROM BMS.dbo.TRANSFER_EVN AS TBL
INNER JOIN BMS.dbo.ACT AS A ON A.ID = TBL.ACT_ID
INNER JOIN BMS.dbo.TRANSFER_REQ AS REQ ON REQ.ACT_ID = A.PARENT_ACT_ID
WHERE REQ.FACILITY_UID = @DESTINATION_FACILITY_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'TRANSFER_EVN TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'TRANSFER_EVN TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.VISTA_INTEGRATION_LOG AS TBL
WHERE TBL.VISTA = @VISTA_CODE

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.VISTA_INTEGRATION_LOG AS TBL
WHERE TBL.VISTA = @VISTA_CODE

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'VISTA_INTEGRATION_LOG TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'VISTA_INTEGRATION_LOG TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.VISTA_OPERATIONS AS TBL
WHERE TBL.VISTA_ID = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.VISTA_OPERATIONS AS TBL
WHERE TBL.VISTA_ID = @DESTINATION_VISTA_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'VISTA_OPERATIONS TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'VISTA_OPERATIONS TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS.dbo.WAITING_LIST AS TBL
INNER JOIN CURRENT_BMS.dbo.ACT AS A ON A.ID = TBL.ACT_ID
WHERE TBL.FACILITY_UID = @SOURCE_FACILITY_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS.dbo.WAITING_LIST AS TBL
INNER JOIN BMS.dbo.ACT AS A ON A.ID = TBL.ACT_ID
WHERE TBL.FACILITY_UID = @DESTINATION_FACILITY_UID

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES
	BEGIN
		SELECT 'WAITING_LIST TABLE SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'WAITING_LIST TABLE UNSUCCESSFULLY IMPORTED' + ' IN SOURCE DATABASE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	END
	
SET @DESTINATION_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_ENTRIES = NULL