
CREATE TABLE #regionsTable (NUMBER NUMERIC(15,0), ID UNIQUEIDENTIFIER)
CREATE TABLE #visnsTable (NUMBER NUMERIC(15,0), ID UNIQUEIDENTIFIER, REGION NUMERIC(15,0))
CREATE TABLE #vistaTable (NAME NVARCHAR(20), ID UNIQUEIDENTIFIER, VISN NUMERIC(15,0), NUMBER NVARCHAR(3))
CREATE TABLE #facilitiesTable (NAME NVARCHAR(150), ID UNIQUEIDENTIFIER, VISTA_SITE NVARCHAR(20), CODE NVARCHAR(10), SITE_NUMBER NVARCHAR(50), CITY VARCHAR(100), STATE VARCHAR(3))
CREATE TABLE #vistaConfigurationtVistaTimeZoneTable (ID UNIQUEIDENTIFIER)
CREATE TABLE #vistaConfigurationtVistaLocalTimeAdjustTable (ID UNIQUEIDENTIFIER)

DECLARE @SQL NVARCHAR(MAX)

--REGIONS
INSERT INTO #regionsTable (NUMBER)
SELECT DISTINCT REGION FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data]
WHERE SiteID IS NOT NULL AND BMSSiteYN = 'YES'

UPDATE #regionsTable 
 SET ID = NEWID()
WHERE ID IS NULL 

SET @SQL = COALESCE(@SQL, '')
SELECT @SQL = @SQL + ' 
		EXEC $(varBMS_EIS).dbo.INSERT_REGION @Name = ''Region ' + CAST(NUMBER AS NVARCHAR(5)) + ''', @Number = ''' + CAST(NUMBER AS NVARCHAR(5)) + ''', @REGION_UID = ''' + CAST(ID AS NVARCHAR(50)) + ''''
FROM #regionsTable
EXECUTE sp_executesql @SQL

--VISNS
INSERT INTO #visnsTable (NUMBER,  REGION)
SELECT DISTINCT VISN, REGION FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data]
WHERE SiteID IS NOT NULL AND BMSSiteYN = 'YES'

UPDATE #visnsTable 
 SET ID = NEWID()
WHERE ID IS NULL 

SET @SQL = ''
SELECT @SQL = @SQL + ' 
		EXEC $(varBMS_EIS).dbo.INSERT_VISN @Name = ''VISN ' + CAST(V.NUMBER AS NVARCHAR(5)) + ''', @Number = ''' + CAST(V.NUMBER AS NVARCHAR(5)) + ''', @VISN_UID = ''' + CAST(V.ID AS NVARCHAR(50)) + ''', @REGION_UID = ''' + CAST(R.ID AS NVARCHAR(50)) + ''''
FROM #visnsTable AS V
	INNER JOIN #regionsTable AS R ON V.REGION = R.NUMBER
EXECUTE sp_executesql @SQL

--VISTA SITES
INSERT INTO #vistaTable (NAME, VISN, NUMBER)
SELECT DISTINCT LEFT(VISTAODBCName, LEN(VISTAODBCName)-5), VISN, LEFT(SiteNumber, 3)
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data]
WHERE SiteID IS NOT NULL AND BMSSiteYN = 'YES'

UPDATE #vistaTable 
 SET ID = NEWID()
WHERE ID IS NULL 

SET @SQL = ''
SELECT @SQL = @SQL + ' 
		EXEC $(varBMS_EIS).dbo.INSERT_VISTA_SITES @Name = ''' + V.NAME + ''', @Number = ''' + V.NUMBER + ''', @Code = ''' + V.NAME + ''', @VISTA_SITE_UID = ''' + CAST(V.ID AS NVARCHAR(50)) + ''', @VISN_UID = ''' + CAST(VISN.ID AS NVARCHAR(50)) + ''''		
FROM #vistaTable AS V
	INNER JOIN #visnsTable AS VISN ON V.VISN = VISN.NUMBER
EXECUTE sp_executesql @SQL

--FACILITIES
INSERT INTO #facilitiesTable (NAME, VISTA_SITE, CODE, SITE_NUMBER, CITY, STATE)
SELECT DISTINCT UPPER(NameText), LEFT(VISTAODBCName, LEN(VISTAODBCName)-5), UPPER(SiteID), SiteNumber, UPPER(City), UPPER(State)
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data]
WHERE SiteID IS NOT NULL AND BMSSiteYN = 'YES'

UPDATE #facilitiesTable 
 SET ID = NEWID()
WHERE ID IS NULL 

UPDATE #facilitiesTable
 SET NAME = Replace(NAME, '''','''''') 
WHERE NAME like '%''%'

SET @SQL = ''
SELECT @SQL = @SQL + ' 
		EXEC $(varBMS_EIS).dbo.INSERT_FACILITY @NAME = N''' + F.NAME + ''', @CODE = ''' + F.CODE + ''', @CITY = ''' + F.CITY + ''', @STATE = ''' + F.STATE + ''', @SITE_NUMBER = ''' + F.SITE_NUMBER + ''', @FACILITY_UID =''' + CAST(F.ID AS NVARCHAR(50)) + ''', @VISTA_SITE_UID = ''' + CAST(V.ID AS NVARCHAR(50)) + ''''
FROM #facilitiesTable AS F
	INNER JOIN #vistaTable AS V ON F.VISTA_SITE = V.NAME
EXECUTE sp_executesql @SQL

--FACILITY CONFIG VALUES
SET @SQL = 'DECLARE @CONFIG_ID INT '
-- ADT PREFIX
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''ADTPrefix'', ''' + SD.ADTPrefix + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.ADTPrefix IS NOT NULL AND SD.ADTPrefix <> ''

--ADT SUFFIX
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''ADTSuffix'', ''' + SD.ADTSuffix + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.ADTSuffix IS NOT NULL AND SD.ADTSuffix <> ''

-- WARD PREFIX
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''WardPrefix'', ''' + SD.IntegratedPrefix + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.IntegratedPrefix IS NOT NULL AND SD.IntegratedPrefix <> ''
-- WARD SUFFIX
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''WardSuffix'', ''' + SD.IntegratedSuffix + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.IntegratedSuffix IS NOT NULL AND SD.IntegratedSuffix <> ''

-- SITE ALIAS 1
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''SiteAlias1'', ''' + SD.SiteID2 + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.SiteID2 IS NOT NULL AND SD.SiteID2 <> ''

-- SITE ALIAS 2
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''SiteAlias2'', ''' + SD.SiteID3 + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.SiteID3 IS NOT NULL AND SD.SiteID3 <> ''

-- SITE ALIAS 3
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''SiteAlias3'', ''' + SD.SiteID4 + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.SiteID4 IS NOT NULL AND SD.SiteID4 <> ''

-- EMS MAIL SENDER
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''EMSMailSender'', ''' + SD.EMSEmailSender + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.EMSEmailSender IS NOT NULL AND SD.EMSEmailSender <> ''

-- EVENT MAIL SENDER
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''EventMailSender'', ''' + SD.EventEmailSender + ''', ''APP'', ''ST'', '''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.EventEmailSender IS NOT NULL AND SD.EventEmailSender <> ''

-- LOCAL TIME ADJUST AND VISTA LOCAL TIME ADJUST
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''LocalTimeAdjust'', ''' + SD.TimeAdjust + ''', ''APP'', ''INT'', '''')
	IF (SELECT COUNT(ID) FROM #vistaConfigurationtVistaLocalTimeAdjustTable WHERE ID = ''' + CAST(V.ID AS NVARCHAR(50)) + ''') = 0
	BEGIN
		INSERT INTO #vistaConfigurationtVistaLocalTimeAdjustTable(ID) VALUES (''' + CAST(V.ID AS NVARCHAR(50)) + ''')
		INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)	
		VALUES (''InfoWorld'', '''', ''VistASettings ' + CAST(V.ID AS NVARCHAR(50)) + ''', ''VistALocalTimeAdjust'', ''' + SD.TimeAdjust + ''', ''APP'', ''INT'', '''')
	END	
	'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD 
INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
INNER JOIN #vistaTable AS V ON V.NAME = F.VISTA_SITE
WHERE SD.TimeAdjust IS NOT NULL AND SD.TimeAdjust <> ''


-- AUTO REMOVAL WAITING LIST
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES ( ''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''AutoRemovalWaitingList'', NULL, ''APP'', ''EVS'', '''')
	SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
	INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
	VALUES (@CONFIG_ID, ''' + UPPER(LEFT(SD.AutoWaitRemoveYN,1))+LOWER(SUBSTRING(SD.AutoWaitRemoveYN,2,LEN(SD.AutoWaitRemoveYN))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(SD.AutoWaitRemoveYN,1))+LOWER(SUBSTRING(SD.AutoWaitRemoveYN,2,LEN(SD.AutoWaitRemoveYN))) + ''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.AutoWaitRemoveYN IS NOT NULL AND SD.AutoWaitRemoveYN <> ''

-- INTEGRATED FACILITY
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''IntegratedFacility'', NULL, ''APP'', ''EVS'', '''')
	SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
	INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
	VALUES (@CONFIG_ID, ''' + UPPER(LEFT(SD.IntegratedYN,1))+LOWER(SUBSTRING(SD.IntegratedYN,2,LEN(SD.IntegratedYN))) + ''', ''2.12.24.15'', ''StrictDecision'', ''' + UPPER(LEFT(SD.IntegratedYN,1))+LOWER(SUBSTRING(SD.IntegratedYN,2,LEN(SD.IntegratedYN))) + ''')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
WHERE SD.IntegratedYN IS NOT NULL AND SD.IntegratedYN <> ''


-- TIME ZONE AND VISTA TIME ZONE
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''FacilitySiteTimeZone'', NULL, ''APP'', ''EVS'', '''')
	SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
	INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
	VALUES (@CONFIG_ID, ''' + SD.TimeZone + ''', ''2.12.24.6'', ''TimeZone'', ''' + CP.propertyValue + ''')	
	IF (SELECT COUNT(ID) FROM #vistaConfigurationtVistaTimeZoneTable WHERE ID = ''' + CAST(V.ID AS NVARCHAR(50)) + ''') = 0
	BEGIN
		INSERT INTO #vistaConfigurationtVistaTimeZoneTable(ID) VALUES (''' + CAST(V.ID AS NVARCHAR(50)) + ''')
		INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
		VALUES (''InfoWorld'', '''', ''VistASettings ' + CAST(V.ID AS NVARCHAR(50)) + ''', ''VistASiteTimeZone'', NULL, ''APP'', ''EVS'', '''')
		SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
		INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
		VALUES (@CONFIG_ID, ''' + SD.TimeZone + ''', ''2.12.24.6'', ''TimeZone'', ''' + CP.propertyValue + ''')	
	END
	'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD 
	INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
	INNER JOIN $(varBMS_EVS).dbo.conceptProperty AS CP ON SD.TimeZone = CP.conceptCode AND CP.codingSchemeName = 'TimeZone' AND CP.property = 'textualPresentation'
	INNER JOIN #vistaTable AS V ON V.NAME = F.VISTA_SITE
WHERE SD.TimeZone IS NOT NULL AND SD.TimeZone <> ''

-- CONFIG: INSERT SISTER SITES
CREATE TABLE #sisterSitesTable (NR INT, CODES NVARCHAR(100), UIDS NVARCHAR(MAX))
INSERT INTO #sisterSitesTable (NR, CODES)
SELECT DISTINCT DENSE_RANK()  OVER (ORDER BY SharedSiteList), SharedSiteList FROM $(varBMS_NATIONAL_FACILITY).dbo.BMS_SharedSites_Data WHERE SharedSiteList IS NOT NULL AND LEN(SharedSiteList) > 0
DECLARE @SS_COUNT INT, @I INT, @SISTER_CODES NVARCHAR(100), @SISTER_UIDS NVARCHAR(MAX)
SELECT @SS_COUNT = MAX(NR) FROM #sisterSitesTable
SET @I = 1
WHILE @I <= @SS_COUNT
BEGIN
	SELECT @SISTER_CODES = CODES FROM #sisterSitesTable WHERE NR = @I
	SET @SISTER_UIDS = ''
	SELECT @SISTER_UIDS = @SISTER_UIDS + CAST(E.IDENTIFIER AS NVARCHAR(50)) + ', '
		FROM $(varBMS).dbo.AUTHZ_GET_STRTOKENS(@SISTER_CODES,',') AS SPL 
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS U ON U.IDENTIFIER_EXTENSION = SPL.TOK AND U.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON U.FK_ENTITY = O.PFK_ORGANIZATION AND O.CODE_CODE = 'FAC'
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
	UPDATE #sisterSitesTable 
		SET UIDS = LEFT(@SISTER_UIDS, LEN(@SISTER_UIDS)-1) WHERE NR = @I
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES ('InfoWorld', '', 'Sister Sites', CAST(@I AS NVARCHAR(5)), LEFT(@SISTER_UIDS, LEN(@SISTER_UIDS)-1), 'APP', 'ST', 'Sister Sites Group' + CAST(@I AS NVARCHAR(5)))
	SET @I = @I + 1
END

-- FACILITY SISTER SITES
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(F.ID AS NVARCHAR(50)) + ''', ''IntegratedSiteSisterConfigKey'', ' + 
    (SELECT TOP 1 CONFIG_KEY FROM $(varBMS).dbo.CONFIG WHERE SECTION='Sister Sites' AND CONFIG_VALUE LIKE '%'+CAST(F.ID AS NVARCHAR(50))+'%') + ', ''APP'', ''INT'', '''')'
FROM #facilitiesTable AS F
	INNER JOIN $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD  ON SD.SiteID = F.CODE
WHERE SD.IntegratedSiteList IS NOT NULL AND LEN(SD.IntegratedSiteList) > 0
	AND (SELECT COUNT(CONFIG_KEY) FROM $(varBMS).dbo.CONFIG WHERE SECTION='Sister Sites' AND CONFIG_VALUE LIKE '%'+CAST(F.ID AS NVARCHAR(50))+'%') > 0

EXECUTE sp_executesql @SQL

-- EIS: FACILITY ADDRESS
SET @SQL = ''
SELECT @SQL = @SQL + ' 
	EXEC $(varBMS_EIS).dbo.UPD_ADDRESS @FK_ENTITY=' + CAST(E.PK_ENTITY AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@HOUSE_NUMBER=NULL,@DIRECTION=NULL,@STREET_NAME=N''' + ISNULL(SD.Address1, '') + ''',@ADDITIONAL_LOCATOR=NULL,@CITY=N''' + ISNULL(UPPER(SD.City), '') + ''',@COUNTY=N''' + ISNULL(UPPER(SD.State), '') + ''',@COUNTRY=N''' + ISNULL(UPPER(SD.State), '') + ''',@POSTAL_CODE=N''' + ISNULL(SD.Zip, '') + ''',@USE=N''32''
	EXEC $(varBMS_EIS).dbo.UPD_ADDRESS @FK_ENTITY=' + CAST(E.PK_ENTITY AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@HOUSE_NUMBER=NULL,@DIRECTION=NULL,@STREET_NAME=N''' + ISNULL(SD.Address2, '') + ''',@ADDITIONAL_LOCATOR=NULL,@CITY=NULL,@COUNTY=NULL,@COUNTRY=NULL,@POSTAL_CODE=NULL,@USE=N''8''
	EXEC $(varBMS_EIS).dbo.UPD_TELECOM @FK_ENTITY=' + CAST(E.PK_ENTITY AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@TELECOM=N''mailto:' + ISNULL(SD.POCEmail, '') + ''',@USE=32,@CONTACT=N''CONTACT2''
	EXEC $(varBMS_EIS).dbo.UPD_TELECOM @FK_ENTITY=' + CAST(E.PK_ENTITY AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@TELECOM=N''tel:' + ISNULL(SD.POCTelephone, '') + ''',@USE=32,@CONTACT=N''CONTACT3''
	EXEC $(varBMS_EIS).dbo.UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(E.IDENTIFIER AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@TRAIT_IDENTIFIER=N''POINT_OF_CONTACT'',@TRAIT_VALUE_STRING=N''' + ISNULL(SD.PointOfContact, '') + ''',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
	EXEC $(varBMS_EIS).dbo.UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(E.IDENTIFIER AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@TRAIT_IDENTIFIER=N''IS_ALIVE'',@TRAIT_VALUE_STRING=N''TRUE'',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL'	
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD 
	INNER JOIN #facilitiesTable AS F ON SD.SiteID = F.CODE
	INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON F.ID = CAST(E.IDENTIFIER AS UNIQUEIDENTIFIER)
EXECUTE sp_executesql @SQL

DROP TABLE #regionsTable
DROP TABLE #visnsTable
DROP TABLE #vistaTable
DROP TABLE #facilitiesTable
DROP TABLE #vistaConfigurationtVistaTimeZoneTable
DROP TABLE #vistaConfigurationtVistaLocalTimeAdjustTable
DROP TABLE #sisterSitesTable

CREATE TABLE #WRONG_VISTA_SITE (WRONG_VISTA_ID INT, FACILITY_CODE NVARCHAR(250), WRONG_VISTA_UID UNIQUEIDENTIFIER)
CREATE TABLE #GOOD_VISTA_SITE (GOOD_VISTA_ID INT, GOOD_VISTA_NAME NVARCHAR(250))

INSERT INTO #WRONG_VISTA_SITE(WRONG_VISTA_ID, FACILITY_CODE, WRONG_VISTA_UID)
SELECT	O_VISTA.PFK_ORGANIZATION, F.IDENTIFIER_EXTENSION, E_VISTA.IDENTIFIER
FROM $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = O.PFK_ORGANIZATION AND R.CLASS_CODE = 'MBR'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O_VISTA ON O_VISTA.PFK_ORGANIZATION = R.FK_SCOPER_ENTITY
	INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E_VISTA ON O_VISTA.PFK_ORGANIZATION = E_VISTA.PK_ENTITY
WHERE F.IDENTIFIER_EXTENSION IN ('BOS','BRK','WRX','NYN','BYN','KAN','CMO','TOP','LEA','WIC','FTM','HOT','OMA','CIH','IOW')

INSERT INTO #GOOD_VISTA_SITE(GOOD_VISTA_ID, GOOD_VISTA_NAME)
SELECT PFK_ORGANIZATION, NAME
FROM $(varBMS_EIS).dbo.EHL7_ORGANIZATION
WHERE NAME IN ('V01BHS','V03NYN','V23OMA','V15KAN','V23FTM')

DECLARE @WRONG_VISTA_SITE_ID INT, @FACILITY_CODE NVARCHAR(250), @WRONG_VISTA_UID UNIQUEIDENTIFIER
DECLARE WRONG_VISTA_SITE_CURSOR CURSOR FOR
		SELECT * FROM #WRONG_VISTA_SITE
		
		OPEN WRONG_VISTA_SITE_CURSOR
		FETCH NEXT FROM WRONG_VISTA_SITE_CURSOR INTO @WRONG_VISTA_SITE_ID, @FACILITY_CODE, @WRONG_VISTA_UID

		WHILE @@FETCH_STATUS = 0
			BEGIN
				DECLARE @GOOD_VISTA_ID INT, @SECTION NVARCHAR(250)
				SET @SECTION = NULL
				SET @GOOD_VISTA_ID = CASE 
										WHEN @FACILITY_CODE = 'BOS' OR @FACILITY_CODE= 'BRK' OR @FACILITY_CODE= 'WRX' THEN 
											(SELECT GOOD_VISTA_ID FROM #GOOD_VISTA_SITE WHERE GOOD_VISTA_NAME = 'V01BHS')
										WHEN @FACILITY_CODE= 'NYN' OR @FACILITY_CODE= 'BYN' THEN 
											(SELECT GOOD_VISTA_ID FROM #GOOD_VISTA_SITE WHERE GOOD_VISTA_NAME = 'V03NYN')
										WHEN @FACILITY_CODE= 'OMA' OR @FACILITY_CODE= 'CIH' OR @FACILITY_CODE= 'IOW' THEN
											(SELECT GOOD_VISTA_ID FROM #GOOD_VISTA_SITE WHERE GOOD_VISTA_NAME = 'V23OMA')
										WHEN @FACILITY_CODE= 'FTM' OR @FACILITY_CODE= 'HOT' THEN 
											(SELECT GOOD_VISTA_ID FROM #GOOD_VISTA_SITE WHERE GOOD_VISTA_NAME = 'V23FTM')
										ELSE (SELECT GOOD_VISTA_ID FROM #GOOD_VISTA_SITE WHERE GOOD_VISTA_NAME = 'V15KAN')
									 END
				IF @GOOD_VISTA_ID <> @WRONG_VISTA_SITE_ID
					BEGIN
						
						SET @SECTION = 'VistASettings ' + CAST(@WRONG_VISTA_UID AS NVARCHAR(50)) 
						
						--DELETE VISTA TIME ZONE AND LOCAL TIME AJUST
						DELETE EVS FROM $(varBMS).dbo.CONFIG_EVS AS EVS 
						INNER JOIN $(varBMS).dbo.CONFIG AS C ON EVS.CONFIG_ID = C.ID
						WHERE C.SECTION = @SECTION
						
						DELETE C FROM $(varBMS).dbo.CONFIG AS C 
						WHERE C.SECTION = @SECTION
						
						--UPDATE FK_SCOPER_ENTITY
						UPDATE $(varBMS_EIS).dbo.EHL7_ROLE 
						SET FK_SCOPER_ENTITY = @GOOD_VISTA_ID
						WHERE FK_SCOPER_ENTITY = @WRONG_VISTA_SITE_ID

						--DELETE FK_PLAYER_ENTITY
						DELETE FROM $(varBMS_EIS).dbo.EHL7_ROLE WHERE FK_PLAYER_ENTITY = @WRONG_VISTA_SITE_ID

						--DELETE ENTITY
						DELETE FROM $(varBMS_EIS).dbo.TRAIT_VALUE WHERE FK_ENTITY = @WRONG_VISTA_SITE_ID

						DELETE FROM $(varBMS_EIS).dbo.EHL7_UID WHERE FK_ENTITY = @WRONG_VISTA_SITE_ID

						EXEC $(varBMS_EIS).dbo.DEL_ALL_ADDRESSES @WRONG_VISTA_SITE_ID, NULL

						EXEC $(varBMS_EIS).dbo.DEL_ALL_TELECOMS @WRONG_VISTA_SITE_ID, NULL

						--DELETE ORGANIZATION
						DELETE FROM  $(varBMS_EIS).dbo.EHL7_ORGANIZATION WHERE PFK_ORGANIZATION = @WRONG_VISTA_SITE_ID	
						
						DELETE FROM $(varBMS_EIS).dbo.ENTITY WHERE PK_ENTITY = @WRONG_VISTA_SITE_ID

						
					END
				
				FETCH NEXT FROM WRONG_VISTA_SITE_CURSOR 
				INTO @WRONG_VISTA_SITE_ID, @FACILITY_CODE, @WRONG_VISTA_UID
			END
		CLOSE WRONG_VISTA_SITE_CURSOR;
		DEALLOCATE WRONG_VISTA_SITE_CURSOR;	

DROP TABLE #WRONG_VISTA_SITE
DROP TABLE #GOOD_VISTA_SITE



