DECLARE @SQL NVARCHAR(MAX), @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER,  @TIME_ZONE_MINUTES_OFFSET INT, @START_DATE DATETIME, @DELTA_START_DATE DATETIME,
		@DAYLIGHT_SAVING_TIME INT, @START_DATE_1 DATETIME, @END_DATE_1 DATETIME, @START_DATE_2 DATETIME, @END_DATE_2 DATETIME, @START_DATE_3 DATETIME, @END_DATE_3 DATETIME
SET @FACILITY_CODE = '$(varFacilityCode)'
SET @TIME_ZONE_MINUTES_OFFSET = $(varTimeZoneMinutesOffSet)
SET @START_DATE = '$(varStartDate)'
SET @DAYLIGHT_SAVING_TIME = @TIME_ZONE_MINUTES_OFFSET - 60
SET @START_DATE_1 = '2011-03-13 02:00:00'
SET @END_DATE_1 = '2011-11-06 02:00:00'
SET @START_DATE_2 = '2012-03-11 02:00:00'
SET @END_DATE_2 = '2012-11-04 02:00:00'
SET @START_DATE_3 = '2013-03-10 02:00:00'
SET @END_DATE_3 = '2013-11-03 02:00:00'

SELECT @FACILITY_UID = E.IDENTIFIER
FROM $(varBMS_EIS).dbo.ENTITY AS E
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION  
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

SELECT @DELTA_START_DATE = MIN(START_DATE) FROM $(varBMS).dbo.DIVERSION WHERE FACILITY_UID = @FACILITY_UID
IF @DELTA_START_DATE IS NOT NULL
BEGIN
	DELETE FROM $(varBMS).dbo.DIVERSION WHERE FACILITY_UID = @FACILITY_UID
	DELETE FROM $(varBMS_HISTORY).dbo.DIVERSION_H WHERE FACILITY_UID = @FACILITY_UID 
	
	SET @START_DATE = DATEADD(dd, 0, DATEDIFF(dd, 0, DATEADD(MINUTE, -@TIME_ZONE_MINUTES_OFFSET, @DELTA_START_DATE)))
END

SET @SQL = COALESCE(@SQL,'') + 'DECLARE @p1 INT '
SELECT @SQL = @SQL + '
			  SET @p1=-1
			  exec $(varBMS).dbo.usp_Insert_Diversion @ID=@p1 output,
			  @FACILITY_UID=''' + CAST(@FACILITY_UID AS NVARCHAR(50)) + ''',
			  @VISTA_SITE_UID=NULL,
			  @ACTIVE=' + CASE Site_Diversion.DivStatus WHEN 'NO' THEN '0' ELSE '1' END + ',
			  @START_DATE= ' + CASE WHEN (cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivStartDT, 120), 10) + ' ' + Site_Diversion.DivStartHH +':' + Site_Diversion.DivStartMM +':00' as datetime) BETWEEN @START_DATE_1 AND @END_DATE_1) OR 
										 (cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivStartDT, 120), 10) + ' ' + Site_Diversion.DivStartHH +':' + Site_Diversion.DivStartMM +':00' as datetime) BETWEEN @START_DATE_2 AND @END_DATE_2) OR 				
										 (cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivStartDT, 120), 10) + ' ' + Site_Diversion.DivStartHH +':' + Site_Diversion.DivStartMM +':00' as datetime) BETWEEN @START_DATE_3 AND @END_DATE_3)
								    THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivStartDT, 120), 10) + ' ' + Site_Diversion.DivStartHH +':' + Site_Diversion.DivStartMM +':00' as datetime)), 120), 19) + '''' 
								    ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivStartDT, 120), 10) + ' ' + Site_Diversion.DivStartHH +':' + Site_Diversion.DivStartMM +':00' as datetime)), 120), 19) + ''''
							   END +',
			  @END_DATE= ' + CASE WHEN (cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivEndDT, 120), 10) + ' ' + Site_Diversion.DivEndHH +':' + Site_Diversion.DIVEndMM +':00' as datetime) BETWEEN @START_DATE_1 AND @END_DATE_1) OR 
										 (cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivEndDT, 120), 10) + ' ' + Site_Diversion.DivEndHH +':' + Site_Diversion.DIVEndMM +':00' as datetime) BETWEEN @START_DATE_2 AND @END_DATE_2) OR 				
										 (cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivEndDT, 120), 10) + ' ' + Site_Diversion.DivEndHH +':' + Site_Diversion.DIVEndMM +':00' as datetime) BETWEEN @START_DATE_3 AND @END_DATE_3)
								    THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivEndDT, 120), 10) + ' ' + Site_Diversion.DivEndHH +':' + Site_Diversion.DIVEndMM +':00' as datetime)), 120), 19) + '''' 
								    ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, cast(LEFT(CONVERT(VARCHAR, Site_Diversion.DivEndDT, 120), 10) + ' ' + Site_Diversion.DivEndHH +':' + Site_Diversion.DIVEndMM +':00' as datetime)), 120), 19) + ''''
							   END +',
			  @LOCATION_CODE=''' + CP.conceptCode + ''',
			  @LOCATION_CODE_SYSTEM=''2.12.24.46'',
			  @LOCATION_CODE_SYSTEM_NAME=''Location'',
			  @LOCATION_DISPLAY_NAME=''' + CP.propertyValue + ''',
			  @DOMAIN_ID=''InfoWorld'',
			  @COMMENTS=' + CASE WHEN Site_Diversion.DivComments IS NULL THEN 'NULL' ELSE '''' + REPLACE(Site_Diversion.DivComments,'''','''''' ) + '''' END + ',	
			  @ENTERED_BY=' + CASE WHEN Site_Diversion.DivEntryBy IS NULL THEN 'NULL' ELSE '''' + Site_Diversion.DivEntryBy + '''' END + ',
			  @ENTERED_DATE= ' + CASE WHEN Site_Diversion.DivEntryDT IS NULL THEN 'NULL'
									  WHEN (Site_Diversion.DivEntryDT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (Site_Diversion.DivEntryDT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (Site_Diversion.DivEntryDT BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, Site_Diversion.DivEntryDT), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, Site_Diversion.DivEntryDT), 120), 19) + '''' END + ',
			  @LAST_EDIT_BY=' + CASE WHEN Site_Diversion.DivLastEditBy IS NULL THEN 'NULL' ELSE '''' + Site_Diversion.DivLastEditBy + '''' END + ''
FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Site_Diversion] AS Site_Diversion 
LEFT JOIN $(varBMS_EVS).dbo.conceptProperty AS CP ON CP.propertyValue LIKE '%'+ Site_Diversion.DivLocation + '%'
					AND CP.property = 'textualPresentation' AND CP.codingSchemeName = 'Location'
WHERE Site_Diversion.DivStartDT >= @START_DATE
EXEC sp_executesql @SQL






