﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.EIS;
using BMS.Facade.Data;
using FC = BMS.Facade.Data;
using BMS.Facade;
using VI = BMS.VistaIntegration.FacadeContracts;
using BMS.Utils;
using DC = BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using System.ServiceModel;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Mdws;
using BMS.VistaIntegration.Cache;
using BMS.VistaIntegration.Data;
using VIC = BMS.VistaIntegration.Data;
using BMS.ServicesWrapper.EVS;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.WF;
using BMS.VistaWorker2.Writer;
using BMS.VistaWorker2.Writer.Implementation;
using System.IO;
using System.Reflection;
using System.Configuration;
using System.Data.SqlClient;
using System.Data;

namespace Import_VistaJob
{
    public class HospitalLocationProcessor
    {
        static VI.VistASite vistaSettings = null;
        //static SqlConnection connection;

        public static void ImportHospitalLocationData(VI.VistASite vistaSite, string methodType)
        {
            vistaSettings = vistaSite;
            DataRetrievalMethod? retrievalMethod = null;
            bool _isSuccess = true;
            if (methodType.Equals(DataRetrievalMethod.MDWS.ToString(), StringComparison.InvariantCultureIgnoreCase))
                retrievalMethod = DataRetrievalMethod.MDWS;
            else if (methodType.Equals(DataRetrievalMethod.ODBC.ToString(), StringComparison.InvariantCultureIgnoreCase))
                retrievalMethod = DataRetrievalMethod.ODBC;
            StringBuilder exeSql = null;
            try
            {
                Tracer.TraceMessage("Begin Import HospitalLocationData");
                IVistAQuery query = Utils.GetVistASession(vistaSettings, retrievalMethod.Value).MakeQuery();
                IList<VIC.HospitalLocation> entries = null;
                string sql = string.Empty;
                exeSql = new StringBuilder();
                string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
                string filePath = theDirectory + "/SqlScripts/ManageHospitalLocation.sql";
                using (FileStream strm = File.OpenRead(filePath))
                {
                    StreamReader reader = new StreamReader(strm);
                    sql = reader.ReadToEnd();
                }
                int i = 1;
                do
                {
                    Tracer.TraceMessage("Begin getPage from VistA - page: " + i++);
                    entries = query.GetHospitalLocations();
                    Tracer.TraceMessage("End getPage from VistA " + (entries != null ? entries.Count.ToString() : "0") + " entries");
                    if (entries != null)
                    {
                        exeSql.Clear();
                        exeSql.AppendLine("declare @TRANSACTION nvarchar(250), @UID nvarchar(50), @p1 int, @p2 int, @PARAM_LOCATION_TELECOM nvarchar(250)");
                        foreach (VIC.HospitalLocation location in entries)
                            exeSql.Append(CreateSqlScript(Utils.TranslateHospitalLocation(location, vistaSettings.Id), sql));
                        InsertOrUpdateLocations(exeSql.ToString());
                        Tracer.TraceMessage("End processPage in BMS");
                    }
                }
                while (entries != null);
            }
            catch (FaultException<BMS.FaultContracts.VistAException> e)
            {
                _isSuccess = false;
                Tracer.TraceException(e);
                Console.WriteLine(vistaSite.Name + ": " + "ERROR: " + e.Detail.ErrorMessage);
            }
            catch (SqlException e)
            {
                _isSuccess = false;
                Tracer.TraceException(e);
                Console.WriteLine(vistaSite.Name + ": " + "SQL ERROR: " + e.Message);
            }
            finally
            {
                Utils.InsertVistaOperation(vistaSettings.Id, "1", DateTime.UtcNow);
                GlobalConnections.CloseConnections();
            }
            if (_isSuccess)
                Console.WriteLine(vistaSite.Name + ": " + "Process hospital locations has finished.");
            
        }

        private static void InsertOrUpdateLocations(string sql)
        {
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = 36000;
                try
                {
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException e)
                {
                    throw (e);
                }
                finally
                {
                    cmd.Dispose();
                }
            }
        }

        private static string CreateSqlScript(FC.HospitalLocation location, string sql)
        {
            if (location == null || location.Ien == null)
                return null;
            sql = sql.Replace("@IEN", "'" + location.Ien + "'");
            sql = sql.Replace("@EDIT_DATE_TIME", "'" + DateTime.UtcNow.ToString() + "'");
            sql = sql.Replace("@VISTA_CODE", "'" + vistaSettings.Name + "'");
            sql = sql.Replace("@LOCATION_NAME", "'" + location.Name.Replace("'", "''") + "'");
            sql = sql.Replace("@VISTA_UID", "'" + vistaSettings.Id + "'");
            sql = sql.Replace("@LOCATION_TELECOM", string.IsNullOrEmpty(location.Telephone) ? "NULL" : "'" + location.Telephone.Replace("'", "''") + "'");
            sql = sql.Replace("@WARD_UID", "'" + location.WardLocationId + "'");
            sql = sql.Replace("@HOSPITAL_ABBREVIATION", string.IsNullOrEmpty(location.Abbrevation) ? "NULL" : "'" + location.Abbrevation.Replace("'", "''") + "'");
            return sql;
        }

        //private static void CheckConnection()
        //{
        //    if (connection != null && (connection.State == ConnectionState.Broken || connection.State == ConnectionState.Closed))
        //    {
        //        connection.Dispose();
        //        connection = null;
        //    }
        //    if (connection == null)
        //    {
        //        connection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString);
        //        connection.Open();
        //    }
        //}
    }
}
