
CREATE TABLE #BED_UNAVAILABLE(RECNUM NUMERIC(18,0), BED VARCHAR(50), MUST_CLOSE_FLOW VARCHAR(50))

INSERT INTO #BED_UNAVAILABLE(RECNUM, BED, MUST_CLOSE_FLOW)
SELECT MIN(RECNUM) AS RECNUM, BED AS BED, 'true' AS MUST_CLOSE_FLOW 
FROM [BED_CONTROL_COMMENT_LOG]
WHERE InfoOrOS = 'CLEAR-ALL' AND (DateTimeOS >= '@START_DATE' OR DateTimeEdit >= '@START_DATE' OR DateTimeBIS >= '@START_DATE')
GROUP BY BED

INSERT INTO #BED_UNAVAILABLE(RECNUM, BED, MUST_CLOSE_FLOW)
Select A.RECNUM, A.BED, A.MUST_CLOSE_FLOW
FROM (
SELECT MAX(RECNUM) AS RECNUM, BED AS BED, 'false' AS MUST_CLOSE_FLOW 
FROM [BED_CONTROL_COMMENT_LOG]
WHERE (DateTimeOS >= '@START_DATE' OR DateTimeEdit >= '@START_DATE' OR DateTimeBIS >= '@START_DATE')
GROUP BY BED) A
INNER JOIN Bed_Control_Comment_Log AS BU_LOG ON BU_LOG.RECNUM = A.RECNUM
WHERE A.RECNUM NOT IN (SELECT RECNUM FROM #BED_UNAVAILABLE) AND BU_LOG.InfoOrOS <> 'CLEAR-ALL'


SELECT BU.BED AS BED_NAME, 
	   BU.REASONOS AS REASON_DISPLAY_NAME, 
	   BU.InfoOrOS AS TYPE_DISPLAY_NAME, 
	   BU.UserEdit AS EDIT_BY, 
	   BU.DateTimeEdit AS EDIT_DATE,
	   CASE WHEN BU.InfoOrOS = 'CLEAR-ALL' THEN BU.UserBIS ELSE NULL END AS COMPLETED_BY,
	   CASE WHEN BU.InfoOrOS = 'CLEAR-ALL' THEN BU.DateTimeBIS ELSE NULL END AS COMPLETED_DATE,
	   CLEAR_BU.MUST_CLOSE_FLOW AS MUST_CLOSE_FLOW
FROM [BED_CONTROL_COMMENT_LOG] AS BU
INNER JOIN #BED_UNAVAILABLE AS CLEAR_BU ON CLEAR_BU.RECNUM = BU.RECNUM

DROP TABLE #BED_UNAVAILABLE