﻿using System;
using System.Data.SqlClient;
using System.IO;
using System.Data;
using System.Configuration;
using System.Reflection;
using BMS.Utils;
using InfoWorld.HL7.ITS;

namespace Import_Flows
{
    public class DataQuery
    {
        public static DataSet GetImportData(string sqlFile, string connString, string facilityCode, DateTime? startDate, string facilityUID, string wardUidList)
        {
            string sql = "";
            DataSet result = new DataSet();
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + sqlFile;
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            if (!string.IsNullOrEmpty(facilityCode))
                sql = sql.Replace("@FACILITY_CODE", facilityCode);
            if (!string.IsNullOrEmpty(facilityUID))
                sql = sql.Replace("@FACILITY_UID", facilityUID);
            if (startDate.HasValue)
                sql = sql.Replace("@START_DATE", startDate.Value.ToString());
            if (!string.IsNullOrEmpty(wardUidList))
                sql = sql.Replace("@WARD_UID_LIST", wardUidList);
            SqlConnection connection = new SqlConnection(connString);

            using (SqlCommand cmd = connection.CreateCommand())
            {
                cmd.Connection = connection;
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    connection.Open();
                    adapter.SelectCommand = cmd;
                    adapter.Fill(result);
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    connection.Close();
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return result;
        }

        public static DataSet EventType(string vistaUid, string ien, string wardUid)
        {
            string sql = "";
            DataSet result = new DataSet();
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetAct.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@BED_CLEAN_VISTA_STE_UID", vistaUid);
            sql = sql.Replace("@BED_CLEAN_WARD_UID", wardUid);
            sql = sql.Replace("@BED_CLEAN_IEN", ien);
            String strConnString = ConfigurationManager.ConnectionStrings["BMS_DB_ConnString"].ConnectionString;
            SqlConnection connection = new SqlConnection(strConnString);

            using (SqlCommand cmd = connection.CreateCommand())
            {
                cmd.Connection = connection;
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    connection.Open();
                    adapter.SelectCommand = cmd;
                    adapter.Fill(result);
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    connection.Close();
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return result;
        }

        public static void InsertVistaOperation(string vistaId, string operationId, DateTime endDate)
        {
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/VistaOperation.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@VISTA_ID", vistaId);
            sql = sql.Replace("@OPERATION_ID", operationId);
            sql = sql.Replace("@END_DATE", endDate.ToString());

            String strConnString = ConfigurationManager.ConnectionStrings["BMS_DB_ConnString"].ConnectionString;
            SqlConnection connection = new SqlConnection(strConnString);
            using (SqlCommand cmd = connection.CreateCommand())
            {
                cmd.Connection = connection;
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                try
                {
                    connection.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    connection.Close();
                    cmd.Dispose();
                }
            }
        }

        public static void UpdateBedClean(BMS.Facade.Data.BedClean item)
        {
            SqlConnection connection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMS_DB_ConnString"].ConnectionString);
            SqlCommand cmd = new SqlCommand("usp_Update_Bed_Clean", connection);
            cmd.CommandType = CommandType.StoredProcedure;
            try
            {
                cmd.Parameters.Add("@ID", SqlDbType.Int, 50).Value = Int32.Parse(item.Id.extension);
                cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = item.Id.root;
                cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(item.Bed.Id.extension);
                cmd.Parameters.Add("@TYPE_OF_CLEAN_CODE", SqlDbType.VarChar).Value = item.TypeOfClean.code;
                cmd.Parameters.Add("@TYPE_OF_CLEAN_CODE_SYSTEM", SqlDbType.VarChar).Value = item.TypeOfClean.codeSystem;
                cmd.Parameters.Add("@TYPE_OF_CLEAN_CODE_SYSTEM_NAME", SqlDbType.VarChar).Value = item.TypeOfClean.codeSystemName;
                cmd.Parameters.Add("@TYPE_OF_CLEAN_DISPLAY_NAME", SqlDbType.VarChar).Value = item.TypeOfClean.displayName;
                cmd.Parameters.Add("@MANUAL_REQUEST_CODE", SqlDbType.VarChar).Value = item.ManualRequest.code;
                cmd.Parameters.Add("@MANUAL_REQUEST_CODE_SYSTEM", SqlDbType.VarChar).Value = item.ManualRequest.codeSystem;
                cmd.Parameters.Add("@MANUAL_REQUEST_CODE_SYSTEM_NAME", SqlDbType.VarChar).Value = item.ManualRequest.codeSystemName;
                cmd.Parameters.Add("@MANUAL_REQUEST_DISPLAY_NAME", SqlDbType.VarChar).Value = item.ManualRequest.displayName;
                if (item.AcceptedDate.HasValue)
                    cmd.Parameters.Add("@ACCEPTED_DATE", SqlDbType.DateTime).Value = item.AcceptedDate.Value;
                else
                    cmd.Parameters.Add("@ACCEPTED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (string.IsNullOrEmpty(item.AcceptedBy))
                    cmd.Parameters.Add("@ACCEPTED_BY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@ACCEPTED_BY", SqlDbType.VarChar).Value = item.AcceptedBy;
                if (item.CompletedDate.HasValue)
                    cmd.Parameters.Add("@COMPLETED_DATE", SqlDbType.DateTime).Value = item.CompletedDate.Value;
                else
                    cmd.Parameters.Add("@COMPLETED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (string.IsNullOrEmpty(item.CompletedBy))
                    cmd.Parameters.Add("@COMPLETED_BY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@COMPLETED_BY", SqlDbType.VarChar).Value = item.CompletedBy;
                if (string.IsNullOrEmpty(item.LastEditedBy))
                    cmd.Parameters.Add("@LAST_EDITED_BY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@LAST_EDITED_BY", SqlDbType.VarChar).Value = item.LastEditedBy;
                if (item.LastEditDate.HasValue)
                    cmd.Parameters.Add("@LAST_EDIT_DATE", SqlDbType.DateTime).Value = item.LastEditDate.Value;
                else
                    cmd.Parameters.Add("@LAST_EDIT_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (item.RequestedDate.HasValue)
                    cmd.Parameters.Add("@REQUESTED_DATE", SqlDbType.DateTime).Value = item.RequestedDate.Value;
                else
                    cmd.Parameters.Add("@REQUESTED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(item.VistaSite.Id.extension);
                cmd.Parameters.Add("@DIVISION_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(item.Ward.Id.extension);
                if (string.IsNullOrEmpty(item.EMSNotify))
                    cmd.Parameters.Add("@EMS_NOTIFY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@EMS_NOTIFY", SqlDbType.VarChar).Value = item.EMSNotify;
                cmd.Parameters.Add("@SPECIAL_INSTRUCTIONS", SqlDbType.VarChar).Value = DBNull.Value;
                cmd.Parameters.Add("@COMMENT", SqlDbType.VarChar).Value = DBNull.Value;
                cmd.Parameters.Add("@COMMENTED_BY", SqlDbType.VarChar).Value = DBNull.Value;
                cmd.Parameters.Add("@COMMENTED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (item.VacatedDate.HasValue)
                    cmd.Parameters.Add("@VACATED_DATE", SqlDbType.DateTime).Value = item.VacatedDate.Value;
                else
                    cmd.Parameters.Add("@VACATED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (string.IsNullOrEmpty(item.EventType))
                    cmd.Parameters.Add("@EVENT_TYPE", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@EVENT_TYPE", SqlDbType.VarChar).Value = item.EventType;
                if (string.IsNullOrEmpty(item.EventIen))
                    cmd.Parameters.Add("@EVENT_IEN", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@EVENT_IEN", SqlDbType.VarChar).Value = item.EventIen;

                connection.Open();
                cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("Exception on insert bed clean: " + item.Bed.Id.extension + " ward: " + item.Ward.Id.extension);
                Tracer.TraceMessage(ex.Message);
                throw ex;
            }
            finally
            {
                connection.Close();
                cmd.Dispose();
            }
        }

        public static void InsertBedClean(BMS.Facade.Data.BedClean item)
        {
            SqlConnection connection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMS_DB_ConnString"].ConnectionString);
            SqlCommand cmd = new SqlCommand("usp_Insert_Bed_Clean", connection);
            cmd.CommandType = CommandType.StoredProcedure;
            try
            {
                SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParam.Direction = ParameterDirection.Output;
                cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = item.Id.root;
                cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(item.Bed.Id.extension);
                cmd.Parameters.Add("@TYPE_OF_CLEAN_CODE", SqlDbType.VarChar).Value = item.TypeOfClean.code;
                cmd.Parameters.Add("@TYPE_OF_CLEAN_CODE_SYSTEM", SqlDbType.VarChar).Value = item.TypeOfClean.codeSystem;
                cmd.Parameters.Add("@TYPE_OF_CLEAN_CODE_SYSTEM_NAME", SqlDbType.VarChar).Value = item.TypeOfClean.codeSystemName;
                cmd.Parameters.Add("@TYPE_OF_CLEAN_DISPLAY_NAME", SqlDbType.VarChar).Value = item.TypeOfClean.displayName;
                cmd.Parameters.Add("@MANUAL_REQUEST_CODE", SqlDbType.VarChar).Value = item.ManualRequest.code;
                cmd.Parameters.Add("@MANUAL_REQUEST_CODE_SYSTEM", SqlDbType.VarChar).Value = item.ManualRequest.codeSystem;
                cmd.Parameters.Add("@MANUAL_REQUEST_CODE_SYSTEM_NAME", SqlDbType.VarChar).Value = item.ManualRequest.codeSystemName;
                cmd.Parameters.Add("@MANUAL_REQUEST_DISPLAY_NAME", SqlDbType.VarChar).Value = item.ManualRequest.displayName;
                if (item.AcceptedDate.HasValue)
                    cmd.Parameters.Add("@ACCEPTED_DATE", SqlDbType.DateTime).Value = item.AcceptedDate.Value;
                else
                    cmd.Parameters.Add("@ACCEPTED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (string.IsNullOrEmpty(item.AcceptedBy))
                    cmd.Parameters.Add("@ACCEPTED_BY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@ACCEPTED_BY", SqlDbType.VarChar).Value = item.AcceptedBy;
                if (item.CompletedDate.HasValue)
                    cmd.Parameters.Add("@COMPLETED_DATE", SqlDbType.DateTime).Value = item.CompletedDate.Value;
                else
                    cmd.Parameters.Add("@COMPLETED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (string.IsNullOrEmpty(item.CompletedBy))
                    cmd.Parameters.Add("@COMPLETED_BY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@COMPLETED_BY", SqlDbType.VarChar).Value = item.CompletedBy;
                if (string.IsNullOrEmpty(item.LastEditedBy))
                    cmd.Parameters.Add("@LAST_EDITED_BY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@LAST_EDITED_BY", SqlDbType.VarChar).Value = item.LastEditedBy;
                if (item.LastEditDate.HasValue)
                    cmd.Parameters.Add("@LAST_EDIT_DATE", SqlDbType.DateTime).Value = item.LastEditDate.Value;
                else
                    cmd.Parameters.Add("@LAST_EDIT_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (item.RequestedDate.HasValue)
                    cmd.Parameters.Add("@REQUESTED_DATE", SqlDbType.DateTime).Value = item.RequestedDate.Value;
                else
                    cmd.Parameters.Add("@REQUESTED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(item.VistaSite.Id.extension);
                cmd.Parameters.Add("@DIVISION_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(item.Ward.Id.extension);
                if (string.IsNullOrEmpty(item.EMSNotify))
                    cmd.Parameters.Add("@EMS_NOTIFY", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@EMS_NOTIFY", SqlDbType.VarChar).Value = item.EMSNotify;
                cmd.Parameters.Add("@SPECIAL_INSTRUCTIONS", SqlDbType.VarChar).Value = DBNull.Value;
                if (item.VacatedDate.HasValue)
                    cmd.Parameters.Add("@VACATED_DATE", SqlDbType.DateTime).Value = item.VacatedDate.Value;
                else
                    cmd.Parameters.Add("@VACATED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (string.IsNullOrEmpty(item.EventType))
                    cmd.Parameters.Add("@EVENT_TYPE", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@EVENT_TYPE", SqlDbType.VarChar).Value = item.EventType;
                if (string.IsNullOrEmpty(item.EventIen))
                    cmd.Parameters.Add("@EVENT_IEN", SqlDbType.VarChar).Value = DBNull.Value;
                else
                    cmd.Parameters.Add("@EVENT_IEN", SqlDbType.VarChar).Value = item.EventIen;
                connection.Open();
                cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("Exception on insert bed clean: " + item.Bed.Id.extension + " ward: " + item.Ward.Id.extension);
                Tracer.TraceMessage(ex.Message);
                throw ex;
            }
            finally
            {
                connection.Close();
                cmd.Dispose();
            }
        }

        public static void UpdateBedCleanByBMSSystem(string wardUidList)
        {
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/UpdateBedCleanByBMSSystem.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@WARD_UID_LISTS", wardUidList);

            String strConnString = ConfigurationManager.ConnectionStrings["BMS_DB_ConnString"].ConnectionString;
            SqlConnection connection = new SqlConnection(strConnString);
            using (SqlCommand cmd = connection.CreateCommand())
            {
                cmd.Connection = connection;
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                try
                {
                    connection.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    connection.Close();
                    cmd.Dispose();
                }
            }
        }

        public static void UpdateDispositionForTransferEvents(string eventIdList, CD disposition)
        {
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/VisnWaitingList_UpdateDisposition.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@ACT_ID_LIST", eventIdList);
            sql = sql.Replace("@DISPOSITION_CODE_SYSTEM_NAME", "'" + disposition.codeSystemName + "'");
            sql = sql.Replace("@DISPOSITION_CODE_SYSTEM", "'" + disposition.codeSystem + "'");
            sql = sql.Replace("@DISPOSITION_CODE", "'" + disposition.code + "'");
            sql = sql.Replace("@DISPOSITION_DISPLAY_NAME", "'" + disposition.displayName + "'");

            String strConnString = ConfigurationManager.ConnectionStrings["BMS_DB_ConnString"].ConnectionString;
            SqlConnection connection = new SqlConnection(strConnString);
            using (SqlCommand cmd = connection.CreateCommand())
            {
                cmd.Connection = connection;
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                try
                {
                    connection.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    connection.Close();
                    cmd.Dispose();
                }
            }
        }
    }
}

