﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Data.SqlClient;
using System.Data;
using System.Configuration;

namespace ImportUsers
{
    public class SqlQueries
    {
        public static List<User> GetUsers()
        {
            try
            {
                List<User> result = new List<User>();

                string sql = "";
                string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
                string filePath = theDirectory + "/SqlScripts/GetUsersToImport.sql";
                using (FileStream strm = File.OpenRead(filePath))
                {
                    StreamReader reader = new StreamReader(strm);
                    sql = reader.ReadToEnd();
                }
                DataSet ds = new DataSet();
                using (SqlCommand cmd = GlobalConnections.ImportConnection.CreateCommand())
                {
                    cmd.CommandText = sql;
                    cmd.CommandType = CommandType.Text;
                    cmd.CommandTimeout = 36000;
                    SqlDataAdapter adapter = new SqlDataAdapter();
                    try
                    {
                        adapter.SelectCommand = cmd;
                        adapter.Fill(ds);
                        if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                        {
                            foreach (DataRow dr in ds.Tables[0].Rows)
                                result.Add(
                                    new User()
                                    {
                                        UserName = dr["USER_NAME"].ToString(),
                                        SupportUser = dr["SUPPORT_USER"].ToString().Equals("1"),
                                        NationalUser = dr["NATIONAL_USER"].ToString().Equals("1"),
                                        RegionalUser = dr["REGIONAL_USER"].ToString().Equals("1"),
                                        VisnUser = dr["VISN_USER"].ToString().Equals("1"),
                                        AdminUser = dr["ADMIN_USER"].ToString().Equals("1"),
                                        SiteUser = dr["SITE_USER"].ToString().Equals("1"),
                                        EmsUser = dr["EMS_USER"].ToString().Equals("1"),
                                        ReadAccess = dr["READ_ACCESS"].ToString().Equals("1"),
                                        WriteAccess = dr["WRITE_ACCESS"].ToString().Equals("1"),
                                        DefaultRegion = int.Parse(dr["DEFAULT_REGION"].ToString()),
                                        DefaultVisn = int.Parse(dr["DEFAULT_VISN"].ToString()),
                                        DefaultSite = dr["DEFAULT_SITE"].ToString()
                                    });
                        }
                    }
                    catch (SqlException ex)
                    {
                        throw ex;
                    }
                    finally
                    {
                        cmd.Dispose();
                        adapter.Dispose();
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                Tracer.TraceException(ex);
                return null;
            }
        }

        public static List<Facility> GetFacilities()
        {
            try
            {
                List<Facility> result = new List<Facility>();

                string sql = "";
                string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
                string filePath = theDirectory + "/SqlScripts/GetFacilities.sql";
                using (FileStream strm = File.OpenRead(filePath))
                {
                    StreamReader reader = new StreamReader(strm);
                    sql = reader.ReadToEnd();
                }
                DataSet ds = new DataSet();
                using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
                {
                    cmd.CommandText = sql;
                    cmd.CommandType = CommandType.Text;
                    cmd.CommandTimeout = 36000;
                    SqlDataAdapter adapter = new SqlDataAdapter();
                    try
                    {
                        adapter.SelectCommand = cmd;
                        adapter.Fill(ds);
                        if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                        {
                            foreach (DataRow dr in ds.Tables[0].Rows)
                                result.Add(
                                    new Facility()
                                    {
                                        Uid = dr["IDENTIFIER"].ToString(),
                                        Code = dr["CODE"].ToString(),
                                        Name = dr["NAME"].ToString(),
                                        RegionNumber = int.Parse(dr["REGION"].ToString()),
                                        VisnNumber = int.Parse(dr["VISN"].ToString())
                                    });
                        }
                    }
                    catch (SqlException ex)
                    {
                        throw ex;
                    }
                    finally
                    {
                        cmd.Dispose();
                        adapter.Dispose();
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                Tracer.TraceException(ex);
                return null;
            }
        }

        public static Dictionary<string, string> GetActions()
        {
            try
            {
                Dictionary<string, string> result = new Dictionary<string, string>();

                string sql = "";
                string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
                string filePath = theDirectory + "/SqlScripts/GetActions.sql";
                using (FileStream strm = File.OpenRead(filePath))
                {
                    StreamReader reader = new StreamReader(strm);
                    sql = reader.ReadToEnd();
                }
                DataSet ds = new DataSet();
                using (SqlCommand cmd = GlobalConnections.AuthzConnection.CreateCommand())
                {
                    cmd.CommandText = sql;
                    cmd.CommandType = CommandType.Text;
                    cmd.CommandTimeout = 36000;
                    SqlDataAdapter adapter = new SqlDataAdapter();
                    try
                    {
                        adapter.SelectCommand = cmd;
                        adapter.Fill(ds);
                        if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                        {
                            foreach (DataRow dr in ds.Tables[0].Rows)
                                result.Add(dr["NAME"].ToString(), dr["ID"].ToString());
                        }
                    }
                    catch (SqlException ex)
                    {
                        throw ex;
                    }
                    finally
                    {
                        cmd.Dispose();
                        adapter.Dispose();
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                Tracer.TraceException(ex);
                return null;
            }
        }

        public static Dictionary<string, string> GetRoles()
        {
            try
            {
                Dictionary<string, string> result = new Dictionary<string, string>(StringComparer.InvariantCultureIgnoreCase);

                string sql = "";
                string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
                string filePath = theDirectory + "/SqlScripts/GetRoles.sql";
                using (FileStream strm = File.OpenRead(filePath))
                {
                    StreamReader reader = new StreamReader(strm);
                    sql = reader.ReadToEnd();
                }
                DataSet ds = new DataSet();
                using (SqlCommand cmd = GlobalConnections.AuthzConnection.CreateCommand())
                {
                    cmd.CommandText = sql;
                    cmd.CommandType = CommandType.Text;
                    cmd.CommandTimeout = 36000;
                    SqlDataAdapter adapter = new SqlDataAdapter();
                    try
                    {
                        adapter.SelectCommand = cmd;
                        adapter.Fill(ds);
                        if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                        {
                            foreach (DataRow dr in ds.Tables[0].Rows)
                                result.Add(dr["NAME"].ToString(), dr["ID"].ToString());
                        }
                    }
                    catch (SqlException ex)
                    {
                        throw ex;
                    }
                    finally
                    {
                        cmd.Dispose();
                        adapter.Dispose();
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                Tracer.TraceException(ex);
                return null;
            }
        }

        public static void InsertAuthzUser(string sql)
        {
            using (SqlCommand cmd = GlobalConnections.AuthzConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = 36000;
                try
                {
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException e)
                {
                    throw (e);
                }
                finally
                {
                    cmd.Dispose();
                }
            }        
        }

        public static void InsertConfigUser(string sql)
        {
            using (SqlCommand cmd = GlobalConnections.ConfigConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = 36000;
                try
                {
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException e)
                {
                    throw (e);
                }
                finally
                {
                    cmd.Dispose();
                }
            }            
        }
    }
}
