DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER, @EIS_FACILITY_ID INT
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT	@FACILITY_UID = E.IDENTIFIER, @EIS_FACILITY_ID = E.PK_ENTITY
		FROM BMS_EIS.dbo.ENTITY AS E
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE ='FAC'

		CREATE TABLE #BEDS(BED_UID UNIQUEIDENTIFIER)
		CREATE TABLE #PATIENT(PATIENT_UID UNIQUEIDENTIFIER)

		INSERT INTO #BEDS(BED_UID)
		SELECT DISTINCT E.IDENTIFIER
		FROM BMS_EIS.[dbo].[ENTITY] AS E 
		INNER JOIN BMS_EIS.[dbo].[EHL7_PLACE] AS BED ON BED.PFK_PLACE = E.PK_ENTITY
		INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = E.PK_ENTITY AND R_BED.[CLASS_CODE] = 'MNT'
		WHERE BED.CODE_DISPLAY_NAME ='BED' AND R_BED.FK_SCOPER_ENTITY IN (SELECT O.[PFK_ORGANIZATION]
		FROM BMS_EIS.[dbo].[EHL7_ORGANIZATION] AS O
		INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
		WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @EIS_FACILITY_ID)

		INSERT INTO #PATIENT(PATIENT_UID)
		SELECT DISTINCT  AE.PATIENT_UID
		FROM BMS.[dbo].[ADMISSION_EVN] AS AE 
		INNER JOIN #BEDS AS BED ON BED.BED_UID = AE.BED_UID
		WHERE AE.HAS_DISCHARGE = 0

		CREATE TABLE #ICON_ASSOCIATION(ID INT)
		INSERT INTO #ICON_ASSOCIATION(ID)
		SELECT IC.ID FROM BMS.dbo.ICON_ASSOCIATION AS IC
		INNER JOIN #PATIENT AS PATIENT ON PATIENT.PATIENT_UID = IC.PATIENT_UID
		UNION
		SELECT IC.ID FROM BMS.dbo.ICON_ASSOCIATION AS IC
		INNER JOIN #BEDS AS BED ON BED.BED_UID = IC.BED_UID

		--DELETE ICON ASSOCIATION
		DELETE IC FROM BMS.dbo.ICON_ASSOCIATION AS IC
		INNER JOIN #ICON_ASSOCIATION AS DEL ON DEL.ID = IC.ID
		
		--DELETE FROM HISTORY
		DELETE IC FROM BMS_HISTORY.dbo.ICON_ASSOCIATION_H AS IC
		INNER JOIN #ICON_ASSOCIATION AS DEL ON DEL.ID = IC.ID

		DROP TABLE #ICON_ASSOCIATION
		DROP TABLE #BEDS
		DROP TABLE #PATIENT
	SELECT 'Flags - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
	