DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT @FACILITY_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

		DELETE FROM BMS.dbo.DIVERSION WHERE FACILITY_UID = @FACILITY_UID
		DELETE FROM BMS_HISTORY.dbo.DIVERSION_H WHERE FACILITY_UID = @FACILITY_UID
	SELECT 'Facility Diversion - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;






