DECLARE @FACILITY_CODE NVARCHAR(10), @EIS_FACILITY_ID INT
BEGIN TRY
	BEGIN TRANSACTION;
		CREATE TABLE #WARDGROUP (WARDGROUP_UID UNIQUEIDENTIFIER)
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT	@EIS_FACILITY_ID = O.PFK_ORGANIZATION
		FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

		INSERT INTO #WARDGROUP(WARDGROUP_UID)
		SELECT DISTINCT E.IDENTIFIER
		FROM BMS_EIS.[dbo].[EHL7_ORGANIZATION] AS O
			INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
			INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
		WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @EIS_FACILITY_ID

		CREATE TABLE #UNAV_HISTORY(ID INT)
		INSERT INTO #UNAV_HISTORY(ID)
		SELECT UNAV_HISTORY.ID FROM BMS.dbo.BED_REASON_COMMENT_HISTORY AS UNAV_HISTORY
		INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_UID = UNAV_HISTORY.DIVISION_UID

		--DELETE FROM BMS DATABASE
		DELETE UNAV_HISTORY FROM BMS.dbo.BED_REASON_COMMENT_HISTORY AS UNAV_HISTORY
		INNER JOIN #UNAV_HISTORY AS DEL ON DEL.ID = UNAV_HISTORY.ID

		--DELETE FROM BMS_HISTORY DATABASE
		DELETE UNAV_HISTORY FROM BMS_HISTORY.dbo.BED_REASON_COMMENT_HISTORY_H AS UNAV_HISTORY
		INNER JOIN #UNAV_HISTORY AS DEL ON DEL.ID = UNAV_HISTORY.BED_REASON_COMMENT_HISTORY_ID

		DROP TABLE #WARDGROUP
		DROP TABLE #UNAV_HISTORY
	SELECT 'Bed Unavailable History - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
