DECLARE @SQL NVARCHAR(MAX), @FACILITY_CODE NVARCHAR(10), @EIS_FACILITY_ID INT, @START_DATE DATETIME
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT @EIS_FACILITY_ID= O.PFK_ORGANIZATION
		FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

		CREATE TABLE #WARDGROUP (ID UNIQUEIDENTIFIER, PK INT)
		CREATE TABLE #BEDS (ROLE_PK INT, BED_UID UNIQUEIDENTIFIER, WARD_GROUP_UID UNIQUEIDENTIFIER,)

		INSERT INTO #WARDGROUP(ID, PK)
		SELECT DISTINCT E.IDENTIFIER, O.PFK_ORGANIZATION
		FROM BMS_EIS.[dbo].[EHL7_ORGANIZATION] AS O
		INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
		INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
		WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @EIS_FACILITY_ID

		INSERT INTO #BEDS(ROLE_PK, BED_UID, WARD_GROUP_UID)
		SELECT DISTINCT R_BED.PK_ROLE, E.IDENTIFIER, WARD_GROUP.ID
		FROM BMS_EIS.[dbo].[EHL7_PLACE] AS BED
		INNER JOIN BMS_EIS.[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
		INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
		INNER JOIN #WARDGROUP AS WARD_GROUP ON WARD_GROUP.PK = R_BED.FK_SCOPER_ENTITY
		WHERE BED.CODE_DISPLAY_NAME ='BED' 

		CREATE TABLE #COMMENT(ROW_NO INT, ID INT, DELETE_COMMENT NVARCHAR(MAX))

		;WITH C AS
		(
			Select 	ROW_NUMBER() Over (Order By BED.ROLE_PK) AS ROW_NO,
			BED.ROLE_PK AS ID,
			'SET @P1 =-1
			EXEC BMS_EIS.[dbo].UPD_ROLE @PK_ROLE=@P1 output,
			@PLAYER_ENTITY_IDENTIFIER= ''' + CONVERT(NVARCHAR(50), BED.BED_UID)+ ''',
			@PLAYER_DOMAIN_IDENTIFIER=N''InfoWorld'',
			@PLAYER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',
			@SCOPER_ENTITY_IDENTIFIER= ''' + CONVERT(NVARCHAR(50), BED.WARD_GROUP_UID)+ ''',
			@SCOPER_DOMAIN_IDENTIFIER=N''InfoWorld'',
			@SCOPER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',
			@CLASS_CODE=N''MNT'',@CLASS_CODE_SYSTEM=N''2.16.840.1.113883.5.110'',
			@CLASS_CODE_SYSTEM_NAME=N''RoleClass'',
			@CLASS_DISPLAY_NAME=N''maintained entity'',
			@CODE_CODE=NULL,
			@CODE_CODE_SYSTEM=NULL,
			@CODE_CODE_SYSTEM_NAME=NULL,
			@CODE_DISPLAY_NAME=NULL,
			@NEGATION_IND=NULL,
			@NAME_FAMILY=NULL,
			@NAME_FIRST_GIVEN=NULL,
			@NAME_SECOND_GIVEN=NULL,
			@NAME_PREFIX=NULL,
			@NAME_SUFFIX=NULL,
			@STATUS_CODE=NULL,
			@STATUS_CODE_SYSTEM=NULL,
			@STATUS_CODE_SYSTEM_NAME=NULL,
			@STATUS_DISPLAY_NAME=NULL,
			@EFFECTIVE_TIME_LOW=NULL,
			@EFFECTIVE_TIME_HIGH=NULL,
			@CERTIFICATE_TEXT=NULL,
			@CONFIDENTIALITY_CODE=NULL,
			@CONFIDENTIALITY_CODE_SYSTEM=NULL,
			@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,
			@CONFIDENTIALITY_DISPLAY_NAME=NULL,
			@QUANTITY_NUMERATOR_VALUE=NULL,
			@QUANTITY_NUMERATOR_UNIT=NULL,
			@QUANTITY_DENOMINATOR_VALUE=NULL,
			@QUANTITY_DENOMINATOR_UNIT=NULL,
			@POSITION_NUMBER=NULL,
			@APPROACH_SITE_CODE=NULL,
			@APPROACH_SITE_CODE_SYSTEM=NULL,
			@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,
			@APPROACH_SITE_DISPLAY_NAME=NULL,
			@TARGET_SITE_CODE=NULL,
			@TARGET_SITE_CODE_SYSTEM=NULL,
			@TARGET_SITE_CODE_SYSTEM_NAME=NULL,
			@TARGET_SITE_DISPLAY_NAME=NULL,
			@GAUGE_VALUE=NULL,
			@GAUGE_UNIT=NULL,
			@JOB_CODE=NULL,
			@JOB_CODE_SYSTEM=NULL,
			@JOB_CODE_SYSTEM_NAME=NULL,
			@JOB_DISPLAY_NAME=NULL,
			@JOB_TITLE_NAME=NULL,
			@JOB_CLASS_CODE=NULL,
			@JOB_CLASS_CODE_SYSTEM=NULL,
			@JOB_CLASS_CODE_SYSTEM_NAME=NULL,
			@JOB_CLASS_DISPLAY_NAME=NULL,
			@OCCUPATION_CODE=NULL,
			@OCCUPATION_CODE_SYSTEM=NULL,
			@OCCUPATION_CODE_SYSTEM_NAME=NULL,
			@OCCUPATION_DISPLAY_NAME=NULL,
			@SALARY_TYPE_CODE=NULL,
			@SALARY_TYPE_CODE_SYSTEM=NULL,
			@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,
			@SALARY_TYPE_DISPLAY_NAME=NULL,
			@SALARY_VALUE=NULL,
			@SALARY_CURRENCY=NULL,
			@HAZARD_EXPOSURE_TEXT=NULL,
			@PROTECTIVE_EQUIPMENT_TEXT=NULL,
			@RECERTIFICATION_TIME=NULL,
			@VIP_CODE=NULL,
			@VIP_CODE_SYSTEM=NULL,
			@VIP_CODE_SYSTEM_NAME=NULL,
			@VIP_DISPLAY_NAME=NULL,
			@EQUIVALENCE_IND=NULL,@DATA_TYPE=N''ROL''' AS  DELETE_COMMENT
			FROM #BEDS AS BED
		)

		INSERT INTO #COMMENT(ROW_NO, ID, DELETE_COMMENT)
		SELECT ROW_NO, ID, DELETE_COMMENT
		FROM C
		ORDER BY ID

		DROP TABLE #WARDGROUP
		DROP TABLE #BEDS

		DECLARE @LAST_INDEX INT, @LAST_INDEX_PAGE INT, @LAST_INDEX_PREV INT, @PAGE_COUNT INT, @I INT
		SET @PAGE_COUNT = 500
		SET @I = 1
		SET @LAST_INDEX_PAGE = 0
		SET @LAST_INDEX_PREV = 0
		SELECT @LAST_INDEX = MAX(ID) FROM #COMMENT
		WHILE (@LAST_INDEX_PAGE < @LAST_INDEX)
		BEGIN
			SET @LAST_INDEX_PREV = @LAST_INDEX_PAGE
			SELECT @LAST_INDEX_PAGE = ID FROM #COMMENT WHERE ROW_NO = @PAGE_COUNT*@I
			IF (@LAST_INDEX_PAGE = @LAST_INDEX_PREV)
				SELECT @LAST_INDEX_PAGE = MAX(ID) FROM #COMMENT
		SET @SQL = 'DECLARE @P1 INT '	
		SELECT @SQL = @SQL + '
				'+  COMMENT.DELETE_COMMENT +'
		 '
		FROM #COMMENT AS COMMENT
		WHERE COMMENT.ID > @LAST_INDEX_PREV AND COMMENT.ID <= @LAST_INDEX_PAGE
		DELETE FROM #COMMENT WHERE ID > @LAST_INDEX_PREV AND ID <= @LAST_INDEX_PAGE
		SET @I = @I + 1
		EXEC sp_executesql @SQL
		SET @SQL = NULL
		END 

		DROP TABLE #COMMENT
	SELECT 'COMMENT - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;	


