SET QUOTED_IDENTIFIER OFF
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER, @VISTA_CODE NVARCHAR(10), @VISTA_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT	@VISTA_CODE = V.IDENTIFIER_EXTENSION, 
				@FACILITY_UID = E.IDENTIFIER, 
				@VISTA_UID = E_VISTA.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E 
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN BMS_EIS.dbo.ENTITY AS E_VISTA ON E_VISTA.PK_ENTITY = V.FK_ENTITY
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

		CREATE TABLE #ACT(ACT_ID INT, FLOW_ID UNIQUEIDENTIFIER)
		INSERT INTO #ACT(ACT.ACT_ID, ACT.FLOW_ID)
		SELECT ACT.ID, ACT.FLOW_ID FROM BMS.dbo.ACT AS ACT
		INNER JOIN BMS.dbo.WAITING_LIST AS WL ON WL.ACT_ID = ACT.ID 
		WHERE WL.FACILITY_UID = @FACILITY_UID AND WL.REMOVED_DATE IS NULL

		--DELETE FROM BMS DATABASE
		DELETE WL FROM BMS.dbo.WAITING_LIST AS WL
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID = WL.ACT_ID
				
		DELETE ACT FROM BMS.dbo.ACT AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID = ACT.ID

		DELETE FROM BMS.dbo.VISTA_OPERATIONS WHERE VISTA_ID = @VISTA_UID AND OPERATION_ID = 1024
		DELETE FROM BMS.dbo.VISTA_INTEGRATION_LOG WHERE VISTA = @VISTA_CODE AND VISTA_FILE = 'WL'

		--DELETE FROM BMS_HISTORY DATABASE
		DELETE WL FROM BMS_HISTORY.dbo.WAITING_LIST_H AS WL 
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID = WL.ACT_ID

		DELETE ACT FROM BMS_HISTORY.dbo.ACT_H AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID = ACT.ID	

		--DELETE FROM BMS_InstanceStore
		CREATE TABLE #SURROGATE_INSTANCE(SurrogateInstanceId INT)
		INSERT INTO #SURROGATE_INSTANCE(SurrogateInstanceId)
		SELECT SurrogateInstanceId FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancesTable] AS SI
		INNER JOIN #ACT AS ACT ON ACT.FLOW_ID = SI.Id  
		WHERE SI.BlockingBookmarks LIKE '%BMS.Workflows.WF.IWaitingListFlow%'

		DROP TABLE #ACT

		DELETE IPPT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancePromotedPropertiesTable] AS IPPT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IPPT.SurrogateInstanceId

		DELETE KT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[KeysTable] AS KT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = KT.SurrogateInstanceId

		DELETE IMCT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstanceMetadataChangesTable] AS IMCT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IMCT.SurrogateInstanceId

		DELETE RIT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[RunnableInstancesTable] AS RIT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = RIT.SurrogateInstanceId

		DELETE IT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancesTable] AS IT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IT.SurrogateInstanceId

		DROP TABLE #SURROGATE_INSTANCE
	SELECT 'Active Facility Waiting List - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	SELECT  ERROR_LINE() AS ErrorLine,
			ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
SET QUOTED_IDENTIFIER ON
