﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Schedulers.DateTimeValidators
{
    public static class Utilities
    {
        private class AndDateTimeValidator : IDateTimeValidator
        {
            private readonly IDateTimeValidator validator1, validator2;

            public AndDateTimeValidator(IDateTimeValidator validator1, IDateTimeValidator validator2)
            {
                this.validator1 = validator1;
                this.validator2 = validator2;
            }

            public bool IsValid(DateTime now)
            {
                return validator1.IsValid(now) & validator2.IsValid(now);
            }

            public void Init(DateTime dateTimeStarted)
            {
                validator1.Init(dateTimeStarted);
                validator2.Init(dateTimeStarted);
            }
        }

        public static IDateTimeValidator And(this IDateTimeValidator validator1, IDateTimeValidator validator2)
        {

            if (validator1 == null || validator2 == null)
                throw new ArgumentNullException();

            return new AndDateTimeValidator(validator1, validator2);

        }
    }
}
