﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Schedulers.DateTimeValidators.TimerValidators
{
    public class OccursOnce : IDateTimeValidator
    {
        public TimeSpan OccursAt { get; private set; }
        private int totalMinutes;

        public OccursOnce(TimeSpan occursAt)
        {
            OccursAt = occursAt;
            totalMinutes = (int)occursAt.TotalMinutes;
        }

        public void Init(DateTime dateTimeStarted)
        {
        }

        public bool IsValid(DateTime now)
        {
            int nowTotalMinutes = (int)Math.Round(now.TimeOfDay.TotalMinutes, 0);
            if (nowTotalMinutes == 1440 && totalMinutes == 0)
                return true;
            bool result = nowTotalMinutes == totalMinutes;
            return result;

        }
    }
}
