﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Schedulers.DateTimeValidators.CalendarValidators
{
    public class WeeklyRecurs : IDateTimeValidator
    {
        public int RecursEvery { get; private set; }

        private DateTime currentFirstDayOfWeek;
        private DateTime nextFirstDayOfWeek;

        public IList<DayOfWeek> DayOfWeeks { get; private set; }

        public void Init(DateTime dateTimeStarted)
        {
            currentFirstDayOfWeek = dateTimeStarted.Date.AddDays(-(int)dateTimeStarted.DayOfWeek - 7);
            nextFirstDayOfWeek = currentFirstDayOfWeek.AddDays(7 * RecursEvery);
        }

        public WeeklyRecurs(int recursEvery, IList<DayOfWeek> dayOfWeeks)
        {
                RecursEvery = recursEvery;
                DayOfWeeks = dayOfWeeks;
        }

        private bool CheckRecursEvery(DateTime now)
        {

                DateTime firstDayOfWeek = now.Date.AddDays(-(int)now.DayOfWeek);
                if (firstDayOfWeek == currentFirstDayOfWeek)
                    return true;
                if (firstDayOfWeek == nextFirstDayOfWeek)
                {
                    currentFirstDayOfWeek = nextFirstDayOfWeek;
                    nextFirstDayOfWeek = nextFirstDayOfWeek.AddDays(7 * RecursEvery);
                    return true;
                }
                return false;
        }

        public bool IsValid(DateTime now)
        {

                bool checkRecursEvery = CheckRecursEvery(now);
                bool result = checkRecursEvery & DayOfWeeks.Contains(now.DayOfWeek);
                return result;
        }
    }
}
