	USE [PERF_BMS_VISTA]
	
	DECLARE @minSID int = 10, @resetSID int = 10, @maxPatients int = 1000
	DECLARE @tmp int
	declare @dtMovementREQ datetime, @dtMovementREQ_Start datetime, @dtMovementREQ_End datetime
	declare @dtMovementEVN datetime, @dtMovementEVN_Start datetime, @dtMovementEVN_End datetime	
	
	set @dtMovementREQ_Start = '2012-05-16'
	set @dtMovementREQ_End = '2012-05-20'
	
	set @dtMovementEVN_Start = '2012-05-21'
	set @dtMovementEVN_End = '2012-05-25'

-- MOVEMENT
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpMovementData') AND type in (N'U'))
		DROP TABLE tmpMovementData
		
	CREATE TABLE tmpMovementData(HL_id int, Ward_id int, Bed_id int)
	
	SET @minSID = @minSID + @maxPatients/2 --2nd half of the admitted patients (500)
		
	WHILE @minSID < (@resetSID + @maxPatients) -- 510<1010
		BEGIN
		--select different bed than the one the patient was admitted, so it be available
		--works only when a bed is only in one ward in table RMDB_WARDS_WITH_CAN_ASSIGN
		INSERT INTO tmpMovementData(Bed_id, Ward_id, HL_id)
		SELECT RB.IEN, WB.WARDS_WHICH_CAN_ASSIGN_ID, WL.HOSPITAL_LOCATION_ID 
		FROM dbo.RMDB_WARDS_WITH_CAN_ASSIGN AS WB 
			join ROOM_BED AS RB on WB.ROOM_BED_ID = RB.IEN
			left join PATIENT P  on P.ROOM_BED_ID = RB.ien	
			join tmpBed B on B.Bed_id = RB.IEN	
			join WARD_LOCATION WL ON WB.WARDS_WHICH_CAN_ASSIGN_ID = WL.IEN		
		WHERE P.IEN is null and B.Number = @minSID + @maxPatients -- >= 1010
		
		

		SELECT @dtMovementREQ = @dtMovementREQ_Start +  (ABS( CAST(CAST( NewID() AS BINARY(8)) AS INT)) % CAST((@dtMovementREQ_End - @dtMovementREQ_Start) AS INT))

		-- Create movement order
		INSERT INTO [dbo].[CPRS_ORDERS]
			   ([OBJECT_OF_ORDER]
			   ,[DATE_OF_LAST_ACTIVITY]
			   ,[ORDER_STATUS_ID]
			   ,[PATIENT_LOCATION_ID]
			   ,[ITEM_ORDERED]
			   ,[START_DATE]
			   ,[STOP_DATE]
			   ,[DC_DATE_TIME]
			   ,[TO_DISPLAY_GROUP_ID]
			   ,[ORDERABLE_ITEM_ID]
			   ,INTERNAL_UID)
		 SELECT 'PAT, TAP ' + cast(@minSID as varchar),
				@dtMovementREQ,
				1,
				HL_id,
				null,
				@dtMovementREQ,
				null,
				null,
				null,
				2, --TRANSFER				
				newid()
		 FROM tmpMovementData
		 
		 SET @tmp = SCOPE_IDENTITY()
		
		INSERT INTO [dbo].[CPRS_ORDERS_ORDERABLE_ITEM]
           ([CPRS_ORDERS_ID],[ORDERABLE_ITEM_ID])
         VALUES (@tmp,2)
         
          INSERT INTO [dbo].[ORDER_ACTIONS]
           ([DATE_TIME_ORDERED]
           ,[ORDER_TEXT]
           ,[SIGNATURE_STATUS]
           ,[DATE_TIME_SIGNED]
           ,[SIGNED_BY_ID]
           ,[NEW_PERSON_NAME]
           ,[PROVIDER_ID]
           ,[DATE_TIME_NURSE_VERIFIED]
           ,[VERIFYING_NURSE_ID]
           ,[DATE_TIME_CLERK_VERIFIED]
           ,[VERIFYING_CLERK_ID]
           ,[RELEASE_DATE_TIME]
           ,[RELEASE_STATUS]
           ,[CPRS_ORDER_ID])
		VALUES	
			(@dtMovementREQ,
			'trsf',
			null,
			@dtMovementREQ,
			 1,
			 null,
			 2,
			 null, null, null, null,
			 @dtMovementREQ, null,
			 @tmp	
			)
		
		--WHILE EXISTS (SELECT 1 FROM dbo.[WORKFLOW_LOG])
		--	WAITFOR DELAY '00:01';
		
		SELECT @dtMovementEVN = @dtMovementEVN_Start +  (ABS( CAST(CAST( NewID() AS BINARY(8)) AS INT)) % CAST((@dtMovementEVN_End - @dtMovementEVN_Start) AS INT))
		
		-- Create movement event	
		INSERT INTO [dbo].[PATIENT_MOVEMENT]
           ([DATETIME]
           ,[ENTERED_ON_DATETIME]
           ,[ENTERED_BY_ID]
           ,[TRANSACTION_ID]
           ,[MAS_MOVEMENT_TRANS_NAME]
           ,[PATIENT_ID]
           ,[TYPE_OF_MOVEMENT_ID]
           ,[FAC_MOVE_TYPE_NAME]
           ,[WARD_LOCATION_ID]
           ,[ROOM_BED_ID]
           ,[ADMISSION_CHECK_IN_MOVEMENT_ID]
           ,[RELATED_PHYSICAL_MOVEMENT_ID]
           ,[WARD_AT_DISCHARGE]
           ,[TRANSACTION_]
           ,INTERNAL_UID)
		SELECT
			@dtMovementEVN,
			@dtMovementEVN,
			2,
			null,null,
			P.IEN,
			1,
			null,
			Ward_id,
			Bed_id,
			null, null, null,
			2, -- Movement
			newid()
		FROM tmpMovementData, PATIENT P
		WHERE P.NAME = 'PAT, TAP ' + cast(@minSID as varchar)
		
		DELETE FROM tmpMovementData
		
		SET @minSID += 1 
		--end
		 
	END