USE BMS
BEGIN TRAN 

DECLARE @REGION_NAME NVARCHAR(100), @REGION_ID NVARCHAR(100),
		@VISN_NAME NVARCHAR(100), @VISN_ID NVARCHAR(100),
		@FACILITY_NAME NVARCHAR(100), @FACILITY_ID NVARCHAR(100),@PK_FACILITY INT,
		@VDIVISION_NAME NVARCHAR(100), @VDIVISION_ID NVARCHAR(100),
		@WARD1_NAME NVARCHAR(100), @WARD1_ID NVARCHAR(100), @PK_WARD1 INT, @PK_WARD1_BMS INT,
		@WARD2_NAME NVARCHAR(100), @WARD2_ID NVARCHAR(100), @PK_WARD2 INT, @PK_WARD2_BMS INT,
		@BED1_NAME NVARCHAR(100), @BED1_ID NVARCHAR(100),
		@BED2_NAME NVARCHAR(100), @BED2_ID NVARCHAR(100),
		@BED3_NAME NVARCHAR(100), @BED3_ID NVARCHAR(100),
		@BED4_NAME NVARCHAR(100), @BED4_ID NVARCHAR(100),
		@DIVISION_ID NVARCHAR(100), @DIVISION_NAME NVARCHAR(100),
		@PK_ENTITY INT

SET @REGION_NAME = 'REGION1'
SET @DIVISION_ID = CAST(NEWID() AS NVARCHAR(100))
SET @DIVISION_NAME = 'Division R.1'

--GET REGION
SELECT TOP 1 @REGION_ID = E.IDENTIFIER , @PK_ENTITY = E.PK_ENTITY
FROM [BMS_EIS].[dbo].[EHL7_ORGANIZATION] O
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = O.PFK_ORGANIZATION
WHERE O.CODE_CODE = 'REG' AND O.NAME = @REGION_NAME

IF @REGION_ID IS NULL RAISERROR ('@REGION_ID IS NULL', 18, 3)
IF @DIVISION_NAME IS NULL RAISERROR ('@DIVISION_NAME IS NULL', 18, 3)

----GET VISN
SELECT TOP 1 @PK_ENTITY = FK_PLAYER_ENTITY
FROM [BMS_EIS].[dbo].[EHL7_ROLE]
WHERE FK_SCOPER_ENTITY = @PK_ENTITY
SELECT TOP 1 @VISN_ID = E.IDENTIFIER , @VISN_NAME = O.NAME
FROM [BMS_EIS].[dbo].[EHL7_ORGANIZATION] O
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = O.PFK_ORGANIZATION
WHERE O.CODE_CODE = 'VISN' AND  E.PK_ENTITY = @PK_ENTITY 
ORDER BY O.NAME

--GET FACILITY
SELECT TOP 1 @PK_ENTITY = FK_PLAYER_ENTITY
FROM [BMS_EIS].[dbo].[EHL7_ROLE]
WHERE FK_SCOPER_ENTITY = @PK_ENTITY
SELECT TOP 1 @PK_FACILITY = O.PFK_ORGANIZATION, @FACILITY_ID = E.IDENTIFIER , @FACILITY_NAME = O.NAME
FROM [BMS_EIS].[dbo].[EHL7_ORGANIZATION] O
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = O.PFK_ORGANIZATION
WHERE CODE_CODE = 'FAC' AND  E.PK_ENTITY = @PK_ENTITY 
ORDER BY O.NAME

--GET VIRTUAL DIVISION
SELECT TOP 1 @PK_ENTITY = FK_PLAYER_ENTITY
FROM [BMS_EIS].[dbo].[EHL7_ROLE]
WHERE FK_SCOPER_ENTITY = @PK_ENTITY
SELECT TOP 1 @VDIVISION_ID = E.IDENTIFIER , @VDIVISION_NAME = O.NAME
FROM [BMS_EIS].[dbo].[EHL7_ORGANIZATION] O
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = O.PFK_ORGANIZATION
WHERE CODE_CODE = 'WGR' AND  E.PK_ENTITY = @PK_ENTITY 


--GET WARDS
SELECT TOP 1 @WARD1_ID =  E.IDENTIFIER , @WARD1_NAME = P.NAME, @PK_WARD1 = P.PFK_PLACE
FROM [BMS_EIS].[dbo].[EHL7_PLACE] P
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = P.PFK_PLACE
WHERE CODE_CODE = 'WRD' AND  E.PK_ENTITY IN
(
  SELECT  FK_PLAYER_ENTITY
  FROM [BMS_EIS].[dbo].[EHL7_ROLE]
  WHERE FK_SCOPER_ENTITY = @PK_ENTITY
)
ORDER BY P.NAME ASC

SELECT TOP 1 @WARD2_ID =  E.IDENTIFIER , @WARD2_NAME = P.NAME, @PK_WARD2 = P.PFK_PLACE
FROM [BMS_EIS].[dbo].[EHL7_PLACE] P
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = P.PFK_PLACE
WHERE CODE_CODE = 'WRD' AND  E.PK_ENTITY IN
(
  SELECT  FK_PLAYER_ENTITY
  FROM [BMS_EIS].[dbo].[EHL7_ROLE]
  WHERE FK_SCOPER_ENTITY = @PK_ENTITY
)
ORDER BY P.NAME DESC

-- GET BEDS
SELECT TOP 1 @BED1_ID =  E.IDENTIFIER , @BED1_NAME = P.NAME
FROM [BMS_EIS].[dbo].[EHL7_PLACE] P
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = P.PFK_PLACE
WHERE CODE_CODE = 'BED' AND  E.PK_ENTITY IN
(
  SELECT  FK_PLAYER_ENTITY
  FROM [BMS_EIS].[dbo].[EHL7_ROLE]
  WHERE FK_SCOPER_ENTITY = @PK_WARD1
)
ORDER BY P.NAME ASC

SELECT TOP 1 @BED2_ID =  E.IDENTIFIER , @BED2_NAME = P.NAME
FROM [BMS_EIS].[dbo].[EHL7_PLACE] P
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = P.PFK_PLACE
WHERE CODE_CODE = 'BED' AND  E.PK_ENTITY IN
(
  SELECT  FK_PLAYER_ENTITY
  FROM [BMS_EIS].[dbo].[EHL7_ROLE]
  WHERE FK_SCOPER_ENTITY = @PK_WARD1
)
ORDER BY P.NAME DESC

SELECT TOP 1 @BED3_ID =  E.IDENTIFIER , @BED3_NAME = P.NAME
FROM [BMS_EIS].[dbo].[EHL7_PLACE] P
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = P.PFK_PLACE
WHERE CODE_CODE = 'BED' AND  E.PK_ENTITY IN
(
  SELECT  FK_PLAYER_ENTITY
  FROM [BMS_EIS].[dbo].[EHL7_ROLE]
  WHERE FK_SCOPER_ENTITY = @PK_WARD2
)
ORDER BY P.NAME ASC

SELECT TOP 1 @BED4_ID =  E.IDENTIFIER , @BED4_NAME = P.NAME
FROM [BMS_EIS].[dbo].[EHL7_PLACE] P
	INNER JOIN [BMS_EIS].[dbo].[ENTITY] E ON E.PK_ENTITY = P.PFK_PLACE
WHERE CODE_CODE = 'BED' AND  E.PK_ENTITY IN
(
  SELECT  FK_PLAYER_ENTITY
  FROM [BMS_EIS].[dbo].[EHL7_ROLE]
  WHERE FK_SCOPER_ENTITY = @PK_WARD2
)
ORDER BY P.NAME DESC

PRINT 'REGION  ' + @REGION_NAME + '   ' + @REGION_ID
PRINT 'VISN  ' + @VISN_NAME + '   ' + @VISN_ID
PRINT 'FACILITY  ' + @FACILITY_NAME + '   ' + @FACILITY_ID
PRINT 'VIRTUAL DIVISION  ' + @VDIVISION_NAME + '   ' + @VDIVISION_ID
PRINT 'WARD 1  ' + @WARD1_NAME + '   ' + @WARD1_ID
PRINT 'WARD 2  ' + @WARD2_NAME + '   ' + @WARD2_ID
PRINT 'BED 1  ' + @BED1_NAME + '   ' + @BED1_ID
PRINT 'BED 2  ' + @BED2_NAME + '   ' + @BED2_ID
PRINT 'BED 3  ' + @BED3_NAME + '   ' + @BED3_ID
PRINT 'BED 4  ' + @BED4_NAME + '   ' + @BED4_ID


--INSERT DIVISION
EXEC [BMS_EIS].[dbo].INS_ENTITY1 
	@IDENTIFIER=@DIVISION_ID,@STATUS_CODE=N'active',
	@STATUS_CODE_SYSTEM=N'HL7.EntityStatus',
	@STATUS_CODE_SYSTEM_NAME=N'HL7.EntityStatus'
	,@STATUS_DISPLAY_NAME=N'active',
	@DOMAIN_IDENTIFIER=N'InfoWorld',
	@ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization'
	,@LAST_MODIFICATION_TIME='2011-09-28 12:54:41.383',
	@TRANSACTION_ID=NULL

DECLARE @DIVISION_UID UNIQUEIDENTIFIER, @FACILITY_UID UNIQUEIDENTIFIER, @WARD1_UID UNIQUEIDENTIFIER, @WARD2_UID UNIQUEIDENTIFIER,
		@BED1_UID UNIQUEIDENTIFIER, @BED2_UID UNIQUEIDENTIFIER, @BED3_UID UNIQUEIDENTIFIER, @BED4_UID UNIQUEIDENTIFIER, @DATE_NOW DATETIME
		
SET @DIVISION_UID = CAST(@DIVISION_ID AS UNIQUEIDENTIFIER)
SET @FACILITY_UID = CAST(@FACILITY_ID AS UNIQUEIDENTIFIER)
SET @WARD1_UID = CAST(@WARD1_ID AS UNIQUEIDENTIFIER)
SET @WARD2_UID = CAST(@WARD2_ID AS UNIQUEIDENTIFIER)
SET @BED1_UID = CAST(@BED1_ID AS UNIQUEIDENTIFIER)
SET @BED2_UID = CAST(@BED2_ID AS UNIQUEIDENTIFIER)
SET @BED3_UID = CAST(@BED3_ID AS UNIQUEIDENTIFIER)
SET @BED4_UID = CAST(@BED4_ID AS UNIQUEIDENTIFIER)
SET @DATE_NOW = GETUTCDATE()

DECLARE @P1 INT
EXEC [BMS_EIS].[dbo].INS_ORGANIZATION @PFK_ORGANIZATION=@P1 OUTPUT,@DOMAIN_IDENTIFIER=N'InfoWorld',@ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@ENTITY_IDENTIFIER=@DIVISION_ID,@CODE_CODE=N'WGR',@CODE_CODE_SYSTEM=N'2.12.24.40',@CODE_CODE_SYSTEM_NAME=N'OrganizationChart',@CODE_DISPLAY_NAME=N'WARD GROUP',@DESCRIPTION=NULL,@NAME=@DIVISION_NAME,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STANDARD_INDUSTRY_CLASS_CODE=NULL,@STANDARD_INDUSTRY_CLASS_CODE_SYSTEM=NULL,@STANDARD_INDUSTRY_CLASS_CODE_SYSTEM_NAME=NULL,@STANDARD_INDUSTRY_CLASS_DISPLAY_NAME=NULL,@EXISTENCE_TIME_LOW=NULL,@EXISTENCE_TIME_HIGH=NULL,@RISK_CODE=NULL,@RISK_CODE_SYSTEM=NULL,@RISK_CODE_SYSTEM_NAME=NULL,@RISK_DISPLAY_NAME=NULL,@HANDLING_CODE=NULL,@HANDLING_CODE_SYSTEM=NULL,@HANDLING_CODE_SYSTEM_NAME=NULL,@HANDLING_DISPLAY_NAME=NULL

SET @P1=-1
EXEC [BMS_EIS].[dbo].INS_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=@DIVISION_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@SCOPER_ENTITY_IDENTIFIER=@FACILITY_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MBR',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'member',@CODE_CODE=N'WARD_GROUP',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward Group',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'

SELECT @P1 = PK_ENTITY FROM [BMS_EIS].[dbo].[ENTITY] WHERE IDENTIFIER = @DIVISION_ID
EXEC [BMS_EIS].[dbo].INS_UID @FK_ENTITY=@P1,@IDENTIFIER_ROOT='IEN',@IDENTIFIER_EXTENSION=N'0'
EXEC [BMS_EIS].[dbo].INS_TRAIT_VALUE @ENTITY_IDENTIFIER=@DIVISION_ID,@DOMAIN_IDENTIFIER=N'InfoWorld',@ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@TRAIT_IDENTIFIER=N'IS_ACTIVE',@TRAIT_VALUE_STRING=N'TRUE',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL

-- LEGARE WARD-URI DE DIVISION
SET @P1=-1
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=@WARD1_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'SDLOC',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@p1 output,@PLAYER_ENTITY_IDENTIFIER=@WARD1_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'SDLOC',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].DEL_ROLE @PLAYER_ENTITY_IDENTIFIER=@WARD1_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@VDIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'SDLOC'
EXEC [BMS_EIS].[dbo].UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=@WARD1_UID,@DOMAIN_IDENTIFIER=N'InfoWorld',@ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@TRAIT_IDENTIFIER=N'IS_ACTIVE',@TRAIT_VALUE_STRING=N'TRUE',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
EXEC [BMS_EIS].[dbo].UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=@WARD1_UID,@DOMAIN_IDENTIFIER=N'InfoWorld',@ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@TRAIT_IDENTIFIER=N'TYPE_GROUP',@TRAIT_VALUE_STRING=N'NEURO',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL

SET @P1=-1
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=@WARD2_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'SDLOC',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@p1 output,@PLAYER_ENTITY_IDENTIFIER=@WARD2_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'SDLOC',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].DEL_ROLE @PLAYER_ENTITY_IDENTIFIER=@WARD2_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@VDIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'SDLOC'
EXEC [BMS_EIS].[dbo].UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=@WARD2_UID,@DOMAIN_IDENTIFIER=N'InfoWorld',@ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@TRAIT_IDENTIFIER=N'IS_ACTIVE',@TRAIT_VALUE_STRING=N'TRUE',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
EXEC [BMS_EIS].[dbo].UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=@WARD2_UID,@DOMAIN_IDENTIFIER=N'InfoWorld',@ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@TRAIT_IDENTIFIER=N'TYPE_GROUP',@TRAIT_VALUE_STRING=N'NEURO',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL

-- LEGARE BED-URI DE DIVISION
SET @P1=-1
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=@BED1_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD_GROUP',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward Group',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].DEL_ROLE @PLAYER_ENTITY_IDENTIFIER=@BED1_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@VDIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT'

SET @P1=-1
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=@BED2_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD_GROUP',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward Group',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].DEL_ROLE @PLAYER_ENTITY_IDENTIFIER=@BED2_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@VDIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT'

SET @P1=-1
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=@BED3_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD_GROUP',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward Group',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].DEL_ROLE @PLAYER_ENTITY_IDENTIFIER=@BED3_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@VDIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT'

SET @P1=-1
EXEC [BMS_EIS].[dbo].UPD_ROLE @PK_ROLE=@P1 OUTPUT,@PLAYER_ENTITY_IDENTIFIER=@BED4_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@DIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT',@CLASS_CODE_SYSTEM=N'2.16.840.1.113883.5.110',@CLASS_CODE_SYSTEM_NAME=N'RoleClass',@CLASS_DISPLAY_NAME=N'service delivery location',@CODE_CODE=N'WARD_GROUP',@CODE_CODE_SYSTEM=N'2.16.840.1.113883.5.111',@CODE_CODE_SYSTEM_NAME=N'RoleCode',@CODE_DISPLAY_NAME=N'Ward Group',@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N'ROL'
EXEC [BMS_EIS].[dbo].DEL_ROLE @PLAYER_ENTITY_IDENTIFIER=@BED4_ID,@PLAYER_DOMAIN_IDENTIFIER=N'InfoWorld',@PLAYER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Place',@SCOPER_ENTITY_IDENTIFIER=@VDIVISION_ID,@SCOPER_DOMAIN_IDENTIFIER=N'InfoWorld',@SCOPER_ENTITY_TYPE_IDENTIFIER=N'HL7-RIM-V3-Organization',@CLASS_CODE=N'MNT'



INSERT INTO [BMS].[dbo].[EIS_ENTITY] (EIS_UID)
VALUES (@DIVISION_ID)
SET @P1 = ident_current('[BMS].[dbo].[EIS_ENTITY]')
INSERT INTO [BMS].[dbo].[EIS_ORGANIZATION] (ID, NAME) 
VALUES (@P1, @DIVISION_NAME)


-- CONFIG
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'EMSUser', @CONFIG_VALUE = N'True', @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'BL', @FRIENDLY_NAME = N'Is EMS User'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'GuestUser', @CONFIG_VALUE = N'True', @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'BL', @FRIENDLY_NAME = N'Is Guest User'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'NationalUser', @CONFIG_VALUE = N'False', @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'BL', @FRIENDLY_NAME = N'Is National User'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'RegionalUser', @CONFIG_VALUE = N'False', @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'BL', @FRIENDLY_NAME = N'Is Regional User'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'SiteUser', @CONFIG_VALUE = N'False', @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'BL', @FRIENDLY_NAME = N'Is Site User'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'SupportUser', @CONFIG_VALUE = N'True', @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'BL', @FRIENDLY_NAME = N'Is Support User'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'VisnUser', @CONFIG_VALUE = N'False', @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'BL', @FRIENDLY_NAME = N'Is Visn User'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'Default',@SECTION=N'Profile',
@CONFIG_KEY = N'DefaultFacility', @CONFIG_VALUE = NULL, @CONFIG_TYPE = N'USR', @VALUE_TYPE = N'EIS', @FRIENDLY_NAME = N'Default Facility'
DECLARE @P2 INT
EXEC dbo.usp_Insert_Config_EIS @ID = @P2 OUTPUT, @CONFIG_ID = @P1,      
@ENTITY_ID=@FACILITY_UID, @ENTITY_NAME =@FACILITY_NAME, @ENTITY_TYPE_ID = N'HL7-RIM-V3-Organization'
SET @P1 = -1
EXEC dbo.usp_Insert_Config @ID=@P1 OUTPUT, @DOMAIN_ID=N'InfoWorld',@USER_NAME=N'',@SECTION=N'RecordsNumberPerPage',
@CONFIG_KEY = N'RecordsNumberPerPage', @CONFIG_VALUE = N'10', @CONFIG_TYPE = N'DEFAPP', @VALUE_TYPE = N'INT', @FRIENDLY_NAME = N'Number of records per page(for filters)'


-- BMS ACTS
SET CONTEXT_INFO 0x0001496E666F576F726C6420202020202020202020202020202020200003

SET @P1 = NULL
SET @P2 = NULL
DECLARE @P3 INT, @F_ID UNIQUEIDENTIFIER
SET @F_ID = NEWID()
-- ADMISSION 1
-- REQUEST
EXEC [BMS].[dbo].usp_Insert_Admission @ACT_ID=@P2 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=NULL,
@FLOW_ID=@F_ID,@DOMAIN_ID=N'InfoWorld',@PATIENT_SSN=N'147-74-7411',@PATIENT_LAST_NAME=N'KING',@PATIENT_FIRST_NAME=N'CHRISTOPHER',@PATIENT_MIDDLE_INITIAL=N'S',
@PATIENT_UID='DC140665-39F0-469B-BE10-CAC568BC0BD7',@PATIENT_GENDER_CODE=N'M',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Male',@IEN=12214,@REQ_SIGNED_DATE=@DATE_NOW,@REQ_RELEASED_DATE=@DATE_NOW,@REQ_PROVIDER_SSN=N'123-23-3211',
@REQ_PROVIDER_LAST_NAME=N'JOHNSON',
@REQ_PROVIDER_FIRST_NAME=N'MICHAEL',@REQ_PROVIDER_MIDDLE_INITIAL=N'M',@REQ_PROVIDER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',@REQ_SCHEDULER_SSN=N'123-23-3211',
@REQ_SCHEDULER_LAST_NAME=N'JOHNSON',@REQ_SCHEDULER_FIRST_NAME=N'MICHAEL',@REQ_SCHEDULER_MIDDLE_INITIAL=N'M',@REQ_SCHEDULER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_SIGNED_BY_SSN=N'123-23-3211',@REQ_SIGNED_BY_LAST_NAME=N'JOHNSON',@REQ_SIGNED_BY_FIRST_NAME=N'MICHAEL',@REQ_SIGNED_BY_MIDDLE_INITIAL=N'M',
@REQ_SIGNED_BY_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_FACILITY_NAME=@FACILITY_NAME, @REQ_FACILITY_UID=@FACILITY_UID,
@REQ_WARD_NAME=@WARD1_NAME, @REQ_WARD_UID=@WARD1_UID,
@REQ_SPECIALITY_CODE=N'GEN_SURGERY', @REQ_SPECIALITY_CODE_SYSTEM=N'2.12.24.39', @REQ_SPECIALITY_CODE_SYSTEM_NAME=N'VistaSpecialty', @REQ_SPECIALITY_DISPLAY_NAME=N'GENERAL SURGERY',
@REQ_DIAGNOSIS=N'Chron Disease', @REQ_LENGTH_OF_STAY_EXPECTED=NULL,@REQ_ORDER_TEXT=NULL,
@REQ_SURGERY=0,@REQ_PROBLEM=N'problem',@REQ_FEE_COMMENTS=N'comment',@REQ_IS_ACUTE=0,@REQ_REMOVED_DATE=NULL,
@REQ_WAITING_AREA_CODE=N'Main Waiting Area',@REQ_WAITING_AREA_CODE_SYSTEM=N'2.12.24.8',@REQ_WAITING_AREA_CODE_SYSTEM_NAME=N'WaitingArea',
@REQ_WAITING_AREA_DISPLAY_NAME=N'HOSPITAL Waiting Area',@REQ_REASON_USING_FEE_CODE=N'AccessWaitList',@REQ_REASON_USING_FEE_CODE_SYSTEM=N'2.12.24.25',
@REQ_REASON_USING_FEE_CODE_SYSTEM_NAME=N'FeeReason',@REQ_REASON_USING_FEE_DISPLAY_NAME=N'Access- Wait List',@REQ_SERVICE_RECEIVING_FEE_CODE=N'Cardiology',
@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM=N'2.12.24.24',@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME=N'ServicesReceiving',@REQ_SERVICE_RECEIVING_FEE_DISPLAY_NAME=N'Cardiology',
@REQ_AUTHORIZED_FEE_CODE=N'Yes',@REQ_AUTHORIZED_FEE_CODE_SYSTEM=N'2.12.24.15',@REQ_AUTHORIZED_FEE_CODE_SYSTEM_NAME=N'StrictDecision',@REQ_AUTHORIZED_FEE_DISPLAY_NAME=N'Yes',
@REQ_CONTRACT_FEE_CODE=N'Yes',@REQ_CONTRACT_FEE_CODE_SYSTEM=N'2.12.24.15',@REQ_CONTRACT_FEE_CODE_SYSTEM_NAME=N'StrictDecision',@REQ_CONTRACT_FEE_DISPLAY_NAME=N'Yes',
@REQ_FEE_DISPOSITION_CODE=N'Acute',@REQ_FEE_DISPOSITION_CODE_SYSTEM=N'2.12.24.23',@REQ_FEE_DISPOSITION_CODE_SYSTEM_NAME=N'FeeDisposition',
@REQ_FEE_DISPOSITION_DISPLAY_NAME=N'Acute',@REQ_TYPE_OF_BED_WARD=N'Cardiac', @REQ_IS_SCHEDULED_ADMISSION = 0,
@REQ_VISTA_DIVISION=N'DIVISION 1',@REQ_REQUESTED_BED_NAME=NULL,@REQ_REQUESTED_BED_UID=NULL,@REQ_REQUESTED_BED_DATE=NULL,@REQ_ADDED_TO_WAITING_LIST=1,
@EVN_BED_NAME=NULL,@EVN_BED_UID=NULL,
@EVN_WARD_NAME=NULL,@EVN_WARD_UID=NULL,@EVN_ATND_NURSE_SSN=NULL,@EVN_ATND_NURSE_LAST_NAME=NULL,@EVN_ATND_NURSE_FIRST_NAME=NULL,
@EVN_ATND_NURSE_MIDDLE_INITIAL=NULL,@EVN_ATND_NURSE_UID=NULL,@EVN_ADMISSION_DATE=NULL,@EVN_ENTERED_BY_SSN=NULL,@EVN_ENTERED_BY_LAST_NAME=NULL,@EVN_ENTERED_BY_FIRST_NAME=NULL,
@EVN_ENTERED_BY_MIDDLE_INITIAL=NULL,@EVN_ENTERED_BY_UID=NULL,
@EVN_TYPE_OF_MOVEMENT_CODE=NULL,@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=NULL,@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=NULL,@EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=NULL, @EVN_DIVISION_NAME = NULL, @EVN_DIVISION_UID= NULL, @OPERATION_TYPE=N'REQ'
-- EVENT
EXEC [BMS].[dbo].usp_Insert_Admission @ACT_ID=@P3 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=@P2,@FLOW_ID=@F_ID,
@DOMAIN_ID=N'InfoWorld',@PATIENT_SSN=N'147-74-7411',@PATIENT_LAST_NAME=N'KING',@PATIENT_FIRST_NAME=N'CHRISTOPHER',@PATIENT_MIDDLE_INITIAL=N'S',
@PATIENT_UID='DC140665-39F0-469B-BE10-CAC568BC0BD7',@PATIENT_GENDER_CODE=N'M',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Male',
@IEN=12455,@REQ_SIGNED_DATE=NULL,@REQ_RELEASED_DATE=NULL,@REQ_PROVIDER_SSN=NULL,@REQ_PROVIDER_LAST_NAME=NULL,@REQ_PROVIDER_FIRST_NAME=NULL,@REQ_PROVIDER_MIDDLE_INITIAL=NULL,
@REQ_PROVIDER_UID=NULL,@REQ_SCHEDULER_SSN=NULL,@REQ_SCHEDULER_LAST_NAME=NULL,@REQ_SCHEDULER_FIRST_NAME=NULL,@REQ_SCHEDULER_MIDDLE_INITIAL=NULL,@REQ_SCHEDULER_UID=NULL,
@REQ_SIGNED_BY_SSN=NULL,@REQ_SIGNED_BY_LAST_NAME=NULL,@REQ_SIGNED_BY_FIRST_NAME=NULL,@REQ_SIGNED_BY_MIDDLE_INITIAL=NULL,@REQ_SIGNED_BY_UID=NULL,
@REQ_FACILITY_NAME=NULL, @REQ_FACILITY_UID=NULL,
@REQ_WARD_NAME=NULL, @REQ_WARD_UID=NULL,@REQ_SPECIALITY_CODE=NULL, @REQ_SPECIALITY_CODE_SYSTEM=NULL,@REQ_SPECIALITY_CODE_SYSTEM_NAME=NULL, @REQ_SPECIALITY_DISPLAY_NAME=NULL,
@REQ_DIAGNOSIS=NULL, @REQ_LENGTH_OF_STAY_EXPECTED=NULL,@REQ_ORDER_TEXT=NULL,@REQ_SURGERY=NULL,@REQ_PROBLEM=NULL,@REQ_FEE_COMMENTS=NULL,@REQ_IS_ACUTE=NULL,@REQ_REMOVED_DATE=NULL,
@REQ_WAITING_AREA_CODE=NULL,@REQ_WAITING_AREA_CODE_SYSTEM=NULL,@REQ_WAITING_AREA_CODE_SYSTEM_NAME=NULL,
@REQ_WAITING_AREA_DISPLAY_NAME=NULL,@REQ_REASON_USING_FEE_CODE=NULL,@REQ_REASON_USING_FEE_CODE_SYSTEM=NULL,
@REQ_REASON_USING_FEE_CODE_SYSTEM_NAME=NULL,@REQ_REASON_USING_FEE_DISPLAY_NAME=NULL,@REQ_SERVICE_RECEIVING_FEE_CODE=NULL,
@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM=NULL,@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME=NULL,@REQ_SERVICE_RECEIVING_FEE_DISPLAY_NAME=NULL,
@REQ_AUTHORIZED_FEE_CODE=NULL,@REQ_AUTHORIZED_FEE_CODE_SYSTEM=NULL,@REQ_AUTHORIZED_FEE_CODE_SYSTEM_NAME=NULL,@REQ_AUTHORIZED_FEE_DISPLAY_NAME=NULL,
@REQ_CONTRACT_FEE_CODE=NULL,@REQ_CONTRACT_FEE_CODE_SYSTEM=NULL,@REQ_CONTRACT_FEE_CODE_SYSTEM_NAME=NULL,@REQ_CONTRACT_FEE_DISPLAY_NAME=NULL,
@REQ_FEE_DISPOSITION_CODE=NULL,@REQ_FEE_DISPOSITION_CODE_SYSTEM=NULL,@REQ_FEE_DISPOSITION_CODE_SYSTEM_NAME=NULL,@REQ_FEE_DISPOSITION_DISPLAY_NAME=NULL,@REQ_TYPE_OF_BED_WARD=NULL,@REQ_IS_SCHEDULED_ADMISSION = 1,@REQ_VISTA_DIVISION=NULL,@REQ_REQUESTED_BED_NAME=NULL,@REQ_REQUESTED_BED_UID=NULL,@REQ_REQUESTED_BED_DATE=NULL,@REQ_ADDED_TO_WAITING_LIST=NULL,
@EVN_BED_NAME=@BED1_NAME,@EVN_BED_UID=@BED1_UID,@EVN_WARD_NAME=@WARD1_NAME,@EVN_WARD_UID=@WARD1_UID,@EVN_ATND_NURSE_SSN=N'846-68-6841',
@EVN_ATND_NURSE_LAST_NAME=N'RICHARDSON',@EVN_ATND_NURSE_FIRST_NAME=N'CAITLIN',@EVN_ATND_NURSE_MIDDLE_INITIAL=N'K',@EVN_ATND_NURSE_UID='DAEB47B1-A435-4F5C-989F-F83E82283BE3',
@EVN_ADMISSION_DATE=@DATE_NOW, @EVN_ENTERED_BY_SSN=N'846-68-6841',@EVN_ENTERED_BY_LAST_NAME=N'RICHARDSON',@EVN_ENTERED_BY_FIRST_NAME=N'CAITLIN',
@EVN_ENTERED_BY_MIDDLE_INITIAL=N'K',@EVN_ENTERED_BY_UID='DAEB47B1-A435-4F5C-989F-F83E82283BE3',@EVN_TYPE_OF_MOVEMENT_CODE=N'OptNsc',@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=N'2.12.24.43',
@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=N'TypeOfMovement',@EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=N'OPT-NSC', @EVN_DIVISION_NAME = @DIVISION_NAME, @EVN_DIVISION_UID=@DIVISION_UID, @OPERATION_TYPE=N'EVN'
-- BED CLEAN
SET @P1 = NULL
EXEC [BMS].[dbo].usp_Insert_Bed_Clean @ACT_ID=@P1 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=NULL,@FLOW_ID=@F_ID,
@DOMAIN_ID=N'InfoWorld',@IEN=12112,@PATIENT_SSN=N'147-74-7411',@PATIENT_LAST_NAME=N'KING',@PATIENT_FIRST_NAME=N'CHRISTOPHER',@PATIENT_MIDDLE_INITIAL=N'S',
@PATIENT_UID='DC140665-39F0-469B-BE10-CAC568BC0BD7',@PATIENT_GENDER_CODE=N'M',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Male', @WARD_NAME=@WARD1_NAME, @WARD_UID=@WARD1_UID, @BED_NAME=@BED1_NAME, @BED_UID=@BED1_UID, @TYPE_OF_CLEAN_CODE=N'BED_CLEANED', 
@TYPE_OF_CLEAN_CODE_SYSTEM=N'2.12.24.37', @TYPE_OF_CLEAN_CODE_SYSTEM_NAME=N'BedCleaningStatus', @TYPE_OF_CLEAN_DISPLAY_NAME=N'Bed Cleaned', 
@MANUAL_REQUEST_CODE=N'Yes',@MANUAL_REQUEST_CODE_SYSTEM=N'2.12.24.15',@MANUAL_REQUEST_CODE_SYSTEM_NAME=N'StrictDecision',@MANUAL_REQUEST_DISPLAY_NAME=N'Yes',
@ACCEPTED_DATE=NULL, @ACCEPTED_BY=NULL,
@COMPLETED_DATE=NULL, @COMPLETED_BY=NULL,
@LAST_EDITED_BY = null, @LAST_EDIT_DATE  =NULL,
@REQUESTED_DATE =NULL,
@DIVISION_NAME = @DIVISION_NAME,
@DIVISION_UID = @DIVISION_UID


-- ADMISSION 2
SET @P1 = NULL SET @P2 = NULL SET @P3 = NULL
SET @F_ID = NEWID()
-- REQUEST
EXEC [BMS].[dbo].usp_Insert_Admission @ACT_ID=@P2 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=NULL,@FLOW_ID=@F_ID,
@DOMAIN_ID=N'InfoWorld',@PATIENT_SSN=N'111-12-5911',@PATIENT_LAST_NAME=N'DOUGLAS',@PATIENT_FIRST_NAME=N'ARON',@PATIENT_MIDDLE_INITIAL=N'B',
@PATIENT_UID='61E7687E-5F8D-4E83-A88E-F856A5065352',@PATIENT_GENDER_CODE=N'M',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Male',@IEN=77332,@REQ_SIGNED_DATE=@DATE_NOW,@REQ_RELEASED_DATE=@DATE_NOW,@REQ_PROVIDER_SSN=N'123-23-3211',
@REQ_PROVIDER_LAST_NAME=N'JOHNSON',
@REQ_PROVIDER_FIRST_NAME=N'MICHAEL',@REQ_PROVIDER_MIDDLE_INITIAL=N'M',@REQ_PROVIDER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',@REQ_SCHEDULER_SSN=N'123-23-3211',
@REQ_SCHEDULER_LAST_NAME=N'JOHNSON',@REQ_SCHEDULER_FIRST_NAME=N'MICHAEL',@REQ_SCHEDULER_MIDDLE_INITIAL=N'M',@REQ_SCHEDULER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_SIGNED_BY_SSN=N'123-23-3211',@REQ_SIGNED_BY_LAST_NAME=N'JOHNSON',@REQ_SIGNED_BY_FIRST_NAME=N'MICHAEL',@REQ_SIGNED_BY_MIDDLE_INITIAL=N'M',
@REQ_SIGNED_BY_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_FACILITY_NAME=@FACILITY_NAME, @REQ_FACILITY_UID=@FACILITY_UID,
@REQ_WARD_NAME=@WARD1_NAME, @REQ_WARD_UID=@WARD1_UID,
@REQ_SPECIALITY_CODE=N'MEDICAL_OBS', @REQ_SPECIALITY_CODE_SYSTEM=N'2.12.24.39', @REQ_SPECIALITY_CODE_SYSTEM_NAME=N'VistaSpecialty', @REQ_SPECIALITY_DISPLAY_NAME=N'MEDICAL OBSERVATION',
@REQ_DIAGNOSIS=N'Lyme Disease', @REQ_LENGTH_OF_STAY_EXPECTED=NULL,@REQ_ORDER_TEXT=NULL,
@REQ_SURGERY=0,@REQ_PROBLEM=N'AA',@REQ_FEE_COMMENTS=N'COMM',@REQ_IS_ACUTE=0,@REQ_REMOVED_DATE=NULL,
@REQ_WAITING_AREA_CODE=N'CLN_ADD',@REQ_WAITING_AREA_CODE_SYSTEM=N'2.12.24.8',@REQ_WAITING_AREA_CODE_SYSTEM_NAME=N'WaitingArea',
@REQ_WAITING_AREA_DISPLAY_NAME=N'CLINICAL ADDITION',@REQ_REASON_USING_FEE_CODE=N'ServiceNotAvailable',@REQ_REASON_USING_FEE_CODE_SYSTEM=N'2.12.24.25',
@REQ_REASON_USING_FEE_CODE_SYSTEM_NAME=N'FeeReason',@REQ_REASON_USING_FEE_DISPLAY_NAME=N'Service Not Available',@REQ_SERVICE_RECEIVING_FEE_CODE=N'GenSurgery',
@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM=N'2.12.24.24',@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME=N'ServicesReceiving',@REQ_SERVICE_RECEIVING_FEE_DISPLAY_NAME=N'Gen Surgery',
@REQ_AUTHORIZED_FEE_CODE=N'No',@REQ_AUTHORIZED_FEE_CODE_SYSTEM=N'2.12.24.15',@REQ_AUTHORIZED_FEE_CODE_SYSTEM_NAME=N'StrictDecision',@REQ_AUTHORIZED_FEE_DISPLAY_NAME=N'No',
@REQ_CONTRACT_FEE_CODE=N'Yes',@REQ_CONTRACT_FEE_CODE_SYSTEM=N'2.12.24.15',@REQ_CONTRACT_FEE_CODE_SYSTEM_NAME=N'StrictDecision',@REQ_CONTRACT_FEE_DISPLAY_NAME=N'Yes',
@REQ_FEE_DISPOSITION_CODE=N'Acute',@REQ_FEE_DISPOSITION_CODE_SYSTEM=N'2.12.24.23',@REQ_FEE_DISPOSITION_CODE_SYSTEM_NAME=N'FeeDisposition',
@REQ_FEE_DISPOSITION_DISPLAY_NAME=N'Acute',@REQ_TYPE_OF_BED_WARD=N'Private', @REQ_IS_SCHEDULED_ADMISSION = 0,
@REQ_VISTA_DIVISION=N'DIVISION 1',@REQ_REQUESTED_BED_NAME=NULL,@REQ_REQUESTED_BED_UID=NULL,@REQ_REQUESTED_BED_DATE=NULL,@REQ_ADDED_TO_WAITING_LIST=1,
@EVN_BED_NAME=NULL,@EVN_BED_UID=NULL,@EVN_WARD_NAME=NULL,@EVN_WARD_UID=NULL,@EVN_ATND_NURSE_SSN=NULL,@EVN_ATND_NURSE_LAST_NAME=NULL,@EVN_ATND_NURSE_FIRST_NAME=NULL,
@EVN_ATND_NURSE_MIDDLE_INITIAL=NULL,@EVN_ATND_NURSE_UID=NULL,@EVN_ADMISSION_DATE=NULL,@EVN_ENTERED_BY_SSN=NULL,@EVN_ENTERED_BY_LAST_NAME=NULL,@EVN_ENTERED_BY_FIRST_NAME=NULL,
@EVN_ENTERED_BY_MIDDLE_INITIAL=NULL,@EVN_ENTERED_BY_UID=NULL,@EVN_TYPE_OF_MOVEMENT_CODE=NULL,@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=NULL,
@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=NULL,@EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=NULL, @EVN_DIVISION_NAME = NULL, @EVN_DIVISION_UID= NULL, @OPERATION_TYPE=N'REQ'
-- EVENT
EXEC [BMS].[dbo].usp_Insert_Admission @ACT_ID=@P3 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=@P2,@FLOW_ID=@F_ID,
@DOMAIN_ID=N'InfoWorld',@PATIENT_SSN=N'111-12-5911',@PATIENT_LAST_NAME=N'DOUGLAS',@PATIENT_FIRST_NAME=N'ARON',@PATIENT_MIDDLE_INITIAL=N'B',
@PATIENT_UID='61E7687E-5F8D-4E83-A88E-F856A5065352',@PATIENT_GENDER_CODE=N'M',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Male',@IEN=85442,@REQ_SIGNED_DATE=NULL,@REQ_RELEASED_DATE=NULL,@REQ_PROVIDER_SSN=NULL,@REQ_PROVIDER_LAST_NAME=NULL,@REQ_PROVIDER_FIRST_NAME=NULL,@REQ_PROVIDER_MIDDLE_INITIAL=NULL,
@REQ_PROVIDER_UID=NULL,@REQ_SCHEDULER_SSN=NULL,@REQ_SCHEDULER_LAST_NAME=NULL,@REQ_SCHEDULER_FIRST_NAME=NULL,@REQ_SCHEDULER_MIDDLE_INITIAL=NULL,@REQ_SCHEDULER_UID=NULL,
@REQ_SIGNED_BY_SSN=NULL,@REQ_SIGNED_BY_LAST_NAME=NULL,@REQ_SIGNED_BY_FIRST_NAME=NULL,@REQ_SIGNED_BY_MIDDLE_INITIAL=NULL,@REQ_SIGNED_BY_UID=NULL,
@REQ_FACILITY_NAME=NULL, @REQ_FACILITY_UID=NULL,
@REQ_WARD_NAME=NULL, @REQ_WARD_UID=NULL,@REQ_SPECIALITY_CODE=NULL, @REQ_SPECIALITY_CODE_SYSTEM=NULL,@REQ_SPECIALITY_CODE_SYSTEM_NAME=NULL, @REQ_SPECIALITY_DISPLAY_NAME=NULL,
@REQ_DIAGNOSIS=NULL, @REQ_LENGTH_OF_STAY_EXPECTED=NULL,@REQ_ORDER_TEXT=NULL,@REQ_SURGERY=NULL,@REQ_PROBLEM=NULL,@REQ_FEE_COMMENTS=NULL,@REQ_IS_ACUTE=NULL,@REQ_REMOVED_DATE=NULL,
@REQ_WAITING_AREA_CODE=NULL,@REQ_WAITING_AREA_CODE_SYSTEM=NULL,@REQ_WAITING_AREA_CODE_SYSTEM_NAME=NULL,
@REQ_WAITING_AREA_DISPLAY_NAME=NULL,@REQ_REASON_USING_FEE_CODE=NULL,@REQ_REASON_USING_FEE_CODE_SYSTEM=NULL,
@REQ_REASON_USING_FEE_CODE_SYSTEM_NAME=NULL,@REQ_REASON_USING_FEE_DISPLAY_NAME=NULL,@REQ_SERVICE_RECEIVING_FEE_CODE=NULL,
@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM=NULL,@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME=NULL,@REQ_SERVICE_RECEIVING_FEE_DISPLAY_NAME=NULL,
@REQ_AUTHORIZED_FEE_CODE=NULL,@REQ_AUTHORIZED_FEE_CODE_SYSTEM=NULL,@REQ_AUTHORIZED_FEE_CODE_SYSTEM_NAME=NULL,@REQ_AUTHORIZED_FEE_DISPLAY_NAME=NULL,
@REQ_CONTRACT_FEE_CODE=NULL,@REQ_CONTRACT_FEE_CODE_SYSTEM=NULL,@REQ_CONTRACT_FEE_CODE_SYSTEM_NAME=NULL,@REQ_CONTRACT_FEE_DISPLAY_NAME=NULL,
@REQ_FEE_DISPOSITION_CODE=NULL,@REQ_FEE_DISPOSITION_CODE_SYSTEM=NULL,@REQ_FEE_DISPOSITION_CODE_SYSTEM_NAME=NULL,@REQ_FEE_DISPOSITION_DISPLAY_NAME=NULL,@REQ_TYPE_OF_BED_WARD=NULL, @REQ_IS_SCHEDULED_ADMISSION = 0,@REQ_VISTA_DIVISION=NULL,@REQ_REQUESTED_BED_NAME=NULL,@REQ_REQUESTED_BED_UID=NULL,@REQ_REQUESTED_BED_DATE=NULL,@REQ_ADDED_TO_WAITING_LIST=NULL,
@EVN_BED_NAME=@BED2_NAME,@EVN_BED_UID=@BED2_UID,@EVN_WARD_NAME=@WARD1_NAME,@EVN_WARD_UID=@WARD1_UID,@EVN_ATND_NURSE_SSN=N'078-05-1120',@EVN_ATND_NURSE_LAST_NAME=N'SMITH',
@EVN_ATND_NURSE_FIRST_NAME=N'JOHN',@EVN_ATND_NURSE_MIDDLE_INITIAL=N'A',@EVN_ATND_NURSE_UID='A45DA8B7-B69B-4E27-8E7B-9832656A1DEC',@EVN_ADMISSION_DATE=@DATE_NOW,
@EVN_ENTERED_BY_SSN=N'078-05-1120',@EVN_ENTERED_BY_LAST_NAME=N'SMITH',@EVN_ENTERED_BY_FIRST_NAME=N'JOHN',
@EVN_ENTERED_BY_MIDDLE_INITIAL=N'A',@EVN_ENTERED_BY_UID='A45DA8B7-B69B-4E27-8E7B-9832656A1DEC',@EVN_TYPE_OF_MOVEMENT_CODE=N'OptNsc',
@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=N'2.12.24.43',@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=N'TypeOfMovement',@EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=N'OPT-NSC',
@EVN_DIVISION_NAME = @DIVISION_NAME, @EVN_DIVISION_UID=@DIVISION_UID,
@OPERATION_TYPE=N'EVN'
-- BED CLEAN
SET @P1=NULL
EXEC [BMS].[dbo].usp_Insert_Bed_Clean @ACT_ID=@P1 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=NULL,@FLOW_ID=@F_ID,
@DOMAIN_ID=N'InfoWorld',@IEN=12111,@PATIENT_SSN=N'111-12-5911',@PATIENT_LAST_NAME=N'DOUGLAS',@PATIENT_FIRST_NAME=N'ARON',@PATIENT_MIDDLE_INITIAL=N'B',
@PATIENT_UID='61E7687E-5F8D-4E83-A88E-F856A5065352',@PATIENT_GENDER_CODE=N'M',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Male', @WARD_NAME=@WARD1_NAME, @WARD_UID=@WARD1_UID, @BED_NAME=@BED2_NAME, @BED_UID=@BED2_UID,
@TYPE_OF_CLEAN_CODE=N'CLEANING_BED', @TYPE_OF_CLEAN_CODE_SYSTEM=N'2.12.24.37', @TYPE_OF_CLEAN_CODE_SYSTEM_NAME=N'BedCleaningStatus',@TYPE_OF_CLEAN_DISPLAY_NAME=N'Cleaning Bed', 
@MANUAL_REQUEST_CODE=N'Yes',@MANUAL_REQUEST_CODE_SYSTEM=N'2.12.24.15',@MANUAL_REQUEST_CODE_SYSTEM_NAME=N'StrictDecision',@MANUAL_REQUEST_DISPLAY_NAME=N'Yes',
@ACCEPTED_DATE=NULL, @ACCEPTED_BY=NULL,
@COMPLETED_DATE=NULL, @COMPLETED_BY=NULL,
@LAST_EDITED_BY = null, @LAST_EDIT_DATE  =NULL,
@REQUESTED_DATE =NULL,
@DIVISION_NAME = @DIVISION_NAME,
@DIVISION_UID = @DIVISION_UID
-- BED UNAVAILABLE
SET @P1=NULL

EXEC [BMS].[dbo].usp_Insert_Bed_Unavailable @ACT_ID=@P1 OUTPUT, @COMMENT=N'comments', @CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,
@PARENT_ACT_ID=NULL,@FLOW_ID=@F_ID,
@DOMAIN_ID=N'InfoWorld',@IEN=21211,@PATIENT_SSN=N'111-12-5911',@PATIENT_LAST_NAME=N'DOUGLAS',@PATIENT_FIRST_NAME=N'ARON',@PATIENT_MIDDLE_INITIAL=N'B',
@PATIENT_UID='61E7687E-5F8D-4E83-A88E-F856A5065352',@PATIENT_GENDER_CODE=N'M',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Male', @TYPE_CODE=N'BED_ISOLATION', @TYPE_CODE_SYSTEM=N'2.12.24.36', @TYPE_CODE_SYSTEM_NAME=N'BedAvailabilityStatus', 
@TYPE_DISPLAY_NAME=N'Bed In Isolation', @REASON_CODE=N'ISOLATION', @REASON_CODE_SYSTEM=N'2.12.24.33', @REASON_CODE_SYSTEM_NAME=N'UnavailableReason', 
@REASON_DISPLAY_NAME=N'ISOLATION', @WARD_NAME=@WARD1_NAME, @WARD_UID=@WARD1_UID, @BED_NAME=@BED2_NAME, @BED_UID=@BED2_UID,@CREATION_BY=NULL, @EDITED_BY=NULL, @EDITED_DATE= NULL,
@COMPLETED_BY=NULL, @COMPLETED_DATE= NULL

-- ADMISSION 3
SET @P1 = NULL SET @P2 = NULL SET @P3 = NULL
SET @F_ID = NEWID()
-- REQUEST
EXEC [BMS].[dbo].usp_Insert_Admission @ACT_ID=@P2 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=NULL,@FLOW_ID=@F_ID,
@DOMAIN_ID=N'InfoWorld',@PATIENT_SSN=N'357-58-7531',@PATIENT_LAST_NAME=N'MORRIS',@PATIENT_FIRST_NAME=N'ANNA',@PATIENT_MIDDLE_INITIAL=N'T',
@PATIENT_UID='2352483C-8A4B-4CCF-B516-59B4AD1F0D5F',@PATIENT_GENDER_CODE=N'F',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Female',@IEN=34221,@REQ_SIGNED_DATE=@DATE_NOW,@REQ_RELEASED_DATE=@DATE_NOW,@REQ_PROVIDER_SSN=N'123-23-3211',@REQ_PROVIDER_LAST_NAME=N'JOHNSON',
@REQ_PROVIDER_FIRST_NAME=N'MICHAEL',@REQ_PROVIDER_MIDDLE_INITIAL=N'M',@REQ_PROVIDER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',@REQ_SCHEDULER_SSN=N'123-23-3211',
@REQ_SCHEDULER_LAST_NAME=N'JOHNSON',@REQ_SCHEDULER_FIRST_NAME=N'MICHAEL',@REQ_SCHEDULER_MIDDLE_INITIAL=N'M',@REQ_SCHEDULER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_SIGNED_BY_SSN=N'123-23-3211',@REQ_SIGNED_BY_LAST_NAME=N'JOHNSON',@REQ_SIGNED_BY_FIRST_NAME=N'MICHAEL',@REQ_SIGNED_BY_MIDDLE_INITIAL=N'M',
@REQ_SIGNED_BY_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_FACILITY_NAME=@FACILITY_NAME, @REQ_FACILITY_UID=@FACILITY_UID,@REQ_WARD_NAME=@WARD2_NAME, @REQ_WARD_UID=@WARD2_UID,
@REQ_SPECIALITY_CODE=N'MEDICAL_OBS', @REQ_SPECIALITY_CODE_SYSTEM=N'2.12.24.39', @REQ_SPECIALITY_CODE_SYSTEM_NAME=N'VistaSpecialty', @REQ_SPECIALITY_DISPLAY_NAME=N'MEDICAL OBSERVATION',
@REQ_DIAGNOSIS=N'Lyme Disease', @REQ_LENGTH_OF_STAY_EXPECTED=NULL,@REQ_ORDER_TEXT=NULL,
@REQ_SURGERY=0,@REQ_PROBLEM=N'',@REQ_FEE_COMMENTS=N'',@REQ_IS_ACUTE=1,@REQ_REMOVED_DATE=NULL,
@REQ_WAITING_AREA_CODE=N'Trest',@REQ_WAITING_AREA_CODE_SYSTEM=N'2.12.24.8',@REQ_WAITING_AREA_CODE_SYSTEM_NAME=N'WaitingArea',@REQ_WAITING_AREA_DISPLAY_NAME=N'Trest',
@REQ_REASON_USING_FEE_CODE=N'TeleBedsFull',@REQ_REASON_USING_FEE_CODE_SYSTEM=N'2.12.24.25',@REQ_REASON_USING_FEE_CODE_SYSTEM_NAME=N'FeeReason',
@REQ_REASON_USING_FEE_DISPLAY_NAME=N'Tele Beds Full',@REQ_SERVICE_RECEIVING_FEE_CODE=N'Respiratory',@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM=N'2.12.24.24',
@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME=N'ServicesReceiving',@REQ_SERVICE_RECEIVING_FEE_DISPLAY_NAME=N'Respiratory',@REQ_AUTHORIZED_FEE_CODE=N'No',
@REQ_AUTHORIZED_FEE_CODE_SYSTEM=N'2.12.24.15',@REQ_AUTHORIZED_FEE_CODE_SYSTEM_NAME=N'StrictDecision',@REQ_AUTHORIZED_FEE_DISPLAY_NAME=N'No',@REQ_CONTRACT_FEE_CODE=N'No',
@REQ_CONTRACT_FEE_CODE_SYSTEM=N'2.12.24.15',@REQ_CONTRACT_FEE_CODE_SYSTEM_NAME=N'StrictDecision',@REQ_CONTRACT_FEE_DISPLAY_NAME=N'No',@REQ_FEE_DISPOSITION_CODE=N'Non-Acute',
@REQ_FEE_DISPOSITION_CODE_SYSTEM=N'2.12.24.23',@REQ_FEE_DISPOSITION_CODE_SYSTEM_NAME=N'FeeDisposition',@REQ_FEE_DISPOSITION_DISPLAY_NAME=N'Non-Acute',@REQ_TYPE_OF_BED_WARD=N'Private', @REQ_IS_SCHEDULED_ADMISSION = 0,@REQ_VISTA_DIVISION=N'DIVISION 1',@REQ_REQUESTED_BED_NAME=NULL,@REQ_REQUESTED_BED_UID=NULL,@REQ_REQUESTED_BED_DATE=NULL,@REQ_ADDED_TO_WAITING_LIST=1,
@EVN_BED_NAME=NULL,@EVN_BED_UID=NULL,@EVN_WARD_NAME=NULL,@EVN_WARD_UID=NULL,@EVN_ATND_NURSE_SSN=NULL,@EVN_ATND_NURSE_LAST_NAME=NULL,@EVN_ATND_NURSE_FIRST_NAME=NULL,
@EVN_ATND_NURSE_MIDDLE_INITIAL=NULL,@EVN_ATND_NURSE_UID=NULL,@EVN_ADMISSION_DATE=NULL,@EVN_ENTERED_BY_SSN=NULL,@EVN_ENTERED_BY_LAST_NAME=NULL,@EVN_ENTERED_BY_FIRST_NAME=NULL,
@EVN_ENTERED_BY_MIDDLE_INITIAL=NULL,@EVN_ENTERED_BY_UID=NULL,@EVN_TYPE_OF_MOVEMENT_CODE=NULL,@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=NULL,
@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=NULL,@EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=NULL,@EVN_DIVISION_NAME = NULL, @EVN_DIVISION_UID= NULL,@OPERATION_TYPE=N'REQ'
-- EVENT
EXEC [BMS].[dbo].usp_Insert_Admission @ACT_ID=@P3 OUTPUT,@CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=@P2,@FLOW_ID=@F_ID,@DOMAIN_ID=N'InfoWorld',
@PATIENT_SSN=N'357-58-7531',@PATIENT_LAST_NAME=N'MORRIS',@PATIENT_FIRST_NAME=N'ANNA',@PATIENT_MIDDLE_INITIAL=N'T',@PATIENT_UID='2352483C-8A4B-4CCF-B516-59B4AD1F0D5F',
@PATIENT_GENDER_CODE=N'F',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',@PATIENT_GENDER_DISPLAY_NAME=N'Female',
@IEN=56232,@REQ_SIGNED_DATE=NULL,@REQ_RELEASED_DATE=NULL,@REQ_PROVIDER_SSN=NULL,@REQ_PROVIDER_LAST_NAME=NULL,@REQ_PROVIDER_FIRST_NAME=NULL,@REQ_PROVIDER_MIDDLE_INITIAL=NULL,
@REQ_PROVIDER_UID=NULL,@REQ_SCHEDULER_SSN=NULL,@REQ_SCHEDULER_LAST_NAME=NULL,@REQ_SCHEDULER_FIRST_NAME=NULL,@REQ_SCHEDULER_MIDDLE_INITIAL=NULL,@REQ_SCHEDULER_UID=NULL,
@REQ_SIGNED_BY_SSN=NULL,@REQ_SIGNED_BY_LAST_NAME=NULL,@REQ_SIGNED_BY_FIRST_NAME=NULL,@REQ_SIGNED_BY_MIDDLE_INITIAL=NULL,@REQ_SIGNED_BY_UID=NULL,
@REQ_FACILITY_NAME=NULL, @REQ_FACILITY_UID=NULL,
@REQ_WARD_NAME=NULL, @REQ_WARD_UID=NULL,@REQ_SPECIALITY_CODE=NULL, @REQ_SPECIALITY_CODE_SYSTEM=NULL,@REQ_SPECIALITY_CODE_SYSTEM_NAME=NULL, @REQ_SPECIALITY_DISPLAY_NAME=NULL,
@REQ_DIAGNOSIS=NULL, @REQ_LENGTH_OF_STAY_EXPECTED=NULL,@REQ_ORDER_TEXT=NULL,@REQ_SURGERY=NULL,@REQ_PROBLEM=NULL,@REQ_FEE_COMMENTS=NULL,@REQ_IS_ACUTE=NULL,@REQ_REMOVED_DATE=NULL,
@REQ_WAITING_AREA_CODE=NULL,@REQ_WAITING_AREA_CODE_SYSTEM=NULL,@REQ_WAITING_AREA_CODE_SYSTEM_NAME=NULL,
@REQ_WAITING_AREA_DISPLAY_NAME=NULL,@REQ_REASON_USING_FEE_CODE=NULL,@REQ_REASON_USING_FEE_CODE_SYSTEM=NULL,
@REQ_REASON_USING_FEE_CODE_SYSTEM_NAME=NULL,@REQ_REASON_USING_FEE_DISPLAY_NAME=NULL,@REQ_SERVICE_RECEIVING_FEE_CODE=NULL,
@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM=NULL,@REQ_SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME=NULL,@REQ_SERVICE_RECEIVING_FEE_DISPLAY_NAME=NULL,
@REQ_AUTHORIZED_FEE_CODE=NULL,@REQ_AUTHORIZED_FEE_CODE_SYSTEM=NULL,@REQ_AUTHORIZED_FEE_CODE_SYSTEM_NAME=NULL,@REQ_AUTHORIZED_FEE_DISPLAY_NAME=NULL,
@REQ_CONTRACT_FEE_CODE=NULL,@REQ_CONTRACT_FEE_CODE_SYSTEM=NULL,@REQ_CONTRACT_FEE_CODE_SYSTEM_NAME=NULL,@REQ_CONTRACT_FEE_DISPLAY_NAME=NULL,
@REQ_FEE_DISPOSITION_CODE=NULL,@REQ_FEE_DISPOSITION_CODE_SYSTEM=NULL,@REQ_FEE_DISPOSITION_CODE_SYSTEM_NAME=NULL,@REQ_FEE_DISPOSITION_DISPLAY_NAME=NULL,@REQ_TYPE_OF_BED_WARD=NULL,@REQ_IS_SCHEDULED_ADMISSION = 0,@REQ_VISTA_DIVISION=NULL,@REQ_REQUESTED_BED_NAME=NULL,@REQ_REQUESTED_BED_UID=NULL,@REQ_REQUESTED_BED_DATE=NULL,@REQ_ADDED_TO_WAITING_LIST=NULL,
@EVN_BED_NAME=@BED3_NAME,@EVN_BED_UID=@BED3_UID,@EVN_WARD_NAME=@WARD2_NAME,@EVN_WARD_UID=@WARD2_UID,
@EVN_ATND_NURSE_SSN=N'258-52-8521',@EVN_ATND_NURSE_LAST_NAME=N'SCOTT',@EVN_ATND_NURSE_FIRST_NAME=N'JOSHUA',@EVN_ATND_NURSE_MIDDLE_INITIAL=N'R',
@EVN_ATND_NURSE_UID='FC053196-03B3-44BA-8B57-58D092396599',@EVN_ADMISSION_DATE=@DATE_NOW,
@EVN_ENTERED_BY_SSN=N'258-52-8521',@EVN_ENTERED_BY_LAST_NAME=N'SCOTT',@EVN_ENTERED_BY_FIRST_NAME=N'JOSHUA',@EVN_ENTERED_BY_MIDDLE_INITIAL=N'R',
@EVN_ENTERED_BY_UID='FC053196-03B3-44BA-8B57-58D092396599',@EVN_TYPE_OF_MOVEMENT_CODE=N'OptNsc',@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=N'2.12.24.43',
@EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=N'TypeOfMovement',@EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=N'OPT-NSC',
@EVN_DIVISION_NAME = @DIVISION_NAME, @EVN_DIVISION_UID=@DIVISION_UID,@OPERATION_TYPE=N'EVN'
-- DISCHARGE
--INTENT
SET @P1 = NULL
EXEC [BMS].[dbo].usp_Insert_Discharge @ACT_ID=@P1 OUTPUT, @CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=NULL,
@FLOW_ID=@F_ID,@DOMAIN_ID=N'InfoWorld',@PATIENT_SSN=N'357-58-7531',@PATIENT_LAST_NAME=N'MORRIS',@PATIENT_FIRST_NAME=N'ANNA',@PATIENT_MIDDLE_INITIAL=N'T',
@PATIENT_UID='2352483C-8A4B-4CCF-B516-59B4AD1F0D5F',@PATIENT_GENDER_CODE=N'F',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Female',@IEN=72632,@INT_APPOINTMENT_DATE=NULL,@INT_FACILITY_NAME=@FACILITY_NAME,@INT_FACILITY_UID=@FACILITY_UID,
@INT_STATUS=N'ACTIVE',
@REQ_RELEASED_DATE=@DATE_NOW,@REQ_SIGNED_DATE=@DATE_NOW,@REQ_SIGNED_BY_SSN=N'123-23-3211',@REQ_SIGNED_BY_LAST_NAME=N'JOHNSON',@REQ_SIGNED_BY_FIRST_NAME=N'MICHAEL',
@REQ_SIGNED_BY_MIDDLE_INITIAL=N'M',@REQ_SIGNED_BY_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',@REQ_PROVIDER_SSN=N'078-05-1120', 
@REQ_PROVIDER_LAST_NAME=N'SMITH', @REQ_PROVIDER_FIRST_NAME=N'JOHN', @REQ_PROVIDER_MIDDLE_INITIAL=N'A', @REQ_PROVIDER_UID='A45DA8B7-B69B-4E27-8E7B-9832656A1DEC',
@REQ_SCHEDULER_SSN=N'123-23-3211',@REQ_SCHEDULER_LAST_NAME=N'JOHNSON',@REQ_SCHEDULER_FIRST_NAME=N'MICHAEL',@REQ_SCHEDULER_MIDDLE_INITIAL=N'M',
@REQ_SCHEDULER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_FACILITY_NAME=@FACILITY_NAME, @REQ_FACILITY_UID=@FACILITY_UID,@REQ_ORDER_TEXT=NULL,
@EVN_WARD_NAME=NULL,@EVN_WARD_UID=NULL,@EVN_BED_NAME=NULL,@EVN_BED_UID=NULL,@EVN_DISCHARGED_DATE=NULL, 
@EVN_TYPE_OF_MOVEMENT_CODE=NULL, @EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=NULL, @EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=NULL, @EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=NULL, 
@EVN_ENTERED_BY_SSN=NULL, @EVN_ENTERED_BY_LAST_NAME=NULL,@EVN_ENTERED_BY_FIRST_NAME=NULL, @EVN_ENTERED_BY_MIDDLE_INITIAL=NULL, @EVN_ENTERED_BY_UID=NULL,
@OPERATION_TYPE=N'INT'
--REQUEST
SET @P2 = NULL
EXEC [BMS].[dbo].usp_Insert_Discharge @ACT_ID=@P2 OUTPUT, @CREATION_DATE=@DATE_NOW,@CANCELED_DATE=NULL,@PARENT_ACT_ID=@P1,
@FLOW_ID=@F_ID,@DOMAIN_ID=N'InfoWorld',@PATIENT_SSN=N'357-58-7531',@PATIENT_LAST_NAME=N'MORRIS',@PATIENT_FIRST_NAME=N'ANNA',@PATIENT_MIDDLE_INITIAL=N'T',
@PATIENT_UID='2352483C-8A4B-4CCF-B516-59B4AD1F0D5F',@PATIENT_GENDER_CODE=N'F',@PATIENT_GENDER_CODE_SYSTEM=N'2.16.840.1.113883.5.1',@PATIENT_GENDER_CODE_SYSTEM_NAME=N'Gender',
@PATIENT_GENDER_DISPLAY_NAME=N'Female',@IEN=72632,@INT_APPOINTMENT_DATE=NULL,@INT_FACILITY_NAME=@FACILITY_NAME,@INT_FACILITY_UID=@FACILITY_UID,
@INT_STATUS=N'ACTIVE',
@REQ_RELEASED_DATE=@DATE_NOW,@REQ_SIGNED_DATE=@DATE_NOW,@REQ_SIGNED_BY_SSN=N'123-23-3211',@REQ_SIGNED_BY_LAST_NAME=N'JOHNSON',@REQ_SIGNED_BY_FIRST_NAME=N'MICHAEL',
@REQ_SIGNED_BY_MIDDLE_INITIAL=N'M',@REQ_SIGNED_BY_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',@REQ_PROVIDER_SSN=N'078-05-1120', 
@REQ_PROVIDER_LAST_NAME=N'SMITH', @REQ_PROVIDER_FIRST_NAME=N'JOHN', @REQ_PROVIDER_MIDDLE_INITIAL=N'A', @REQ_PROVIDER_UID='A45DA8B7-B69B-4E27-8E7B-9832656A1DEC',
@REQ_SCHEDULER_SSN=N'123-23-3211',@REQ_SCHEDULER_LAST_NAME=N'JOHNSON',@REQ_SCHEDULER_FIRST_NAME=N'MICHAEL',@REQ_SCHEDULER_MIDDLE_INITIAL=N'M',
@REQ_SCHEDULER_UID='7CA376FF-7725-4F4C-AEE1-8BC93B0CA427',
@REQ_FACILITY_NAME=@FACILITY_NAME, @REQ_FACILITY_UID=@FACILITY_UID,@REQ_ORDER_TEXT=NULL,
@EVN_WARD_NAME=NULL,@EVN_WARD_UID=NULL,@EVN_BED_NAME=NULL,@EVN_BED_UID=NULL,@EVN_DISCHARGED_DATE=NULL, 
@EVN_TYPE_OF_MOVEMENT_CODE=NULL, @EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM=NULL, @EVN_TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME=NULL, @EVN_TYPE_OF_MOVEMENT_DISPLAY_NAME=NULL, 
@EVN_ENTERED_BY_SSN=NULL, @EVN_ENTERED_BY_LAST_NAME=NULL,@EVN_ENTERED_BY_FIRST_NAME=NULL, @EVN_ENTERED_BY_MIDDLE_INITIAL=NULL, @EVN_ENTERED_BY_UID=NULL,
@OPERATION_TYPE=N'REQ'

COMMIT TRAN
--ROLLBACK TRAN
