BEGIN TRAN

BEGIN TRY

	use $(varBMS)
	-- to be run on BMS database 
	DECLARE @DB_NAME NVARCHAR(150)
	DECLARE @SQL_TRG NVARCHAR(MAX)
	SET @DB_NAME = '$(varBMS_HISTORY)'

	print 'Start altering triggers.'

	--Table=Act, Trigger=utg_ACT_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_ACT_AfterInsert] 
	   ON  [dbo].[ACT] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[ACT_H]
				   (ID, PATIENT_ID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, PATIENT_ID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_ACT_AfterInsert trigger altered.'

	--Table=Act, Trigger=utg_ACT_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_ACT_AfterUpdate] 
	   ON  [dbo].[ACT] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
	    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		   INSERT INTO ' + @DB_NAME + '.[dbo].[ACT_H]
				   (ID, PATIENT_ID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, PATIENT_ID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_ACT_AfterUpdate trigger altered.'

	--Table=Act, Trigger=utg_ACT_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_ACT_AfterDelete] 
	   ON  [dbo].[ACT] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		  INSERT INTO ' + @DB_NAME + '.[dbo].[ACT_H]
				   (ID, PATIENT_ID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, PATIENT_ID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_ACT_AfterDelete trigger altered.'

	--Table=Action, Trigger=utg_Action_AfterInsert
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Action_AfterInsert] 
	   ON  [dbo].[ACTION] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		  INSERT INTO ' + @DB_NAME + '.[dbo].[ACTION_H]
				   (ID, NAME, IS_GROUP, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, IS_GROUP, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_AfterInsert trigger altered.'

	--Table=Action, Trigger=utg_Action_AfterUpdate
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Action_AfterUpdate] 
	   ON  [dbo].[ACTION] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';    

		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		  INSERT INTO ' + @DB_NAME + '.[dbo].[Action_H]
				   (ID, NAME, IS_GROUP, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, IS_GROUP, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_AfterUpdate trigger altered.'

	--Table=Action, Trigger=utg_Action_AfterDelete
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Action_AfterDelete] 
	   ON  [dbo].[ACTION] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		  INSERT INTO ' + @DB_NAME + '.[dbo].[Action_H]
				   (ID, NAME, IS_GROUP, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, IS_GROUP, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_AfterDelete trigger altered.'

	--Table=Action_All, Trigger=utg_Action_All_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Action_All_AfterInsert] 
	   ON  [dbo].[ACTION_ALL] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Action_All_H]
				   (ID, NAME, PARENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, PARENT, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_All_AfterInsert trigger altered.'

	--Table=Action_All, Trigger=utg_Action_All_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Action_All_AfterUpdate] 
	   ON  [dbo].[ACTION_ALL] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
	    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[Action_All_H]
				   (ID, NAME, PARENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, PARENT, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_All_AfterUpdate trigger altered.'

	--Table=Action_All, Trigger=utg_Action_All_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Action_All_AfterDelete] 
	   ON  [dbo].[ACTION_ALL] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Action_All_H]
				   (ID, NAME, PARENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, PARENT, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_All_AfterDelete trigger altered.'

	--Table=Action_Group, Trigger=utg_Action_Group_AfterInsert
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Action_Group_AfterInsert] 
	   ON  [dbo].[ACTION_GROUP] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
    		INSERT INTO ' + @DB_NAME + '.[dbo].[Action_Group_H]
				   (GROUP_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT GROUP_ID, ACTION_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_Group_AfterInsert trigger altered.'

	--Table=Action_Group, Trigger=utg_Action_Group_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Action_Group_AfterUpdate] 
	   ON  [dbo].[ACTION_GROUP] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';

		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[Action_Group_H]
				   (GROUP_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT GROUP_ID, ACTION_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
			

	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_Group_AfterUpdate trigger altered.'

	--Table=Action_Group, Trigger=utg_Action_Group_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Action_Group_AfterDelete] 
	   ON  [dbo].[ACTION_GROUP] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Action_Group_H]
				   (GROUP_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT GROUP_ID, ACTION_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Action_Group_AfterDelete trigger altered.'

	--Table=Admission_Evn, Trigger=utg_Admission_Evn_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Admission_Evn_AfterInsert] 
	   ON  [dbo].[ADMISSION_EVN] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Admission_Evn_H]
				   (ACT_ID, BED_ID, WARD_ID, ATND_NURSE_ID, ADMISSION_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, BED_ID, WARD_ID, ATND_NURSE_ID, ADMISSION_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Admission_Evn_AfterInsert trigger altered.'

	--Table=Admission_Evn, Trigger=utg_Admission_Evn_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Admission_Evn_AfterUpdate] 
	   ON  [dbo].[ADMISSION_EVN] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 BEGIN
		   INSERT INTO ' + @DB_NAME + '.[dbo].[Admission_Evn_H]
				   (ACT_ID, BED_ID, WARD_ID, ATND_NURSE_ID, ADMISSION_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, BED_ID, WARD_ID, ATND_NURSE_ID, ADMISSION_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
		 END		

	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Admission_Evn_AfterUpdate trigger altered.'

	--Table=Admission_Evn, Trigger=utg_Admission_Evn_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Admission_Evn_AfterDelete] 
	   ON  [dbo].[ADMISSION_EVN] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Admission_Evn_H]
				   (ACT_ID, BED_ID, WARD_ID, ATND_NURSE_ID, ADMISSION_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, BED_ID, WARD_ID, ATND_NURSE_ID, ADMISSION_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
			
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Admission_Evn_AfterDelete trigger altered.'

	--Table=Admission_Req, Trigger=utg_Admission_Req_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Admission_Req_AfterInsert] 
	   ON  [dbo].[ADMISSION_REQ] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Admission_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, WARD_ID, SPECIALITY_ID, DIAGNOSIS, SURGERY,								LENGTH_OF_STAY_EXPECTED, ORDER_TEXT, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID,					REASON_USING_FEE_ID, FEE_COMMENTS, IS_ACUTE, REMOVED_DATE, TYPE_OF_BED_WARD, IS_SCHEDULED_ADMISSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,
				VISTA_DIVISION, REQUESTED_BED_ID, REQUESTED_BED_DATE, ADDED_TO_WAITING_LIST)
			SELECT	ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, WARD_ID, SPECIALITY_ID, DIAGNOSIS, SURGERY,								LENGTH_OF_STAY_EXPECTED, ORDER_TEXT, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID,					REASON_USING_FEE_ID, FEE_COMMENTS, IS_ACUTE, REMOVED_DATE, TYPE_OF_BED_WARD, IS_SCHEDULED_ADMISSION, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),
					VISTA_DIVISION, REQUESTED_BED_ID, REQUESTED_BED_DATE, ADDED_TO_WAITING_LIST
			FROM inserted; 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Admission_Req_AfterInsert trigger altered.'

	--Table=Admission_Req, Trigger=utg_Admission_Req_AfterUpdate
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Admission_Req_AfterUpdate] 
	   ON  [dbo].[ADMISSION_REQ] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[Admission_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, WARD_ID, SPECIALITY_ID, DIAGNOSIS, SURGERY,								LENGTH_OF_STAY_EXPECTED, ORDER_TEXT, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID,					REASON_USING_FEE_ID, FEE_COMMENTS, IS_ACUTE, REMOVED_DATE, TYPE_OF_BED_WARD, IS_SCHEDULED_ADMISSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,
				VISTA_DIVISION, REQUESTED_BED_ID, REQUESTED_BED_DATE, ADDED_TO_WAITING_LIST)
			SELECT	ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, WARD_ID, SPECIALITY_ID, DIAGNOSIS, SURGERY,								LENGTH_OF_STAY_EXPECTED, ORDER_TEXT, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID,					REASON_USING_FEE_ID, FEE_COMMENTS, IS_ACUTE, REMOVED_DATE, TYPE_OF_BED_WARD, IS_SCHEDULED_ADMISSION, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),
					VISTA_DIVISION, REQUESTED_BED_ID, REQUESTED_BED_DATE, ADDED_TO_WAITING_LIST
			FROM inserted;	
			

	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Admission_Req_AfterUpdate trigger altered.'

	--Table=Admission_Req, Trigger=utg_Admission_Req_AfterDelete
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Admission_Req_AfterDelete] 
	   ON  [dbo].[ADMISSION_REQ] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Admission_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, WARD_ID, SPECIALITY_ID, DIAGNOSIS, SURGERY,								LENGTH_OF_STAY_EXPECTED, ORDER_TEXT, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID,					REASON_USING_FEE_ID,FEE_COMMENTS, IS_ACUTE, REMOVED_DATE, TYPE_OF_BED_WARD, IS_SCHEDULED_ADMISSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,
				VISTA_DIVISION, REQUESTED_BED_ID, REQUESTED_BED_DATE, ADDED_TO_WAITING_LIST)
			SELECT	ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, WARD_ID, SPECIALITY_ID, DIAGNOSIS, SURGERY,								LENGTH_OF_STAY_EXPECTED, ORDER_TEXT, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID,					REASON_USING_FEE_ID, FEE_COMMENTS, IS_ACUTE, REMOVED_DATE, TYPE_OF_BED_WARD, IS_SCHEDULED_ADMISSION, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),
					VISTA_DIVISION, REQUESTED_BED_ID, REQUESTED_BED_DATE, ADDED_TO_WAITING_LIST
			FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Admission_Req_AfterDelete trigger altered.'

	--Table=Bed_Clean, Trigger=utg_Bed_Clean_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Bed_Clean_AfterInsert] 
	   ON  [dbo].[BED_CLEAN] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
    		INSERT INTO ' + @DB_NAME + '.[dbo].[Bed_Clean_H]
				   (ACT_ID, BED_ID, WARD_ID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, DIVISION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, BED_ID, WARD_ID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, DIVISION_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Bed_Clean_AfterInsert trigger altered.'

	--Table=Bed_Clean, Trigger=utg_Bed_Clean_AfterUpdate
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Bed_Clean_AfterUpdate] 
	   ON  [dbo].[BED_CLEAN] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Bed_Clean_H]
				   (ACT_ID, BED_ID, WARD_ID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, DIVISION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, BED_ID, WARD_ID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, DIVISION_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Bed_Clean_AfterUpdate trigger altered.'

	--Table=Bed_Clean, Trigger=utg_Bed_Clean_AfterDelete
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Bed_Clean_AfterDelete] 
	   ON  [dbo].[BED_CLEAN] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 BEGIN 
			INSERT INTO ' + @DB_NAME + '.[dbo].[Bed_Clean_H]
				   (ACT_ID, BED_ID, WARD_ID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, DIVISION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, BED_ID, WARD_ID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, DIVISION_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		 END		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Bed_Clean_AfterDelete trigger altered.'

	--Table=Bed_Clean, Trigger=utg_Bed_Unavailable_AfterInsert
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Bed_Unavailable_AfterInsert] 
	   ON  [dbo].[BED_UNAVAILABLE] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[Bed_Unavailable_H]
				   (ACT_ID, WARD_ID, BED_ID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, CREATION_BY, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
					DIVISION_ID, FACILITY_ID)
				SELECT ACT_ID, WARD_ID, BED_ID, TYPE_ID, REASON_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE,
						DIVISION_ID, FACILITY_ID
				FROM inserted;
  
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Bed_Unavailable_AfterInsert trigger altered.'

	--Table=Bed_Clean, Trigger=utg_Bed_Unavailable_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Bed_Unavailable_AfterUpdate] 
	   ON  [dbo].[BED_UNAVAILABLE] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		   INSERT INTO ' + @DB_NAME + '.[dbo].[Bed_Unavailable_H]
				   (ACT_ID, WARD_ID, BED_ID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,  CREATION_BY, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
					DIVISION_ID, FACILITY_ID)
				SELECT ACT_ID, WARD_ID, BED_ID, TYPE_ID, REASON_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE,
						DIVISION_ID, FACILITY_ID
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Bed_Unavailable_AfterUpdate trigger altered.'

	--Table=Bed_Clean, Trigger=utg_Bed_Unavailable_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Bed_Unavailable_AfterDelete] 
	   ON  [dbo].[BED_UNAVAILABLE] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 BEGIN 
			INSERT INTO ' + @DB_NAME + '.[dbo].[Bed_Unavailable_H]
				   (ACT_ID, WARD_ID, BED_ID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,CREATION_BY, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
					DIVISION_ID, FACILITY_ID)
				SELECT ACT_ID, WARD_ID, BED_ID, TYPE_ID, REASON_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE,
						DIVISION_ID, FACILITY_ID
				FROM deleted;
		 END		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Bed_Unavailable_AfterDelete trigger altered.'

	--Table=Concept, Trigger=utg_Concept_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Concept_AfterInsert] 
	   ON  [dbo].[CONCEPT] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Concept_H]
				   (ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
       
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Concept_AfterInsert trigger altered.'

	--Table=Concept, Trigger=utg_Concept_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Concept_AfterUpdate] 
	   ON  [dbo].[CONCEPT] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[Concept_H]
				   (ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Concept_AfterUpdate trigger altered.'

	--Table=Concept, Trigger=utg_Concept_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Concept_AfterDelete] 
	   ON  [dbo].[CONCEPT] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Concept_H]
				   (ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Concept_AfterDelete trigger altered.'

	--Table=Config, Trigger=utg_Config_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Config_AfterInsert] 
	   ON  [dbo].[CONFIG] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Config_H]
				   (ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
      
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_AfterInsert trigger altered.'

	--Table=Config, Trigger=utg_Config_AfterUpdate
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Config_AfterUpdate] 
	   ON  [dbo].[CONFIG] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[Config_H]
				   (ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_AfterUpdate trigger altered.'

	--Table=Config, Trigger=utg_Config_AfterDelete
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Config_AfterDelete] 
	   ON  [dbo].[CONFIG] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Config_H]
				   (ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_AfterDelete trigger altered.'

	--Table=Config_EIS, Trigger=utg_Config_EIS_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Config_EIS_AfterInsert] 
	   ON  [dbo].[CONFIG_EIS] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Config_EIS_H]
				   (ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_EIS_AfterInsert trigger altered.'

	--Table=Config_EIS, Trigger=utg_Config_EIS_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Config_EIS_AfterUpdate] 
	   ON  [dbo].[CONFIG_EIS] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Config_EIS_H]
				   (ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_EIS_AfterUpdate trigger altered.'

	--Table=Config_EIS, Trigger=utg_Config_EIS_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Config_EIS_AfterDelete] 
	   ON  [dbo].[CONFIG_EIS] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Config_EIS_H]
				   (ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_EIS_AfterDelete trigger altered.'

	--Table=Config_EVS, Trigger=utg_Config_EVS_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Config_EVS_AfterInsert] 
	   ON  [dbo].[CONFIG_EVS] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Config_EVS_H]
				   (ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
       
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_EVS_AfterInsert trigger altered.'

	--Table=Config_EVS, Trigger=utg_Config_EVS_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Config_EVS_AfterUpdate] 
	   ON  [dbo].[CONFIG_EVS] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
	
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Config_EVS_H]
				   (ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_EVS_AfterUpdate trigger altered.'

	--Table=Config_EVS, Trigger=utg_Config_EVS_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Config_EVS_AfterDelete] 
	   ON  [dbo].[CONFIG_EVS] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Config_EVS_H]
				   (ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Config_EVS_AfterDelete trigger altered.'

	--Table=Discharge_EVN, Trigger=utg_Discharge_Evn_AfterInsert
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Discharge_Evn_AfterInsert] 
	   ON  [dbo].[DISCHARGE_EVN] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
    		INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Evn_H]
				   (ACT_ID, WARD_ID, BED_ID, DISCHARGED_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, WARD_ID, BED_ID, DISCHARGED_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Evn_AfterInsert trigger altered.'

	--Table=Discharge_EVN, Trigger=utg_Discharge_Evn_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Discharge_Evn_AfterUpdate] 
	   ON  [dbo].[DISCHARGE_EVN] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		   INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Evn_H]
				   (ACT_ID, WARD_ID, BED_ID, DISCHARGED_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, WARD_ID, BED_ID, DISCHARGED_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()  
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Evn_AfterUpdate trigger altered.'

	--Table=Discharge_EVN, Trigger=utg_Discharge_Evn_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Discharge_Evn_AfterDelete] 
	   ON  [dbo].[DISCHARGE_EVN] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Evn_H]
				   (ACT_ID, WARD_ID, BED_ID, DISCHARGED_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, WARD_ID, BED_ID, DISCHARGED_DATE, ENTERED_BY_ID, TYPE_OF_MOVEMENT_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Evn_AfterDelete trigger altered.'

	--Table=Discharge_INT, Trigger=utg_Discharge_Int_AfterInsert
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Discharge_Int_AfterInsert] 
	   ON  [dbo].[DISCHARGE_INT] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Int_H]
				   (ACT_ID, APPOINTMENT_DATE, FACILITY_ID, STATUS, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, APPOINTMENT_DATE, FACILITY_ID, STATUS, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Int_AfterInsert trigger altered.'

	--Table=Discharge_INT, Trigger=utg_Discharge_Int_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Discharge_Int_AfterUpdate] 
	   ON  [dbo].[DISCHARGE_INT] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Int_H]
				   (ACT_ID, APPOINTMENT_DATE, FACILITY_ID, STATUS, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, APPOINTMENT_DATE, FACILITY_ID, STATUS, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Int_AfterUpdate trigger altered.'

	--Table=Discharge_INT, Trigger=utg_Discharge_Int_AfterDelete
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Discharge_Int_AfterDelete] 
	   ON  [dbo].[DISCHARGE_INT] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
    		INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Int_H]
				   (ACT_ID, APPOINTMENT_DATE, FACILITY_ID, STATUS, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, APPOINTMENT_DATE, FACILITY_ID, STATUS, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Int_AfterDelete trigger altered.'

	--Table=Discharge_REQ, Trigger=utg_Discharge_Req_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Discharge_Req_AfterInsert] 
	   ON  [dbo].[DISCHARGE_REQ] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Req_AfterInsert trigger altered.'

	--Table=Discharge_REQ, Trigger=utg_Discharge_Req_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Discharge_Req_AfterUpdate] 
	   ON  [dbo].[DISCHARGE_REQ] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
	    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Req_AfterUpdate trigger altered.'

	--Table=Discharge_REQ, Trigger=utg_Discharge_Req_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Discharge_Req_AfterDelete] 
	   ON  [dbo].[DISCHARGE_REQ] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[Discharge_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Discharge_Req_AfterDelete trigger altered.'

	--Table=Diversion, Trigger=utg_Diversion_AfterInsert
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Diversion_AfterInsert] 
	   ON  [dbo].[DIVERSION] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50), @SQL NVARCHAR(MAX)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		  BEGIN
		  INSERT INTO ' + @DB_NAME + '.[dbo].[DIVERSION_H]
								(ID, FACILITY_ID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, TRANSACTION_TYPE_CODE, DATE, CREATED_BY) 
							 SELECT ID, FACILITY_ID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
							 FROM inserted
						 
		  END		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Diversion_AfterInsert trigger altered.'

	--Table=Diversion, Trigger=utg_Diversion_AfterUpdate
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Diversion_AfterUpdate] 
	   ON  [dbo].[DIVERSION] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';

		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[DIVERSION_H]
				   (ID, FACILITY_ID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, FACILITY_ID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Diversion_AfterUpdate trigger altered.'

	--Table=Diversion, Trigger=utg_Diversion_AfterDelete
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_Diversion_AfterDelete] 
	   ON  [dbo].[DIVERSION] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[DIVERSION_H]
				   (ID, FACILITY_ID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, FACILITY_ID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Diversion_AfterDelete trigger altered.'

	--Table=EIS_Entity, Trigger=utg_EIS_Entity_AfterInsert
	SET @SQL_TRG = 
	'ALTER TRIGGER [dbo].[utg_EIS_Entity_AfterInsert] 
	   ON  [dbo].[EIS_ENTITY] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Entity_H]
				   (ID, EIS_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, EIS_UID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
   
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Entity_AfterInsert trigger altered.'

	--Table=EIS_Entity, Trigger=utg_EIS_Entity_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Entity_AfterUpdate] 
	   ON  [dbo].[EIS_ENTITY] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Entity_H]
				   (ID, EIS_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, EIS_UID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Entity_AfterUpdate trigger altered.'

	--Table=EIS_Entity, Trigger=utg_EIS_Entity_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Entity_AfterDelete] 
	   ON  [dbo].[EIS_ENTITY] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Entity_H]
				   (ID, EIS_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, EIS_UID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Entity_AfterDelete trigger altered.'

	--Table=EIS_Organization, Trigger=utg_EIS_Organization_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Organization_AfterInsert] 
	   ON  [dbo].[EIS_ORGANIZATION] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Organization_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
   
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Organization_AfterInsert trigger altered.'

	--Table=EIS_Organization, Trigger=utg_EIS_Organization_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Organization_AfterUpdate] 
	   ON  [dbo].[EIS_ORGANIZATION] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Organization_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Organization_AfterUpdate trigger altered.'

	--Table=EIS_Organization, Trigger=utg_EIS_Organization_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Organization_AfterDelete] 
	   ON  [dbo].[EIS_ORGANIZATION] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Organization_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Organization_AfterDelete trigger altered.'

	--Table=EIS_Person, Trigger=utg_EIS_Person_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Person_AfterInsert] 
	   ON  [dbo].[EIS_PERSON] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Person_H]
				   (ID, GENDER_ID, SSN, LAST_NAME, FIRST_NAME, MIDDLE_INITIAL, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, GENDER_ID, SSN, LAST_NAME, FIRST_NAME, MIDDLE_INITIAL, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
   
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Person_AfterInsert trigger altered.'

	--Table=EIS_Person, Trigger=utg_EIS_Person_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Person_AfterUpdate] 
	   ON  [dbo].[EIS_PERSON] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
	    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		   INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Person_H]
				   (ID, GENDER_ID, SSN, LAST_NAME, FIRST_NAME, MIDDLE_INITIAL, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, GENDER_ID, SSN, LAST_NAME, FIRST_NAME, MIDDLE_INITIAL, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Person_AfterUpdate trigger altered.'

	--Table=EIS_Person, Trigger=utg_EIS_Person_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Person_AfterDelete] 
	   ON  [dbo].[EIS_PERSON] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Person_H]
				   (ID, GENDER_ID, SSN, LAST_NAME, FIRST_NAME, MIDDLE_INITIAL, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, GENDER_ID, SSN, LAST_NAME, FIRST_NAME, MIDDLE_INITIAL, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Person_AfterDelete trigger altered.'

	--Table=EIS_Place, Trigger=utg_EIS_Place_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Place_AfterInsert] 
	   ON  [dbo].[EIS_PLACE] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Place_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Place_AfterInsert trigger altered.'

	--Table=EIS_Place, Trigger=utg_EIS_Place_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Place_AfterUpdate] 
	   ON  [dbo].[EIS_PLACE] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Place_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Place_AfterUpdate trigger altered.'

	--Table=EIS_Place, Trigger=utg_EIS_Place_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_EIS_Place_AfterDelete] 
	   ON  [dbo].[EIS_PLACE] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[EIS_Place_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_EIS_Place_AfterDelete trigger altered.'

	--Table=Movement_Evn, Trigger=utg_Movement_Evn_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Movement_Evn_AfterInsert] 
	   ON  [dbo].[MOVEMENT_EVN] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Movement_Evn_H]
				   (ACT_ID, WARD_ID, BED_ID, IS_SPECIALITY_TRANSFER, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, WARD_ID, BED_ID, IS_SPECIALITY_TRANSFER, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Movement_Evn_AfterInsert trigger altered.'

	--Table=Movement_Evn, Trigger=utg_Movement_Evn_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Movement_Evn_AfterUpdate] 
	   ON  [dbo].[MOVEMENT_EVN] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[Movement_Evn_H]
				   (ACT_ID, WARD_ID, BED_ID, IS_SPECIALITY_TRANSFER, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, WARD_ID, BED_ID, IS_SPECIALITY_TRANSFER, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Movement_Evn_AfterUpdate trigger altered.'

	--Table=Movement_Evn, Trigger=utg_Movement_Evn_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Movement_Evn_AfterDelete] 
	   ON  [dbo].[MOVEMENT_EVN] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Movement_Evn_H]
				   (ACT_ID, WARD_ID, BED_ID, IS_SPECIALITY_TRANSFER, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, WARD_ID, BED_ID, IS_SPECIALITY_TRANSFER, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Movement_Evn_AfterDelete trigger altered.'

	--Table=Movement_Req, Trigger=utg_Movement_Req_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Movement_Req_AfterInsert] 
	   ON  [dbo].[MOVEMENT_REQ] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Movement_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Movement_Req_AfterInsert trigger altered.'

	--Table=Movement_Req, Trigger=utg_Movement_Req_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Movement_Req_AfterUpdate] 
	   ON  [dbo].[MOVEMENT_REQ] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
        
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
			INSERT INTO ' + @DB_NAME + '.[dbo].[Movement_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Movement_Req_AfterUpdate trigger altered.'

	--Table=Movement_Req, Trigger=utg_Movement_Req_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Movement_Req_AfterDelete] 
	   ON  [dbo].[MOVEMENT_REQ] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Movement_Req_H]
				   (ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, SIGNED_BY_ID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_ID, PROVIDER_ID, FACILITY_ID, ORDER_TEXT, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Movement_Req_AfterDelete trigger altered.'

	--Table=Permission, Trigger=utg_Permission_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Permission_AfterInsert] 
	   ON  [dbo].[PERMISSION] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Permission_H]
				   (ID, RESOURCE_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, RESOURCE_ID, ACTION_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
   
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Permission_AfterInsert trigger altered.'

	--Table=Permission, Trigger=utg_Permission_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Permission_AfterUpdate] 
	   ON  [dbo].[PERMISSION] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[Permission_H]
				   (ID, RESOURCE_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, RESOURCE_ID, ACTION_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Permission_AfterUpdate trigger altered.'

	--Table=Permission, Trigger=utg_Permission_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Permission_AfterDelete] 
	   ON  [dbo].[PERMISSION] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Permission_H]
				   (ID, RESOURCE_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, RESOURCE_ID, ACTION_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Permission_AfterDelete trigger altered.'

	--Table=Policy, Trigger=utg_Policy_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Policy_AfterInsert] 
	   ON  [dbo].[POLICY] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Policy_H]
				   (PERMISSION_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT PERMISSION_ID, ROLE_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Policy_AfterInsert trigger altered.'

	--Table=Policy, Trigger=utg_Policy_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Policy_AfterUpdate] 
	   ON  [dbo].[POLICY] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
	    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[Policy_H]
				   (PERMISSION_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT PERMISSION_ID, ROLE_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Policy_AfterUpdate trigger altered.'

	--Table=Policy, Trigger=utg_Policy_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Policy_AfterDelete] 
	   ON  [dbo].[POLICY] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Policy_H]
				   (PERMISSION_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT PERMISSION_ID, ROLE_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Policy_AfterDelete trigger altered.'

	--Table=Resource, Trigger=utg_Resource_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Resource_AfterInsert] 
	   ON  [dbo].[RESOURCE] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Resource_H]
				   (ID, ROOT, EXTENSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, ROOT, EXTENSION, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Resource_AfterInsert trigger altered.'

	--Table=Resource, Trigger=utg_Resource_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Resource_AfterUpdate] 
	   ON  [dbo].[RESOURCE] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    	    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Resource_H]
				   (ID, ROOT, EXTENSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, ROOT, EXTENSION, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Resource_AfterUpdate trigger altered.'

	--Table=Resource, Trigger=utg_Resource_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Resource_AfterDelete] 
	   ON  [dbo].[RESOURCE] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Resource_H]
				   (ID, ROOT, EXTENSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, ROOT, EXTENSION, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Resource_AfterDelete trigger altered.'

	--Table=Role, Trigger=utg_Role_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Role_AfterInsert] 
	   ON  [dbo].[ROLE] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Role_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Role_AfterInsert trigger altered.'

	--Table=Role, Trigger=utg_Role_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Role_AfterUpdate] 
	   ON  [dbo].[ROLE] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[Role_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Role_AfterUpdate trigger altered.'

	--Table=Role, Trigger=utg_Role_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Role_AfterDelete] 
	   ON  [dbo].[ROLE] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Role_H]
				   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ID, NAME, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Role_AfterDelete trigger altered.'

	--Table=Security_Context, Trigger=utg_Security_Context_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Security_Context_AfterInsert] 
	   ON  [dbo].[SECURITY_CONTEXT] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Security_Context_H]
				   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Security_Context_AfterInsert trigger altered.'

	--Table=Security_Context, Trigger=utg_Security_Context_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Security_Context_AfterUpdate] 
	   ON  [dbo].[SECURITY_CONTEXT] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		  INSERT INTO ' + @DB_NAME + '.[dbo].[Security_Context_H]
				   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Security_Context_AfterUpdate trigger altered.'

	--Table=Security_Context, Trigger=utg_Security_Context_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Security_Context_AfterDelete] 
	   ON  [dbo].[SECURITY_CONTEXT] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Security_Context_H]
				   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
			
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Security_Context_AfterDelete trigger altered.'

	--Table=Transfer_Evn, Trigger=utg_Transfer_Evn_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Transfer_Evn_AfterInsert] 
	   ON  [dbo].[TRANSFER_EVN] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Transfer_Evn_H]
				   (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_ID, DISPOSITION_DATE,COMMENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_ID, DISPOSITION_DATE, COMMENT, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Transfer_Evn_AfterInsert trigger altered.'

	--Table=Transfer_Evn, Trigger=utg_Transfer_Evn_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Transfer_Evn_AfterUpdate] 
	   ON  [dbo].[TRANSFER_EVN] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Transfer_Evn_H]
				   (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_ID,DISPOSITION_DATE, COMMENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_ID, DISPOSITION_DATE, COMMENT, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	 
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Transfer_Evn_AfterUpdate trigger altered.'

	--Table=Transfer_Evn, Trigger=utg_Transfer_Evn_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Transfer_Evn_AfterDelete] 
	   ON  [dbo].[TRANSFER_EVN] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
     		INSERT INTO ' + @DB_NAME + '.[dbo].[Transfer_Evn_H]
				   (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_ID, DISPOSITION_DATE, COMMENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_ID, DISPOSITION_DATE, COMMENT, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Transfer_Evn_AfterDelete trigger altered.'

	--Table=Transfer_Req, Trigger=utg_Transfer_Req_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Transfer_Req_AfterInsert] 
	   ON  [dbo].[TRANSFER_REQ] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Transfer_Req_H]
				   (ACT_ID, ERA_ID, FACILITY_ID, SC_RATING, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, ERA_ID, FACILITY_ID, SC_RATING, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
    
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Transfer_Req_AfterInsert trigger altered.'

	--Table=Transfer_Req, Trigger=utg_Transfer_Req_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Transfer_Req_AfterUpdate] 
	   ON  [dbo].[TRANSFER_REQ] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Transfer_Req_H]
				   (ACT_ID, ERA_ID, FACILITY_ID, SC_RATING, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, ERA_ID, FACILITY_ID, SC_RATING, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Transfer_Req_AfterUpdate trigger altered.'

	--Table=Transfer_Req, Trigger=utg_Transfer_Req_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_Transfer_Req_AfterDelete] 
	   ON  [dbo].[TRANSFER_REQ] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[Transfer_Req_H]
				   (ACT_ID, ERA_ID, FACILITY_ID, SC_RATING, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT ACT_ID, ERA_ID, FACILITY_ID, SC_RATING, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_Transfer_Req_AfterDelete trigger altered.'

	--Table=User_Role, Trigger=utg_User_Role_AfterInsert
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_User_Role_AfterInsert] 
	   ON  [dbo].[USER_ROLE] 
	   AFTER INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[User_Role_H]
				   (USER_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT USER_ID, ROLE_ID, ''I'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
     
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_User_Role_AfterInsert trigger altered.'

	--Table=User_Role, Trigger=utg_User_Role_AfterUpdate
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_User_Role_AfterUpdate] 
	   ON  [dbo].[USER_ROLE] 
	   AFTER UPDATE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
	
		DECLARE @HISTORY_VALUE NVARCHAR(50)
    
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = ''HISTORY'';
	    
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
	 		INSERT INTO ' + @DB_NAME + '.[dbo].[User_Role_H]
				   (USER_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT USER_ID, ROLE_ID, ''U'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;
	
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_User_Role_AfterUpdate trigger altered.'

	--Table=User_Role, Trigger=utg_User_Role_AfterDelete
	SET @SQL_TRG =
	'ALTER TRIGGER [dbo].[utg_User_Role_AfterDelete] 
	   ON  [dbo].[USER_ROLE] 
	   AFTER DELETE
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		DECLARE @HISTORY_VALUE NVARCHAR(50)
	
		SELECT @HISTORY_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE UPPER(PARAMETER) = ''HISTORY'';
   
		IF (UPPER(@HISTORY_VALUE) = ''Y'')
		 INSERT INTO ' + @DB_NAME + '.[dbo].[User_Role_H]
				   (USER_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
				SELECT USER_ID, ROLE_ID, ''D'', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
			
	END'

	EXEC sp_executesql @SQL_TRG

	print 'utg_User_Role_AfterDelete trigger altered.'

	print 'End altering triggers.'

	--update history options table
	UPDATE OPTIONS 
	SET PARAMETER_VALUE = '$(varBMS_HISTORY)'
	WHERE PARAMETER = 'HISTORY_DATABASE'

END TRY
BEGIN CATCH
	DECLARE @ErrorMessage NVARCHAR(4000)
    DECLARE @ErrorSeverity INT
    DECLARE @ErrorState INT

    SELECT 
        @ErrorMessage = ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE()

	IF @@TRANCOUNT > 0
        ROLLBACK TRAN

    -- Use RAISERROR inside the CATCH block to return error
    -- information about the original error that caused
    -- execution to jump to the CATCH block.
    RAISERROR ('Failed with error: ' + @ErrorMessage, -- Message text.
               @ErrorSeverity, -- Severity.
               @ErrorState -- State.
               )
END CATCH

IF @@TRANCOUNT > 0
    COMMIT TRAN