CREATE TABLE [dbo].[WARD_LOCATION]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[SPECIALTY_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CURRENTLY_OUT_OF_SERVICE] [bit] NOT NULL,
[HOSPITAL_LOCATION_ID] [int] NOT NULL,
[SPECIALTY_ID] [int] NOT NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[WARD_LOCATION_tgg_delete]
   ON  dbo.WARD_LOCATION
   AFTER delete
AS 
BEGIN	
		insert into [dbo].[WARD_LOCATION_log]([ACTION], IEN, NAME, SPECIALTY_NAME, CURRENTLY_OUT_OF_SERVICE, HOSPITAL_LOCATION_ID, SPECIALTY_ID)
		select 'D', IEN, NAME, SPECIALTY_NAME, CURRENTLY_OUT_OF_SERVICE, HOSPITAL_LOCATION_ID, SPECIALTY_ID from deleted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[WARD_LOCATION_tgg_insert]
   ON  dbo.WARD_LOCATION
   AFTER INSERT
AS 
BEGIN	
		insert into [dbo].[WARD_LOCATION_log]([ACTION], IEN, NAME, SPECIALTY_NAME, CURRENTLY_OUT_OF_SERVICE, HOSPITAL_LOCATION_ID, SPECIALTY_ID)
		select 'I', IEN, NAME, SPECIALTY_NAME, CURRENTLY_OUT_OF_SERVICE, HOSPITAL_LOCATION_ID, SPECIALTY_ID from inserted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[WARD_LOCATION_tgg_update]
   ON  dbo.WARD_LOCATION
   AFTER update
AS 
BEGIN	
		insert into [dbo].[WARD_LOCATION_log]([ACTION], IEN, NAME, SPECIALTY_NAME, CURRENTLY_OUT_OF_SERVICE, HOSPITAL_LOCATION_ID, SPECIALTY_ID)
		select 'U', IEN, NAME, SPECIALTY_NAME, CURRENTLY_OUT_OF_SERVICE, HOSPITAL_LOCATION_ID, SPECIALTY_ID from inserted;
END
GO
ALTER TABLE [dbo].[WARD_LOCATION] ADD CONSTRAINT [PK_WARD_LOCATION] PRIMARY KEY CLUSTERED  ([IEN]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[WARD_LOCATION] ADD CONSTRAINT [FK_WARD_LOCATION_HOSPITAL_LOCATION] FOREIGN KEY ([HOSPITAL_LOCATION_ID]) REFERENCES [dbo].[HOSPITAL_LOCATION] ([IEN])
GO
ALTER TABLE [dbo].[WARD_LOCATION] ADD CONSTRAINT [FK_WARD_LOCATION_SPECIALTY] FOREIGN KEY ([SPECIALTY_ID]) REFERENCES [dbo].[SPECIALTY] ([IEN])
GO
EXEC sp_addextendedproperty N'MS_Description', N'The table contains data concerning ward locations.', 'SCHEMA', N'dbo', 'TABLE', N'WARD_LOCATION', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'True/False column for specifying if the ward location is currently out of service.', 'SCHEMA', N'dbo', 'TABLE', N'WARD_LOCATION', 'COLUMN', N'CURRENTLY_OUT_OF_SERVICE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the hospital location.', 'SCHEMA', N'dbo', 'TABLE', N'WARD_LOCATION', 'COLUMN', N'HOSPITAL_LOCATION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the ward location.', 'SCHEMA', N'dbo', 'TABLE', N'WARD_LOCATION', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the ward location.', 'SCHEMA', N'dbo', 'TABLE', N'WARD_LOCATION', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the specialty.', 'SCHEMA', N'dbo', 'TABLE', N'WARD_LOCATION', 'COLUMN', N'SPECIALTY_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The specialty name.', 'SCHEMA', N'dbo', 'TABLE', N'WARD_LOCATION', 'COLUMN', N'SPECIALTY_NAME'
GO
