IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_GetTimezoneByFacility]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ufn_GetTimezoneByFacility]
GO

/****** Object:  UserDefinedFunction [dbo].[ufn_GetTimezoneByFacility]    Script Date: 05/25/2012 16:32:42 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE FUNCTION [dbo].[ufn_GetTimezoneByFacility](@facility_uid varchar(250))
RETURNS varchar(50)
AS
BEGIN
	DECLARE @CODE varchar(50)
		
	SELECT @CODE = CODE
	FROM [dbo].[CONFIG_EVS_H] as CONFIG_EVS inner join [dbo].[CONFIG_H] as CONFIG
		ON CONFIG_EVS.CONFIG_ID = CONFIG.ID
	WHERE CONFIG_EVS.CODE_SYSTEM_NAME = 'TimeZone' and CONFIG.CONFIG_KEY = 'facilitysitetimezone'
		and CONFIG.SECTION = 'FacilitySettings ' + @facility_uid 

	RETURN @CODE

END

GO


