CREATE TABLE [dbo].[USER_ROLE_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[USER_ID] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ROLE_ID] [uniqueidentifier] NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[USER_ROLE_H] ADD CONSTRAINT [PK_USER_ROLE_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that associates user and their roles.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the role that is given to the user.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE_H', 'COLUMN', N'ROLE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the user.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE_H', 'COLUMN', N'USER_ID'
GO
