CREATE TABLE [dbo].[CONFIG_EIS_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[CONFIG_ID] [int] NOT NULL,
[ENTITY_ID] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ENTITY_NAME] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ENTITY_TYPE_ID] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE [dbo].[CONFIG_EIS_H] ADD CONSTRAINT [PK_CONFIG_EIS_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Entities configuration table.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the configuration.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'CONFIG_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the entity.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'ENTITY_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the entity.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'ENTITY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Entity''s type id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'ENTITY_TYPE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Entity configuration''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
