CREATE TABLE [dbo].[CONCEPT_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[CODE] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM_NAME] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DISPLAY_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[CONCEPT_H] ADD CONSTRAINT [PK_CONCEPT_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept table.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept - code.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept - code system.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'CODE_SYSTEM'
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept''s code system name.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'CODE_SYSTEM_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept''s code display name.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'DISPLAY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Identity number and primary key of transaction table.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
