CREATE TABLE [dbo].[BED_STAFF_H](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[BED_UID] [uniqueidentifier] NOT NULL,
	[DIVISION_UID] [uniqueidentifier] NOT NULL,
	[STAFF] [nvarchar](250) NOT NULL,
	[PATIENT_UID] [uniqueidentifier] NULL,
	[FACILITY_UID] [uniqueidentifier] NULL,
	[TRANSACTION_TYPE_CODE] [varchar](50) NOT NULL,
	[DATE] [datetime] NOT NULL,
	[CREATED_BY] [nvarchar](50) NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[BED_STAFF_H] ADD CONSTRAINT [PK_BED_STAFF_H] PRIMARY KEY CLUSTERED ([PK]) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_BED_UID]
ON [dbo].[BED_STAFF_H] ([BED_UID])
INCLUDE ([PK],[DIVISION_UID],[STAFF],[PATIENT_UID],[FACILITY_UID],[TRANSACTION_TYPE_CODE],[DATE],[CREATED_BY])
GO