CREATE TABLE [dbo].[ADMISSION_EVN_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ENTERED_DATE] DATETIME NOT NULL,
[BED_UID] [uniqueidentifier] NULL,
[WARD_UID] [uniqueidentifier] NULL,
[INITIAL_BED_UID] [UNIQUEIDENTIFIER] NULL,
[INITIAL_WARD_UID] [UNIQUEIDENTIFIER] NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[ATND_NURSE_UID] [uniqueidentifier] NULL,
[ADMISSION_DATE] [datetime] NULL,
[ENTERED_BY_UID] [uniqueidentifier] NULL,
[TYPE_OF_MOVEMENT_ID] [int] NULL,
[HAS_DISCHARGE] [BIT] NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] DATETIME NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ADMISSION_EVN_H] ADD CONSTRAINT [PK_ADMISSION_EVN_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Admission event table.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the patient was admitted.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'ADMISSION_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Medical personnel''s id.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'ATND_NURSE_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of bed where the patient was admitted.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the person who made the admission.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'ENTERED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the type of the admission(VistA data).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'TYPE_OF_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the ward where the patient was admitted.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The UTC date and time when the act was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'CREATION_UTC_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of admissions.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates if patient is discharged.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'HAS_DISCHARGE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of creation.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN_H', 'COLUMN', N'ENTERED_DATE'
GO